/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemHandler;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemRepository;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerStorageImpl;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import com.texelsaurus.minecraft.chameleon.capabilities.FabricCapability;
import com.texelsaurus.minecraft.chameleon.capabilities.IFabricCapability;
import com.texelsaurus.minecraft.chameleon.service.FabricCapabilities;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_2591;

public class PlatformCapabilities {
    public static final FabricCapability<IDrawerAttributes> DRAWER_ATTRIBUTES = new FabricCapability(Capabilities.DRAWER_ATTRIBUTES.id());
    public static final FabricCapability<IDrawerGroup> DRAWER_GROUP = new FabricCapability(Capabilities.DRAWER_GROUP.id());
    public static final FabricCapability<IItemRepository> ITEM_REPOSITORY = new FabricCapability(Capabilities.ITEM_REPOSITORY.id());
    public static final FabricCapability<IItemHandler> ITEM_HANDLER = new FabricCapability(Capabilities.ITEM_HANDLER.id());

    static <T> IFabricCapability<T> cast(ChameleonCapability<T> cap) {
        return (IFabricCapability)cap;
    }

    public static void initHandlers() {
        FabricCapabilities.reigsterCapability(DRAWER_ATTRIBUTES);
        FabricCapabilities.reigsterCapability(DRAWER_GROUP);
        FabricCapabilities.reigsterCapability(ITEM_REPOSITORY);
        FabricCapabilities.reigsterCapability(ITEM_HANDLER);
        ModBlockEntities.getDrawerTypes().forEach(entity -> {
            PlatformCapabilities.cast(Capabilities.DRAWER_ATTRIBUTES).register(entity, e -> BlockEntityDrawers.getDrawerAttributes(e));
            PlatformCapabilities.cast(Capabilities.DRAWER_GROUP).register(entity, e -> BlockEntityDrawers.getGroup(e));
            PlatformCapabilities.cast(Capabilities.ITEM_REPOSITORY).register(entity, DrawerItemRepository::new);
            PlatformCapabilities.cast(Capabilities.ITEM_HANDLER).register(entity, DrawerItemHandler::new);
        });
        PlatformCapabilities.cast(Capabilities.DRAWER_GROUP).register((class_2591)ModBlockEntities.CONTROLLER.get(), e -> e);
        PlatformCapabilities.cast(Capabilities.ITEM_REPOSITORY).register((class_2591)ModBlockEntities.CONTROLLER.get(), BlockEntityController::getItemRepository);
        PlatformCapabilities.cast(Capabilities.ITEM_HANDLER).register((class_2591)ModBlockEntities.CONTROLLER.get(), DrawerItemHandler::new);
        PlatformCapabilities.cast(Capabilities.DRAWER_GROUP).register((class_2591)ModBlockEntities.CONTROLLER_IO.get(), e -> e);
        PlatformCapabilities.cast(Capabilities.ITEM_REPOSITORY).register((class_2591)ModBlockEntities.CONTROLLER_IO.get(), BlockEntitySlave::getItemRepository);
        PlatformCapabilities.cast(Capabilities.ITEM_HANDLER).register((class_2591)ModBlockEntities.CONTROLLER_IO.get(), DrawerItemHandler::new);
        ItemStorage.SIDED.registerForBlockEntity((entity, dir) -> DrawerStorageImpl.of(entity), (class_2591)ModBlockEntities.STANDARD_DRAWERS_1.get());
        ItemStorage.SIDED.registerForBlockEntity((entity, dir) -> DrawerStorageImpl.of(entity), (class_2591)ModBlockEntities.STANDARD_DRAWERS_2.get());
        ItemStorage.SIDED.registerForBlockEntity((entity, dir) -> DrawerStorageImpl.of(entity), (class_2591)ModBlockEntities.STANDARD_DRAWERS_4.get());
        ItemStorage.SIDED.registerForBlockEntity((entity, dir) -> DrawerStorageImpl.of(entity), (class_2591)ModBlockEntities.FRACTIONAL_DRAWERS_3.get());
        ItemStorage.SIDED.registerForBlockEntity((entity, dir) -> DrawerStorageImpl.of(entity), (class_2591)ModBlockEntities.CONTROLLER.get());
        ItemStorage.SIDED.registerForBlockEntity((entity, dir) -> DrawerStorageImpl.of(entity), (class_2591)ModBlockEntities.CONTROLLER_IO.get());
    }
}

