/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.CustomNameData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerFramingTable;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import com.texelsaurus.minecraft.chameleon.inventory.content.PositionContent;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityFramingTable
extends BaseBlockEntity
implements class_3908 {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_SIDE = 1;
    public static final int SLOT_TRIM = 2;
    public static final int SLOT_FRONT = 3;
    public static final int SLOT_RESULT = 4;
    private final BlockInventory inventory;
    private final CustomNameData customNameData = new CustomNameData();
    private final MaterialData materialData = new MaterialData();
    protected class_1799 inputStack = class_1799.field_8037;
    protected class_1799 resultStack = class_1799.field_8037;

    public BlockEntityFramingTable(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
        this.injectPortableData(this.customNameData);
        this.injectData(this.materialData);
        this.inventory = new BlockInventory(this);
    }

    public BlockEntityFramingTable(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.FRAMING_TABLE.get(), pos, state);
    }

    public static boolean isMaterialSlot(int slotIndex) {
        return slotIndex == 1 || slotIndex == 2 || slotIndex == 3;
    }

    public MaterialData material() {
        return this.materialData;
    }

    public CustomNameData customName() {
        return this.customNameData;
    }

    public BlockInventory inventory() {
        return this.inventory;
    }

    @Override
    protected void readFixed(class_2487 tag) {
        super.readFixed(tag);
        this.inputStack = class_1799.field_8037;
        if (tag.method_10545("Input")) {
            this.inputStack = class_1799.method_7915((class_2487)tag.method_10562("Input"));
        }
        this.resultStack = class_1799.field_8037;
        if (tag.method_10545("Result")) {
            this.resultStack = class_1799.method_7915((class_2487)tag.method_10562("Result"));
        }
    }

    @Override
    protected class_2487 writeFixed(class_2487 tag) {
        class_2487 itag;
        tag = super.writeFixed(tag);
        if (!this.inputStack.method_7960()) {
            itag = new class_2487();
            this.inputStack.method_7953(itag);
            tag.method_10566("Input", (class_2520)itag);
        }
        if (!this.resultStack.method_7960()) {
            itag = new class_2487();
            this.resultStack.method_7953(itag);
            tag.method_10566("Result", (class_2520)itag);
        }
        return tag;
    }

    public boolean isItemValidTarget(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)class_17922;
        if (blockItem.method_7711() instanceof IFramedBlock) {
            MaterialData data = new MaterialData();
            data.read(stack.method_7948());
            if (!data.getSide().method_7960() && !this.materialData.getSide().method_7960()) {
                return false;
            }
            if (!data.getTrim().method_7960() && !this.materialData.getTrim().method_7960()) {
                return false;
            }
            return data.getFront().method_7960() || this.materialData.getFront().method_7960();
        }
        return blockItem.method_7711() instanceof IFramedSourceBlock;
    }

    public static boolean isItemValidMaterial(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)class_17922;
        class_2680 state = blockItem.method_7711().method_9564();
        return state.method_51367();
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.storagedrawers.framing_table");
    }

    @Nullable
    public class_1703 createMenu(int windowId, @NotNull class_1661 playInventory, @NotNull class_1657 player) {
        return new ContainerFramingTable((class_3917)ModContainers.FRAMING_TABLE.get(), windowId, playInventory, this);
    }

    public static class BlockInventory
    implements class_1263 {
        private BlockEntityFramingTable entity;

        private BlockInventory(BlockEntityFramingTable entity) {
            this.entity = entity;
        }

        public int method_5439() {
            return 5;
        }

        public boolean method_5442() {
            if (!this.entity.inputStack.method_7960()) {
                return false;
            }
            if (!this.entity.resultStack.method_7960()) {
                return false;
            }
            if (!this.entity.materialData.getSide().method_7960()) {
                return false;
            }
            if (!this.entity.materialData.getTrim().method_7960()) {
                return false;
            }
            return this.entity.materialData.getFront().method_7960();
        }

        public boolean method_5437(int slotIndex, class_1799 stack) {
            if (slotIndex == 0) {
                return this.entity.isItemValidTarget(stack);
            }
            if (slotIndex == 1 || slotIndex == 2 || slotIndex == 3) {
                return BlockEntityFramingTable.isItemValidMaterial(stack);
            }
            return false;
        }

        public class_1799 method_5438(int slot) {
            return switch (slot) {
                case 0 -> this.entity.inputStack;
                case 3 -> this.entity.materialData.getFront();
                case 1 -> this.entity.materialData.getSide();
                case 2 -> this.entity.materialData.getTrim();
                case 4 -> this.entity.resultStack;
                default -> null;
            };
        }

        public class_1799 method_5434(int slot, int amount) {
            if (slot < 0 || slot > this.method_5439() || amount <= 0) {
                return class_1799.field_8037;
            }
            class_1799 ret = this.method_5438(slot).method_7971(amount);
            this.rebuildResult();
            this.method_5431();
            return ret;
        }

        public class_1799 method_5441(int slot) {
            if (slot < 0 || slot > this.method_5439()) {
                return class_1799.field_8037;
            }
            class_1799 result = this.method_5438(slot);
            this.method_5447(slot, class_1799.field_8037);
            return result;
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot == 4) {
                return;
            }
            switch (slot) {
                case 0: {
                    this.setInputItem(stack);
                    break;
                }
                case 3: {
                    this.entity.materialData.setFront(stack);
                    break;
                }
                case 1: {
                    this.entity.materialData.setSide(stack);
                    break;
                }
                case 2: {
                    this.entity.materialData.setTrim(stack);
                }
            }
            this.rebuildResult();
            this.method_5431();
        }

        public void method_5431() {
        }

        private void setInputItem(class_1799 stack) {
            class_1747 blockItem;
            class_2248 block;
            class_1792 class_17922;
            if (this.entity.field_11863 != null && !stack.method_7960() && (class_17922 = stack.method_7909()) instanceof class_1747 && (block = (blockItem = (class_1747)class_17922).method_7711()) instanceof IFramedBlock) {
                IFramedBlock fb = (IFramedBlock)block;
                MaterialData data = new MaterialData();
                data.read(stack.method_7948());
                if (fb.supportsFrameMaterial(FrameMaterial.SIDE) && !this.entity.materialData.getSide().method_7960() && !data.getSide().method_7960()) {
                    this.entity.resultStack = stack;
                    return;
                }
                if (fb.supportsFrameMaterial(FrameMaterial.TRIM) && !this.entity.materialData.getTrim().method_7960() && !data.getTrim().method_7960()) {
                    this.entity.resultStack = stack;
                    return;
                }
                if (fb.supportsFrameMaterial(FrameMaterial.FRONT) && !this.entity.materialData.getFront().method_7960() && !data.getFront().method_7960()) {
                    this.entity.resultStack = stack;
                    return;
                }
                class_1799 source = data.getFrameBase();
                if (!source.method_7960()) {
                    source.method_7980(stack.method_7948().method_10553());
                    MaterialData empty = new MaterialData();
                    empty.write(source.method_7969());
                    int count = stack.method_7947();
                    this.entity.inputStack = source.method_46651(count);
                    this.entity.materialData.setSide(fb.supportsFrameMaterial(FrameMaterial.SIDE) ? data.getSide().method_46651(count) : class_1799.field_8037);
                    this.entity.materialData.setTrim(fb.supportsFrameMaterial(FrameMaterial.TRIM) ? data.getTrim().method_46651(count) : class_1799.field_8037);
                    this.entity.materialData.setFront(fb.supportsFrameMaterial(FrameMaterial.FRONT) ? data.getFront().method_46651(count) : class_1799.field_8037);
                    return;
                }
            }
            this.entity.inputStack = stack;
        }

        private void rebuildResult() {
            class_1747 blockItem;
            class_2248 block;
            class_1792 class_17922;
            class_1799 target = this.method_5438(0);
            if (target.method_7960()) {
                this.entity.resultStack = class_1799.field_8037;
                return;
            }
            class_1799 matSide = this.method_5438(1);
            class_1799 matTrim = this.method_5438(2);
            class_1799 matFront = this.method_5438(3);
            if (!target.method_7960() && (class_17922 = target.method_7909()) instanceof class_1747 && (block = (blockItem = (class_1747)class_17922).method_7711()) instanceof IFramedSourceBlock) {
                IFramedSourceBlock fsb = (IFramedSourceBlock)block;
                this.entity.resultStack = matSide.method_7960() ? class_1799.field_8037 : fsb.makeFramedItem(target, matSide, matTrim, matFront);
            }
            int count = this.entity.resultStack.method_7947();
            if (!matSide.method_7960()) {
                count = Math.min(count, matSide.method_7947());
            }
            if (!matTrim.method_7960()) {
                count = Math.min(count, matTrim.method_7947());
            }
            if (!matFront.method_7960()) {
                count = Math.min(count, matFront.method_7947());
            }
            this.entity.resultStack.method_7939(count);
        }

        public boolean method_5443(class_1657 player) {
            return class_1263.method_49105((class_2586)this.entity, (class_1657)player);
        }

        public void method_5448() {
            this.entity.inputStack = class_1799.field_8037;
            this.entity.resultStack = class_1799.field_8037;
            this.entity.materialData.clear();
        }
    }

    public static class ContentProvider
    implements ContentMenuProvider<PositionContent> {
        private BlockEntityFramingTable entity;

        public ContentProvider(BlockEntityFramingTable entity) {
            this.entity = entity;
        }

        @Override
        public PositionContent createContent(class_3222 player) {
            return new PositionContent(this.entity.method_11016());
        }

        public class_2561 method_5476() {
            if (this.entity.customNameData.hasCustomName()) {
                return this.entity.customNameData.getDisplayName();
            }
            return class_2561.method_43471((String)"container.storagedrawers.framing_table");
        }

        @Nullable
        public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
            return new ContainerFramingTable((class_3917)ModContainers.FRAMING_TABLE.get(), id, inventory, this.entity);
        }
    }
}

