/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityDrawersStandard
extends BlockEntityDrawers {
    public BlockEntityDrawersStandard(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    public static BlockEntityDrawersStandard createEntity(int slotCount, class_2338 pos, class_2680 state) {
        return switch (slotCount) {
            case 1 -> new Slot1(pos, state);
            case 2 -> new Slot2(pos, state);
            case 4 -> new Slot4(pos, state);
            default -> null;
        };
    }

    public static class Slot1
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(1);

        public Slot1(class_2338 pos, class_2680 state) {
            super((class_2591)ModBlockEntities.STANDARD_DRAWERS_1.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(2);

        public Slot2(class_2338 pos, class_2680 state) {
            super((class_2591)ModBlockEntities.STANDARD_DRAWERS_2.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot4
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(4);

        public Slot4(class_2338 pos, class_2680 state) {
            super((class_2591)ModBlockEntities.STANDARD_DRAWERS_4.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    private class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private final int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        @Override
        protected int getStackCapacity() {
            try {
                return Math.multiplyExact(BlockEntityDrawersStandard.this.upgrades().getStorageMultiplier(), BlockEntityDrawersStandard.this.getEffectiveDrawerCapacity());
            }
            catch (ArithmeticException e) {
                return Integer.MAX_VALUE;
            }
        }

        @Override
        protected void onItemChanged() {
            if (BlockEntityDrawersStandard.this.method_10997() != null && !BlockEntityDrawersStandard.this.method_10997().field_9236) {
                BlockEntityDrawersStandard.this.method_5431();
                BlockEntityDrawersStandard.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (BlockEntityDrawersStandard.this.method_10997() != null && !BlockEntityDrawersStandard.this.method_10997().field_9236) {
                BlockEntityDrawersStandard.this.syncClientCount(this.slot, this.getStoredItemCount());
                BlockEntityDrawersStandard.this.method_5431();
            }
        }
    }

    private class GroupData
    extends StandardDrawerGroup {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Override
        @NotNull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerData(this, slot);
        }

        @Override
        public boolean isGroupValid() {
            return BlockEntityDrawersStandard.this.isGroupValid();
        }

        @Override
        public <T> T getCapability(ChameleonCapability<T> capability) {
            if (BlockEntityDrawersStandard.this.field_11863 == null) {
                return null;
            }
            return capability.getCapability(BlockEntityDrawersStandard.this.field_11863, BlockEntityDrawersStandard.this.method_11016());
        }
    }
}

