/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.client;

import java.util.HashMap;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.DisconnectedFromServerEvent;
import net.blay09.mods.balm.api.network.ServerboundModListMessage;
import net.blay09.mods.balm.fabric.client.rendering.FabricBalmModels;
import net.blay09.mods.balm.fabric.network.FabricBalmNetworking;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.loader.api.FabricLoader;

public class FabricBalmClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> FabricBalmNetworking.initializeClientHandlers());
        Balm.getEvents().onEvent(DisconnectedFromServerEvent.class, event -> Balm.getConfig().resetToBackingConfigs());
        ModelLoadingPlugin.register((ModelLoadingPlugin)((FabricBalmModels)BalmClient.getModels()));
        Balm.getEvents().onEvent(ConnectedToServerEvent.class, event -> {
            FabricBalmNetworking networking = (FabricBalmNetworking)Balm.getNetworking();
            HashMap<String, String> modVersions = new HashMap<String, String>();
            for (String modId : networking.getRegisteredMods()) {
                FabricLoader.getInstance().getModContainer(modId).ifPresent(modContainer -> {
                    String version = modContainer.getMetadata().getVersion().toString();
                    if (!networking.isClientOnly(modId) && !networking.isServerOnly(modId)) {
                        modVersions.put(modId, version);
                    }
                });
            }
            Balm.getNetworking().sendToServer(new ServerboundModListMessage(modVersions));
        });
    }
}

