/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.balm.api.config.ExpectedType;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ConfigJsonExport {
    public static ArrayList<ConfigProperty> export(Class<?> configDataClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Object defaults = configDataClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        ArrayList<ConfigProperty> properties = new ArrayList<ConfigProperty>();
        for (Field field : configDataClass.getDeclaredFields()) {
            if (ConfigJsonExport.isProperty(field)) {
                String name = field.getName();
                String type = field.getType().getSimpleName();
                Comment commentAnnotation = field.getAnnotation(Comment.class);
                if (commentAnnotation == null) {
                    throw new IllegalArgumentException("Missing @Comment annotation on field: " + String.valueOf(field));
                }
                String description = commentAnnotation.value();
                Object defaultValue = field.get(defaults);
                String[] validValues = ConfigJsonExport.getValidValues(field);
                properties.add(new ConfigProperty(name, type, description, defaultValue, validValues));
                continue;
            }
            properties.addAll(ConfigJsonExport.export(field.getType()));
        }
        return properties;
    }

    public static void exportToFile(Class<?> configDataClass, File file) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException {
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Failed to create parent directories for file: " + String.valueOf(file));
        }
        Files.writeString(file.toPath(), (CharSequence)new Gson().toJson(ConfigJsonExport.export(configDataClass)), new OpenOption[0]);
    }

    @Nullable
    private static String[] getValidValues(Field field) {
        Class<?> type;
        ExpectedType expectedType;
        if (field.getType().isEnum()) {
            ?[] enumConstants = field.getType().getEnumConstants();
            String[] validValues = new String[enumConstants.length];
            for (int i = 0; i < enumConstants.length; ++i) {
                validValues[i] = enumConstants[i].toString();
            }
            return validValues;
        }
        if (Collection.class.isAssignableFrom(field.getType()) && (expectedType = field.getAnnotation(ExpectedType.class)) != null && (type = expectedType.value()).isEnum()) {
            ?[] enumConstants = type.getEnumConstants();
            String[] validValues = new String[enumConstants.length];
            for (int i = 0; i < enumConstants.length; ++i) {
                validValues[i] = enumConstants[i].toString();
            }
            return validValues;
        }
        return null;
    }

    private static boolean isProperty(Field field) {
        Class<?> type = field.getType();
        return type.isPrimitive() || type.isEnum() || type == String.class || type == List.class || type == Set.class || type == class_2960.class;
    }

    record ConfigProperty(String name, String type, String description, Object defaultValue, @Nullable String[] validValues) {
    }
}

