/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

public class BCLBiomeSettings {
    float terrainHeight;
    float fogDensity;
    float genChance;
    int edgeSize;
    boolean vertical;

    public static Builder createBCL() {
        return new Builder();
    }

    BCLBiomeSettings(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical) {
        this.terrainHeight = terrainHeight;
        this.fogDensity = fogDensity;
        this.genChance = genChance;
        this.edgeSize = edgeSize;
        this.vertical = vertical;
    }

    protected BCLBiomeSettings() {
        this.terrainHeight = 0.1f;
        this.fogDensity = 1.0f;
        this.genChance = 1.0f;
        this.edgeSize = 0;
        this.vertical = false;
    }

    public float getGenChance() {
        return this.genChance;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public float getTerrainHeight() {
        return this.terrainHeight;
    }

    public float getFogDensity() {
        return this.fogDensity;
    }

    public int getEdgeSize() {
        return this.edgeSize;
    }

    public static class Builder
    extends CommonBuilder<BCLBiomeSettings, Builder> {
        public Builder() {
            super(new BCLBiomeSettings());
        }
    }

    public static class CommonBuilder<T extends BCLBiomeSettings, R extends CommonBuilder> {
        private final T storage;

        CommonBuilder(T storage) {
            this.storage = storage;
        }

        public T build() {
            return this.storage;
        }

        public R setGenChance(float genChance) {
            ((BCLBiomeSettings)this.storage).genChance = genChance;
            return (R)this;
        }

        public R setTerrainHeight(float terrainHeight) {
            ((BCLBiomeSettings)this.storage).terrainHeight = terrainHeight;
            return (R)this;
        }

        public R setVertical() {
            return this.setVertical(true);
        }

        public R setVertical(boolean vertical) {
            ((BCLBiomeSettings)this.storage).vertical = vertical;
            return (R)this;
        }

        public R setEdgeSize(int size) {
            ((BCLBiomeSettings)this.storage).edgeSize = size;
            return (R)this;
        }

        public R setFogDensity(float fogDensity) {
            ((BCLBiomeSettings)this.storage).fogDensity = fogDensity;
            return (R)this;
        }
    }
}

