/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.jetbrains.annotations.ApiStatus;

public class TheEndBiomesHelper {
    @ApiStatus.Internal
    private static Map<BiomeAPI.BiomeType, Set<class_5321<class_1959>>> END_BIOMES = new HashMap<BiomeAPI.BiomeType, Set<class_5321<class_1959>>>();

    @ApiStatus.Internal
    public static void add(BiomeAPI.BiomeType type, class_5321<class_1959> biome) {
        if (biome == null) {
            return;
        }
        END_BIOMES.computeIfAbsent(type, t -> new HashSet()).add(biome);
    }

    private static boolean has(BiomeAPI.BiomeType type, class_5321<class_1959> biome) {
        if (biome == null) {
            return false;
        }
        Set<class_5321<class_1959>> set = END_BIOMES.get(type);
        if (set == null) {
            return false;
        }
        return set.contains(biome);
    }

    public static boolean canGenerateAsMainIslandBiome(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.has(BiomeAPI.BiomeType.END_CENTER, biome);
    }

    public static boolean canGenerateAsSmallIslandsBiome(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.has(BiomeAPI.BiomeType.END_VOID, biome);
    }

    public static boolean canGenerateAsHighlandsBiome(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.has(BiomeAPI.BiomeType.END_LAND, biome);
    }

    public static boolean canGenerateAsEndMidlands(class_5321<class_1959> biome) {
        return false;
    }

    public static boolean canGenerateAsEndBarrens(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.has(BiomeAPI.BiomeType.END_BARRENS, biome);
    }

    public static boolean canGenerateInEnd(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.canGenerateAsHighlandsBiome(biome) || TheEndBiomesHelper.canGenerateAsEndBarrens(biome) || TheEndBiomesHelper.canGenerateAsEndMidlands(biome) || TheEndBiomesHelper.canGenerateAsSmallIslandsBiome(biome) || TheEndBiomesHelper.canGenerateAsMainIslandBiome(biome);
    }
}

