/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.datafixer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.datafixer.DataFixerAPI;
import org.betterx.bclib.api.v2.datafixer.Patch;
import org.betterx.bclib.api.v2.datafixer.PatchDidiFailException;
import org.betterx.bclib.interfaces.PatchBiFunction;
import org.betterx.bclib.interfaces.PatchFunction;
import org.betterx.worlds.together.util.ModUtil;
import org.betterx.worlds.together.world.WorldConfig;
import org.jetbrains.annotations.NotNull;

public class MigrationProfile {
    final Set<String> mods;
    final Map<String, String> idReplacements;
    final List<PatchFunction<class_2487, Boolean>> levelPatchers;
    final List<PatchBiFunction<class_2499, class_2499, Boolean>> statePatchers;
    final List<Patch> worldDataPatchers;
    final Map<String, List<String>> worldDataIDPaths;
    private final class_2487 config;
    private class_2487 level;
    private File levelBaseDir;
    private boolean prePatchChangedLevelDat;
    private boolean didRunPrePatch;
    private Exception prePatchException;

    MigrationProfile(class_2487 config, boolean applyAll) {
        this.config = config;
        this.mods = Collections.unmodifiableSet(Patch.getALL().stream().map(p -> p.modID).collect(Collectors.toSet()));
        HashMap replacements = new HashMap();
        LinkedList levelPatches = new LinkedList();
        LinkedList worldDataPatches = new LinkedList();
        LinkedList statePatches = new LinkedList();
        HashMap worldDataIDPaths = new HashMap();
        for (String modID : this.mods) {
            Patch.getALL().stream().filter(p -> p.modID.equals(modID)).forEach(patch -> {
                List<String> paths = patch.getWorldDataIDPaths();
                if (paths != null) {
                    worldDataIDPaths.put(modID, paths);
                }
                if (applyAll || this.currentPatchLevel(modID) < patch.level || patch.alwaysApply) {
                    replacements.putAll(patch.getIDReplacements());
                    if (patch.getLevelDatPatcher() != null) {
                        levelPatches.add(patch.getLevelDatPatcher());
                    }
                    if (patch.getWorldDataPatcher() != null) {
                        worldDataPatches.add(patch);
                    }
                    if (patch.getBlockStatePatcher() != null) {
                        statePatches.add(patch.getBlockStatePatcher());
                    }
                    DataFixerAPI.LOGGER.info("Applying " + patch);
                } else {
                    DataFixerAPI.LOGGER.info("Ignoring " + patch);
                }
            });
        }
        this.worldDataIDPaths = Collections.unmodifiableMap(worldDataIDPaths);
        this.idReplacements = Collections.unmodifiableMap(replacements);
        this.levelPatchers = Collections.unmodifiableList(levelPatches);
        this.worldDataPatchers = Collections.unmodifiableList(worldDataPatches);
        this.statePatchers = Collections.unmodifiableList(statePatches);
    }

    public static void fixCustomFolder(File dir) {
        if (!BCLib.isDevEnvironment()) {
            return;
        }
        MigrationProfile profile = Patch.createMigrationData();
        List<File> nbts = MigrationProfile.getAllNbts(dir, null);
        nbts.parallelStream().forEach(file -> {
            DataFixerAPI.LOGGER.info("Loading NBT " + file);
            try {
                int idx;
                class_2499 items;
                class_2487 root = class_2507.method_30613((File)file);
                boolean[] changed = new boolean[]{false};
                int spawnerIdx = -1;
                if (root.method_10545("palette")) {
                    items = root.method_10554("palette", 10);
                    for (idx = 0; idx < items.size(); ++idx) {
                        class_2487 tag = (class_2487)items.method_10534(idx);
                        if (tag.method_10545("Name") && tag.method_10558("Name").equals("minecraft:spawner")) {
                            spawnerIdx = idx;
                        }
                        if (tag.method_10545("Name") && (tag.method_10558("Name").equals("minecraft:") || tag.method_10558("Name").equals(""))) {
                            System.out.println("Empty Name");
                        }
                        if (tag.method_10545("id") && (tag.method_10558("id").equals("minecraft:") || tag.method_10558("id").equals(""))) {
                            System.out.println("Empty ID");
                        }
                        changed[0] = changed[0] | profile.replaceStringFromIDs(tag, "Name");
                    }
                }
                if (spawnerIdx >= 0 && root.method_10545("blocks")) {
                    items = root.method_10554("blocks", 10);
                    for (idx = 0; idx < items.size(); ++idx) {
                        class_2487 entity;
                        class_2487 blockTag = (class_2487)items.method_10534(idx);
                        if (!blockTag.method_10545("state") || blockTag.method_10550("state") != spawnerIdx || !blockTag.method_10545("nbt")) continue;
                        class_2487 nbt = blockTag.method_10562("nbt");
                        if (nbt.method_10545("SpawnData") && !(entity = nbt.method_10562("SpawnData")).method_10545("entity")) {
                            class_2487 data = new class_2487();
                            data.method_10566("entity", (class_2520)entity);
                            nbt.method_10566("SpawnData", (class_2520)data);
                            changed[0] = true;
                        }
                        if (!nbt.method_10545("SpawnPotentials")) continue;
                        class_2499 pots = nbt.method_10554("SpawnPotentials", 10);
                        for (class_2520 potItemIn : pots) {
                            class_2487 potItem = (class_2487)potItemIn;
                            if (potItem.method_10545("Weight")) {
                                int weight = potItem.method_10550("Weight");
                                potItem.method_10569("weight", weight);
                                potItem.method_10551("Weight");
                                changed[0] = true;
                            }
                            if (!potItem.method_10545("Entity")) continue;
                            class_2487 entity2 = potItem.method_10562("Entity");
                            class_2487 data = new class_2487();
                            data.method_10566("entity", (class_2520)entity2);
                            potItem.method_10566("data", (class_2520)data);
                            potItem.method_10551("Entity");
                            changed[0] = true;
                        }
                    }
                }
                if (changed[0]) {
                    DataFixerAPI.LOGGER.info("Writing NBT " + file);
                    class_2507.method_30614((class_2487)root, (File)file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static List<File> getAllNbts(File dir, List<File> list) {
        if (list == null) {
            list = new ArrayList<File>();
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                MigrationProfile.getAllNbts(file, list);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".nbt")) continue;
            list.add(file);
        }
        return list;
    }

    public final class_2487 getLevelDat(File levelBaseDir) {
        if (this.level == null || this.levelBaseDir == null || !this.levelBaseDir.equals(levelBaseDir)) {
            this.runPrePatches(levelBaseDir);
        }
        return this.level;
    }

    public final boolean isLevelDatChanged() {
        return this.prePatchChangedLevelDat;
    }

    public final File getLevelDatFile() {
        return new File(this.levelBaseDir, "level.dat");
    }

    public final Exception getPrePatchException() {
        return this.prePatchException;
    }

    public final void runPrePatches(File levelBaseDir) {
        if (this.didRunPrePatch) {
            BCLib.LOGGER.warning("Already did run PrePatches for " + this.levelBaseDir + ".", new Object[0]);
        }
        BCLib.LOGGER.info("Running Pre Patchers on " + levelBaseDir);
        this.levelBaseDir = levelBaseDir;
        this.level = null;
        this.prePatchException = null;
        this.didRunPrePatch = true;
        this.prePatchChangedLevelDat = this.runPreLevelPatches(this.getLevelDatFile());
    }

    private boolean runPreLevelPatches(File levelDat) {
        try {
            this.level = class_2507.method_30613((File)levelDat);
            boolean changed = this.patchLevelDat(this.level);
            return changed;
        }
        catch (IOException | PatchDidiFailException e) {
            this.prePatchException = e;
            return false;
        }
    }

    public final void markApplied() {
        for (String modID : this.mods) {
            DataFixerAPI.LOGGER.info("Updating Patch-Level for '{}' from {} to {}", modID, ModUtil.convertModVersion(this.currentPatchLevel(modID)), ModUtil.convertModVersion(Patch.maxPatchLevel(modID)));
            if (this.config == null) continue;
            this.config.method_10582(modID, Patch.maxPatchVersion(modID));
        }
    }

    public String currentPatchVersion(@NotNull String modID) {
        if (this.config == null || !this.config.method_10545(modID)) {
            return "0.0.0";
        }
        return this.config.method_10558(modID);
    }

    public int currentPatchLevel(@NotNull String modID) {
        return ModUtil.convertModVersion(this.currentPatchVersion(modID));
    }

    public boolean hasAnyFixes() {
        boolean hasLevelDatPatches = this.didRunPrePatch ? this.prePatchChangedLevelDat : this.levelPatchers.size() > 0;
        return this.idReplacements.size() > 0 || hasLevelDatPatches || this.worldDataPatchers.size() > 0;
    }

    public String replaceStringFromIDs(@NotNull String val) {
        String replace = this.idReplacements.get(val);
        return replace;
    }

    public boolean replaceStringFromIDs(@NotNull class_2487 tag, @NotNull String key) {
        if (!tag.method_10545(key)) {
            return false;
        }
        String val = tag.method_10558(key);
        String replace = this.idReplacements.get(val);
        if (replace != null) {
            DataFixerAPI.LOGGER.warning("Replacing ID '{}' with '{}'.", val, replace);
            tag.method_10582(key, replace);
            return true;
        }
        return false;
    }

    private boolean replaceIDatPath(@NotNull class_2499 list, @NotNull String[] parts, int level) {
        boolean[] changed = new boolean[]{false};
        if (level == parts.length - 1) {
            DataFixerAPI.fixItemArrayWithID(list, changed, this, true);
        } else {
            list.forEach(inTag -> {
                changed[0] = changed[0] | this.replaceIDatPath((class_2487)inTag, parts, level + 1);
            });
        }
        return changed[0];
    }

    private boolean replaceIDatPath(@NotNull class_2487 tag, @NotNull String[] parts, int level) {
        boolean changed = false;
        for (int i = level; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (tag.method_10545(part)) {
                byte type = tag.method_10540(part);
                if (type == 9) {
                    class_2499 list = tag.method_10554(part, 10);
                    return this.replaceIDatPath(list, parts, i);
                }
                if (type != 10) continue;
                tag = tag.method_10562(part);
                continue;
            }
            return false;
        }
        if (tag != null && parts.length > 0) {
            String key = parts[parts.length - 1];
            byte type = tag.method_10540(key);
            if (type == 9) {
                class_2499 list = tag.method_10554(key, 10);
                boolean[] _changed = new boolean[]{false};
                if (list.size() == 0) {
                    _changed[0] = DataFixerAPI.fixStringIDList(tag, key, this);
                } else {
                    DataFixerAPI.fixItemArrayWithID(list, _changed, this, true);
                }
                return _changed[0];
            }
            if (type == 8) {
                return this.replaceStringFromIDs(tag, key);
            }
            if (type == 10) {
                class_2487 cTag = tag.method_10562(key);
                boolean[] _changed = new boolean[]{false};
                DataFixerAPI.fixID(cTag, _changed, this, true);
                return _changed[0];
            }
        }
        return false;
    }

    public boolean replaceIDatPath(@NotNull class_2487 root, @NotNull String path) {
        String[] parts = path.split("\\.");
        return this.replaceIDatPath(root, parts, 0);
    }

    public boolean patchLevelDat(@NotNull class_2487 level) throws PatchDidiFailException {
        boolean changed = false;
        for (PatchFunction<class_2487, Boolean> f : this.levelPatchers) {
            changed |= f.apply(level, this).booleanValue();
        }
        return changed;
    }

    public void patchWorldData() throws PatchDidiFailException {
        class_2487 root;
        for (Patch patch : this.worldDataPatchers) {
            root = WorldConfig.getRootTag(patch.modID);
            boolean changed = patch.getWorldDataPatcher().apply(root, this);
            if (!changed) continue;
            WorldConfig.saveFile(patch.modID);
        }
        for (Map.Entry entry : this.worldDataIDPaths.entrySet()) {
            root = WorldConfig.getRootTag((String)entry.getKey());
            boolean[] changed = new boolean[]{false};
            ((List)entry.getValue()).forEach(path -> {
                changed[0] = changed[0] | this.replaceIDatPath(root, (String)path);
            });
            if (!changed[0]) continue;
            WorldConfig.saveFile((String)entry.getKey());
        }
    }

    public boolean patchBlockState(class_2499 palette, class_2499 states) throws PatchDidiFailException {
        boolean changed = false;
        for (PatchBiFunction<class_2499, class_2499, Boolean> f : this.statePatchers) {
            changed |= f.apply(palette, states, this).booleanValue();
        }
        return changed;
    }
}

