/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexQueen;
import com.iafenvoy.iceandfire.entity.EntityMyrmexSentinel;
import com.iafenvoy.iceandfire.entity.EntityMyrmexSoldier;
import com.iafenvoy.iceandfire.entity.EntityMyrmexWorker;
import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexBiolight;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexConnectedResin;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexResin;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.util.RestrictWorldAccess;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.iafenvoy.iceandfire.world.MyrmexWorldData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import net.minecraft.class_7151;

public class MyrmexHiveStructure
extends class_3195 {
    public static final Codec<MyrmexHiveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MyrmexHiveStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)Codec.BOOL.fieldOf("jungle").forGetter(structure -> structure.jungle)).apply((Applicative)instance, MyrmexHiveStructure::new)).codec();
    private final boolean jungle;

    protected MyrmexHiveStructure(class_3195.class_7302 config, boolean jungle) {
        super(config);
        this.jungle = jungle;
    }

    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2470 blockRotation = class_2470.method_16548((class_5819)context.comp_566());
        class_2338 blockPos = this.method_42382(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new class_3195.class_7150(blockPos, collector -> this.addPieces((class_6626)collector, blockPos, context)));
    }

    private void addPieces(class_6626 collector, class_2338 pos, class_3195.class_7149 context) {
        int down = Math.max(15, pos.method_10264() - 16 + context.comp_566().method_43048(5));
        long seed = context.comp_566().method_43055();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                collector.method_35462((class_3443)new MyrmexHivePiece(0, new class_3341(pos.method_10263() + i * 32, pos.method_10264(), pos.method_10260() + j * 32, pos.method_10263() + i * 32, pos.method_10264(), pos.method_10260() + j * 32), new class_2338(i * 32, 0, j * 32), down, seed, false, this.jungle));
            }
        }
    }

    public class_7151<?> method_41618() {
        return (class_7151)IafStructureTypes.MYRMEX_HIVE.get();
    }

    public static MyrmexHivePiece placeSmallGen(boolean isJungle, class_5281 world, class_5819 random, class_2338 pos) {
        int down = Math.max(15, pos.method_10264() - 20 + random.method_43048(10));
        MyrmexHivePiece piece = new MyrmexHivePiece(0, new class_3341(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263(), pos.method_10264(), pos.method_10260()), new class_2338(0, 0, 0), down, random.method_43055(), true, isJungle);
        piece.hasFoodRoom = false;
        piece.hasNursery = false;
        piece.totalRooms = 0;
        piece.entrances = 0;
        piece.generateMainRoom((class_5425)world, random, pos);
        return piece;
    }

    public static class MyrmexHivePiece
    extends class_3443 {
        public static final class_2960 MYRMEX_GOLD_CHEST = class_2960.method_43902((String)"iceandfire", (String)"chest/myrmex_loot_chest");
        public static final class_2960 DESERT_MYRMEX_FOOD_CHEST = class_2960.method_43902((String)"iceandfire", (String)"chest/myrmex_desert_food_chest");
        public static final class_2960 JUNGLE_MYRMEX_FOOD_CHEST = class_2960.method_43902((String)"iceandfire", (String)"chest/myrmex_jungle_food_chest");
        public static final class_2960 MYRMEX_TRASH_CHEST = class_2960.method_43902((String)"iceandfire", (String)"chest/myrmex_trash_chest");
        private static final class_2680 DESERT_RESIN = ((class_2248)IafBlocks.MYRMEX_DESERT_RESIN.get()).method_9564();
        private static final class_2680 STICKY_DESERT_RESIN = ((class_2248)IafBlocks.MYRMEX_DESERT_RESIN_STICKY.get()).method_9564();
        private static final class_2680 JUNGLE_RESIN = ((class_2248)IafBlocks.MYRMEX_JUNGLE_RESIN.get()).method_9564();
        private static final class_2680 STICKY_JUNGLE_RESIN = ((class_2248)IafBlocks.MYRMEX_JUNGLE_RESIN_STICKY.get()).method_9564();
        private final class_2338 offset;
        private final int y;
        private final long seed;
        public MyrmexHive hive;
        private int entrances = 0;
        private int totalRooms;
        private boolean hasFoodRoom;
        private boolean hasNursery;
        private final boolean small;
        private final boolean jungle;

        protected MyrmexHivePiece(int length, class_3341 boundingBox, class_2338 offset, int y, long seed, boolean small, boolean jungle) {
            super((class_3773)IafStructurePieces.MYRMEX_HIVE.get(), length, boundingBox);
            this.offset = offset;
            this.y = y;
            this.seed = seed;
            this.small = small;
            this.jungle = jungle;
        }

        public MyrmexHivePiece(class_6625 context, class_2487 nbt) {
            super((class_3773)IafStructurePieces.MYRMEX_HIVE.get(), nbt);
            this.offset = class_2338.method_10092((long)nbt.method_10537("offset"));
            this.y = nbt.method_10550("down");
            this.seed = nbt.method_10537("seed");
            this.small = nbt.method_10577("small");
            this.jungle = nbt.method_10577("jungle");
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
            nbt.method_10544("offset", this.offset.method_10063());
            nbt.method_10569("down", this.y);
            nbt.method_10544("seed", this.seed);
            nbt.method_10556("small", this.small);
            nbt.method_10556("jungle", this.jungle);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            class_5820 rand = new class_5820(this.seed);
            this.hasFoodRoom = false;
            this.hasNursery = false;
            this.totalRooms = 0;
            class_2338 undergroundPos = new class_2338(pivot.method_10263(), this.y, pivot.method_10260());
            this.entrances = 0;
            this.generateMainRoom(new RestrictWorldAccess((class_5425)world, pos -> this.isIn(chunkPos, (class_2338)pos)), (class_5819)rand, undergroundPos);
        }

        private boolean isIn(class_1923 chunkPos, class_2338 blockPos) {
            return chunkPos.method_8326() - 16 <= blockPos.method_10263() && blockPos.method_10263() <= chunkPos.method_8327() + 16 && chunkPos.method_8328() - 16 <= blockPos.method_10260() && blockPos.method_10260() <= chunkPos.method_8329() + 16;
        }

        private void generateMainRoom(class_5425 world, class_5819 rand, class_2338 position) {
            this.hive = new MyrmexHive((class_1937)world.method_8410(), position, 100);
            MyrmexWorldData.addHive((class_1937)world.method_8410(), this.hive);
            class_2680 resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
            class_2680 sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
            this.generateSphere((class_1936)world, rand, position, 14, 7, resin, sticky_resin);
            this.generateSphere((class_1936)world, rand, position, 12, 5, class_2246.field_10124.method_9564());
            this.decorateSphere((class_1936)world, rand, position, 12, 5, RoomType.QUEEN);
            this.generatePath((class_1936)world, rand, position.method_10079(class_2350.field_11043, 7).method_10074(), 8 + rand.method_43048(10), class_2350.field_11043, 100);
            this.generatePath((class_1936)world, rand, position.method_10079(class_2350.field_11035, 7).method_10074(), 8 + rand.method_43048(10), class_2350.field_11035, 100);
            this.generatePath((class_1936)world, rand, position.method_10079(class_2350.field_11039, 7).method_10074(), 8 + rand.method_43048(10), class_2350.field_11039, 100);
            this.generatePath((class_1936)world, rand, position.method_10079(class_2350.field_11034, 7).method_10074(), 8 + rand.method_43048(10), class_2350.field_11034, 100);
            if (!this.small) {
                EntityMyrmexBase myrmex;
                int i;
                EntityMyrmexQueen queen = new EntityMyrmexQueen((class_1299<EntityMyrmexQueen>)((class_1299)IafEntities.MYRMEX_QUEEN.get()), (class_1937)world.method_8410());
                class_2338 ground = MyrmexHive.getGroundedPos((class_1936)world, position);
                queen.method_5943(world, world.method_8404(ground), class_3730.field_16472, null, null);
                queen.setHive(this.hive);
                queen.setJungleVariant(this.jungle);
                queen.method_5641((double)ground.method_10263() + 0.5, (double)ground.method_10264() + 1.0, (double)ground.method_10260() + 0.5, 0.0f, 0.0f);
                world.method_8649((class_1297)queen);
                for (i = 0; i < 4 + rand.method_43048(3); ++i) {
                    myrmex = new EntityMyrmexWorker((class_1299<EntityMyrmexWorker>)((class_1299)IafEntities.MYRMEX_WORKER.get()), (class_1937)world.method_8410());
                    myrmex.method_5943(world, world.method_8404(ground), class_3730.field_16472, null, null);
                    myrmex.setHive(this.hive);
                    myrmex.method_5641((double)ground.method_10263() + 0.5, (double)ground.method_10264() + 1.0, (double)ground.method_10260() + 0.5, 0.0f, 0.0f);
                    myrmex.setJungleVariant(this.jungle);
                    world.method_8649((class_1297)myrmex);
                }
                for (i = 0; i < 2 + rand.method_43048(2); ++i) {
                    myrmex = new EntityMyrmexSoldier((class_1299<EntityMyrmexSoldier>)((class_1299)IafEntities.MYRMEX_SOLDIER.get()), (class_1937)world.method_8410());
                    myrmex.method_5943(world, world.method_8404(ground), class_3730.field_16472, null, null);
                    myrmex.setHive(this.hive);
                    myrmex.method_5641((double)ground.method_10263() + 0.5, (double)ground.method_10264() + 1.0, (double)ground.method_10260() + 0.5, 0.0f, 0.0f);
                    myrmex.setJungleVariant(this.jungle);
                    world.method_8649((class_1297)myrmex);
                }
                for (i = 0; i < rand.method_43048(2); ++i) {
                    myrmex = new EntityMyrmexSentinel((class_1299<? extends EntityMyrmexSentinel>)((class_1299)IafEntities.MYRMEX_SENTINEL.get()), (class_1937)world.method_8410());
                    myrmex.method_5943(world, world.method_8404(ground), class_3730.field_16472, null, null);
                    myrmex.setHive(this.hive);
                    myrmex.method_5641((double)ground.method_10263() + 0.5, (double)ground.method_10264() + 1.0, (double)ground.method_10260() + 0.5, 0.0f, 0.0f);
                    myrmex.setJungleVariant(this.jungle);
                    world.method_8649((class_1297)myrmex);
                }
            }
        }

        private void generatePath(class_1936 world, class_5819 rand, class_2338 offset, int length, class_2350 direction, int roomChance) {
            if (roomChance == 0) {
                return;
            }
            if (this.small) {
                length /= 2;
                if (this.entrances < 1) {
                    for (int i = 0; i < length; ++i) {
                        this.generateCircle(world, rand, offset.method_10079(direction, i), direction);
                    }
                    this.generateEntrance(world, rand, offset.method_10079(direction, length), direction);
                } else if (this.totalRooms < 2) {
                    int i;
                    for (i = 0; i < length; ++i) {
                        this.generateCircle(world, rand, offset.method_10079(direction, i), direction);
                    }
                    this.generateRoom(world, rand, offset.method_10079(direction, length), 6, roomChance / 2, direction);
                    for (i = -3; i < 3; ++i) {
                        this.generateCircleAir(world, rand, offset.method_10079(direction, i), direction);
                        this.generateCircleAir(world, rand, offset.method_10079(direction, length + i), direction);
                    }
                    ++this.totalRooms;
                }
            } else if (rand.method_43048(100) < roomChance) {
                if (this.entrances < 3 && rand.method_43048(1 + this.entrances * 2) == 0 && this.hasFoodRoom && this.hasNursery && this.totalRooms > 3 || this.entrances == 0) {
                    this.generateEntrance(world, rand, offset.method_10079(direction, 1), direction);
                } else {
                    int i;
                    for (i = 0; i < length; ++i) {
                        this.generateCircle(world, rand, offset.method_10079(direction, i), direction);
                    }
                    for (i = -3; i < 3; ++i) {
                        this.generateCircleAir(world, rand, offset.method_10079(direction, length + i), direction);
                    }
                    ++this.totalRooms;
                    this.generateRoom(world, rand, offset.method_10079(direction, length), 7, roomChance / 2, direction);
                }
            }
        }

        private void generateRoom(class_1936 world, class_5819 rand, class_2338 position, int size, int roomChance, class_2350 direction) {
            class_2680 resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
            class_2680 sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
            RoomType type = RoomType.random(rand);
            if (!this.hasFoodRoom) {
                type = RoomType.FOOD;
                this.hasFoodRoom = true;
            } else if (!this.hasNursery) {
                type = RoomType.NURSERY;
                this.hasNursery = true;
            }
            this.generateSphereRespectResin(world, rand, position, size + 2, 6, resin, sticky_resin);
            this.generateSphere(world, rand, position, size, 3, class_2246.field_10124.method_9564());
            this.decorateSphere(world, rand, position, size, 3, type);
            this.hive.addRoom(position, type);
            if (!this.small) {
                if (rand.method_43048(3) == 0 && direction.method_10153() != class_2350.field_11043) {
                    this.generatePath(world, rand, position.method_10079(class_2350.field_11043, size - 2), 5 + rand.method_43048(20), class_2350.field_11043, roomChance);
                }
                if (rand.method_43048(3) == 0 && direction.method_10153() != class_2350.field_11035) {
                    this.generatePath(world, rand, position.method_10079(class_2350.field_11035, size - 2), 5 + rand.method_43048(20), class_2350.field_11035, roomChance);
                }
                if (rand.method_43048(3) == 0 && direction.method_10153() != class_2350.field_11039) {
                    this.generatePath(world, rand, position.method_10079(class_2350.field_11039, size - 2), 5 + rand.method_43048(20), class_2350.field_11039, roomChance);
                }
                if (rand.method_43048(3) == 0 && direction.method_10153() != class_2350.field_11034) {
                    this.generatePath(world, rand, position.method_10079(class_2350.field_11034, size - 2), 5 + rand.method_43048(20), class_2350.field_11034, roomChance);
                }
            }
        }

        private void generateEntrance(class_1936 world, class_5819 rand, class_2338 position, class_2350 direction) {
            class_2338 up = position.method_10084();
            this.hive.getEntranceBottoms().put(up, direction);
            while (up.method_10264() < world.method_8598(this.small ? class_2902.class_2903.field_13203 : class_2902.class_2903.field_13194, up).method_10264() && !world.method_8320(up).method_26164(class_3481.field_15475)) {
                this.generateCircleRespectSky(world, rand, up, direction);
                up = up.method_10084().method_10093(direction);
            }
            class_2680 resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
            class_2680 sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
            this.generateSphereRespectAir(world, rand, up, 8, 6, resin, sticky_resin);
            this.generateSphere(world, rand, up.method_10084(), 4, 4, class_2246.field_10124.method_9564());
            this.decorateSphere(world, rand, up.method_10084(), 4, 3, RoomType.ENTERANCE);
            this.hive.getEntrances().put(up, direction);
            ++this.entrances;
        }

        private void generateCircle(class_1936 world, class_5819 rand, class_2338 position, class_2350 direction) {
            int z;
            int x;
            float j;
            float i;
            class_2680 resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
            class_2680 sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
            int radius = 5;
            for (i = 0.0f; i < (float)radius; i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    x = (int)Math.floor(class_3532.method_15374((float)j) * i);
                    z = (int)Math.floor(class_3532.method_15362((float)j) * i);
                    if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                        world.method_8652(position.method_10069(0, x, z), rand.method_43048(3) == 0 ? sticky_resin : resin, 2);
                    } else {
                        world.method_8652(position.method_10069(x, z, 0), rand.method_43048(3) == 0 ? sticky_resin : resin, 2);
                    }
                    j += 0.5f;
                }
            }
            radius -= 2;
            for (i = 0.0f; i < (float)radius; i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    x = (int)Math.floor(class_3532.method_15374((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                    z = (int)Math.floor(class_3532.method_15362((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                    if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                        world.method_8652(position.method_10069(0, x, z), class_2246.field_10124.method_9564(), 2);
                    } else {
                        world.method_8652(position.method_10069(x, z, 0), class_2246.field_10124.method_9564(), 2);
                    }
                    j += 0.5f;
                }
            }
            this.decorateCircle(world, rand, position, 3, 5, direction);
        }

        private void generateCircleRespectSky(class_1936 world, class_5819 rand, class_2338 position, class_2350 direction) {
            int z;
            int x;
            float j;
            float i;
            class_2680 resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
            class_2680 sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
            int radius = 6;
            for (i = 0.0f; i < (float)radius; i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    x = (int)Math.floor(class_3532.method_15374((float)j) * i);
                    z = (int)Math.floor(class_3532.method_15362((float)j) * i);
                    if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                        if (!world.method_22348(position.method_10069(0, x, z))) {
                            world.method_8652(position.method_10069(0, x, z), rand.method_43048(3) == 0 ? sticky_resin : resin, 3);
                        }
                    } else if (!world.method_22348(position.method_10069(x, z, 0))) {
                        world.method_8652(position.method_10069(x, z, 0), rand.method_43048(3) == 0 ? sticky_resin : resin, 3);
                    }
                    j += 0.5f;
                }
            }
            radius -= 2;
            for (i = 0.0f; i < (float)radius; i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    x = (int)Math.floor(class_3532.method_15374((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                    z = (int)Math.floor(class_3532.method_15362((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                    if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                        world.method_8652(position.method_10069(0, x, z), class_2246.field_10124.method_9564(), 3);
                    } else {
                        world.method_8652(position.method_10069(x, z, 0), class_2246.field_10124.method_9564(), 3);
                    }
                    j += 0.5f;
                }
            }
            this.decorateCircle(world, rand, position, 4, 4, direction);
        }

        private void generateCircleAir(class_1936 world, class_5819 rand, class_2338 position, class_2350 direction) {
            for (float i = 0.0f; i < 3.0f; i += 0.5f) {
                float j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    int x = (int)Math.floor(class_3532.method_15374((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                    int z = (int)Math.floor(class_3532.method_15362((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                    if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                        world.method_8652(position.method_10069(0, x, z), class_2246.field_10124.method_9564(), 2);
                    } else {
                        world.method_8652(position.method_10069(x, z, 0), class_2246.field_10124.method_9564(), 2);
                    }
                    j += 0.5f;
                }
            }
            this.decorateCircle(world, rand, position, 3, 5, direction);
        }

        public void generateSphere(class_1936 world, class_5819 rand, class_2338 position, int size, int height, class_2680 fill) {
            int ySize = rand.method_43048(2);
            int j = size + rand.method_43048(2);
            int k = height + ySize;
            int l = size + rand.method_43048(2);
            float f = (float)(j + k + l) * 0.333f;
            for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f * class_3532.method_15363((float)rand.method_43057(), (float)0.75f, (float)1.0f))) || world.method_22347(blockpos)) continue;
                world.method_8652(blockpos, fill, 3);
            }
        }

        public void generateSphere(class_1936 world, class_5819 rand, class_2338 position, int size, int height, class_2680 fill, class_2680 fill2) {
            int ySize = rand.method_43048(2);
            int j = size + rand.method_43048(2);
            int k = height + ySize;
            int l = size + rand.method_43048(2);
            float f = (float)(j + k + l) * 0.333f;
            for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f * class_3532.method_15363((float)rand.method_43057(), (float)0.75f, (float)1.0f)))) continue;
                world.method_8652(blockpos, rand.method_43048(3) == 0 ? fill2 : fill, 2);
            }
        }

        public void generateSphereRespectResin(class_1936 world, class_5819 rand, class_2338 position, int size, int height, class_2680 fill, class_2680 fill2) {
            int ySize = rand.method_43048(2);
            int j = size + rand.method_43048(2);
            int k = height + ySize;
            int l = size + rand.method_43048(2);
            float f = (float)(j + k + l) * 0.333f;
            for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f * class_3532.method_15363((float)rand.method_43057(), (float)0.75f, (float)1.0f))) || world.method_22347(blockpos) && (!world.method_22347(blockpos) || this.hasResinUnder(blockpos, world))) continue;
                world.method_8652(blockpos, rand.method_43048(3) == 0 ? fill2 : fill, 2);
            }
        }

        public void generateSphereRespectAir(class_1936 world, class_5819 rand, class_2338 position, int size, int height, class_2680 fill, class_2680 fill2) {
            int ySize = rand.method_43048(2);
            int j = size + rand.method_43048(2);
            int k = height + ySize;
            int l = size + rand.method_43048(2);
            float f = (float)(j + k + l) * 0.333f;
            for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f * class_3532.method_15363((float)rand.method_43057(), (float)0.75f, (float)1.0f))) || world.method_22347(blockpos)) continue;
                world.method_8652(blockpos, rand.method_43048(3) == 0 ? fill2 : fill, 2);
            }
        }

        private boolean hasResinUnder(class_2338 pos, class_1936 world) {
            class_2338 copy = pos.method_10074();
            while (world.method_22347(copy) && copy.method_10264() > 1) {
                copy = copy.method_10074();
            }
            return world.method_8320(copy).method_26204() instanceof BlockMyrmexResin || world.method_8320(copy).method_26204() instanceof BlockMyrmexConnectedResin;
        }

        private void decorateCircle(class_1936 world, class_5819 rand, class_2338 position, int size, int height, class_2350 direction) {
            int radius = size + 2;
            for (float i = 0.0f; i < (float)radius; i += 0.5f) {
                float j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    int x = (int)Math.floor(class_3532.method_15374((float)j) * i);
                    int z = (int)Math.floor(class_3532.method_15362((float)j) * i);
                    if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                        if (world.method_22347(position.method_10069(0, x, z))) {
                            this.decorate(world, position.method_10069(0, x, z), position, size, rand, RoomType.TUNNEL);
                        }
                    } else if (world.method_22347(position.method_10069(x, z, 0))) {
                        this.decorate(world, position.method_10069(x, z, 0), position, size, rand, RoomType.TUNNEL);
                    }
                    if (world.method_22347(position.method_10069(0, x, z))) {
                        this.decorateTubers(world, position.method_10069(0, x, z), rand, RoomType.TUNNEL);
                    }
                    j += 0.5f;
                }
            }
        }

        private void decorateSphere(class_1936 world, class_5819 rand, class_2338 position, int size, int height, RoomType roomType) {
            int ySize = rand.method_43048(2);
            int j = size + rand.method_43048(2);
            int k = height + ySize;
            int l = size + rand.method_43048(2);
            float f = (float)(j + k + l) * 0.333f;
            for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k + 1, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f))) continue;
                if (world.method_8320(blockpos.method_10074()).method_26225() && world.method_22347(blockpos)) {
                    this.decorate(world, blockpos, position, size, rand, roomType);
                }
                if (!world.method_22347(blockpos)) continue;
                this.decorateTubers(world, blockpos, rand, roomType);
            }
        }

        private void decorate(class_1936 world, class_2338 blockpos, class_2338 center, int size, class_5819 random, RoomType roomType) {
            switch (roomType.ordinal()) {
                case 4: {
                    if (random.method_43048(45) == 0 && world.method_8320(blockpos.method_10074()).method_26204() instanceof BlockMyrmexResin) {
                        MyrmexHivePiece.generateSkeleton(world, blockpos, center, size, random);
                    }
                    if (random.method_43048(13) == 0) {
                        MyrmexHivePiece.generateLeaves(world, blockpos, center, size, random, this.jungle);
                    }
                    if (random.method_43048(12) == 0) {
                        MyrmexHivePiece.generatePumpkins(world, blockpos, center, size, random, this.jungle);
                    }
                    if (random.method_43048(6) == 0) {
                        MyrmexHivePiece.generateMushrooms(world, blockpos, center, size, random);
                    }
                    if (random.method_43048(12) != 0) break;
                    MyrmexHivePiece.generateCocoon(world, blockpos, random, this.jungle, this.jungle ? JUNGLE_MYRMEX_FOOD_CHEST : DESERT_MYRMEX_FOOD_CHEST);
                    break;
                }
                case 7: {
                    if (random.method_43048(12) != 0) break;
                    MyrmexHivePiece.generateGold(world, blockpos, center, size, random);
                    break;
                }
                case 8: {
                    if (random.method_43048(24) == 0) {
                        MyrmexHivePiece.generateTrashHeap(world, blockpos, center, size, random);
                    }
                    if (random.method_43056()) {
                        MyrmexHivePiece.generateTrashOre(world, blockpos, center, size, random);
                    }
                    if (random.method_43048(12) != 0) break;
                    MyrmexHivePiece.generateCocoon(world, blockpos, random, this.jungle, MYRMEX_TRASH_CHEST);
                    break;
                }
            }
        }

        private void decorateTubers(class_1936 world, class_2338 blockpos, class_5819 random, RoomType roomType) {
            if (world.method_8320(blockpos.method_10084()).method_26225() && random.method_43048(roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 20 : 6) == 0) {
                int tuberLength = roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 1 : (roomType == RoomType.QUEEN ? 1 + random.method_43048(5) : 1 + random.method_43048(3));
                for (int i = 0; i < tuberLength; ++i) {
                    if (!world.method_22347(blockpos.method_10087(i))) continue;
                    boolean connected = i != tuberLength - 1;
                    world.method_8652(blockpos.method_10087(i), this.jungle ? (class_2680)((class_2248)IafBlocks.MYRMEX_JUNGLE_BIOLIGHT.get()).method_9564().method_11657((class_2769)BlockMyrmexBiolight.CONNECTED_DOWN, (Comparable)Boolean.valueOf(connected)) : (class_2680)((class_2248)IafBlocks.MYRMEX_DESERT_BIOLIGHT.get()).method_9564().method_11657((class_2769)BlockMyrmexBiolight.CONNECTED_DOWN, (Comparable)Boolean.valueOf(connected)), 2);
                }
            }
        }

        public static void generateSkeleton(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand) {
            if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
                class_2350 direction = class_2350.method_10139((int)rand.method_43048(3));
                class_2350.class_2351 oppositeAxis = direction.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
                int maxRibHeight = rand.method_43048(2);
                for (int spine = 0; spine < 5 + rand.method_43048(2) * 2; ++spine) {
                    class_2338 segment = blockpos.method_10079(direction, spine);
                    if (origin.method_10262((class_2382)segment) <= (double)(radius * radius)) {
                        worldIn.method_8652(segment, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()), 2);
                    }
                    if (spine % 2 == 0) continue;
                    class_2338 rightRib = segment.method_10093(direction.method_10160());
                    class_2338 leftRib = segment.method_10093(direction.method_10170());
                    if (origin.method_10262((class_2382)rightRib) <= (double)(radius * radius)) {
                        worldIn.method_8652(rightRib, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
                    }
                    if (origin.method_10262((class_2382)leftRib) <= (double)(radius * radius)) {
                        worldIn.method_8652(leftRib, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
                    }
                    for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                        if (origin.method_10262((class_2382)rightRib.method_10086(ribHeight).method_10093(direction.method_10160())) <= (double)(radius * radius)) {
                            worldIn.method_8652(rightRib.method_10086(ribHeight).method_10093(direction.method_10160()), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052), 2);
                        }
                        if (!(origin.method_10262((class_2382)leftRib.method_10086(ribHeight).method_10093(direction.method_10170())) <= (double)(radius * radius))) continue;
                        worldIn.method_8652(leftRib.method_10086(ribHeight).method_10093(direction.method_10170()), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052), 2);
                    }
                    if (origin.method_10262((class_2382)rightRib.method_10086(maxRibHeight + 2)) <= (double)(radius * radius)) {
                        worldIn.method_8652(rightRib.method_10086(maxRibHeight + 2), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
                    }
                    if (!(origin.method_10262((class_2382)leftRib.method_10086(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
                    worldIn.method_8652(leftRib.method_10086(maxRibHeight + 2), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
                }
            }
        }

        public static void generateLeaves(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand, boolean jungle) {
            if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
                class_2680 leaf = (class_2680)class_2246.field_10503.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.TRUE);
                if (jungle) {
                    leaf = (class_2680)class_2246.field_10335.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.TRUE);
                }
                int i1 = 0;
                for (int i = 0; i < 3; ++i) {
                    int j = i1 + rand.method_43048(2);
                    int k = i1 + rand.method_43048(2);
                    int l = i1 + rand.method_43048(2);
                    float f = (float)(j + k + l) * 0.333f + 0.5f;
                    for (class_2338 pos : class_2338.method_20437((class_2338)blockpos.method_10069(-j, -k, -l), (class_2338)blockpos.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                        if (!(pos.method_10262((class_2382)blockpos) <= (double)(f * f)) || !worldIn.method_22347(pos)) continue;
                        worldIn.method_8652(pos, leaf, 4);
                    }
                    blockpos = blockpos.method_10069(-(i1 + 1) + rand.method_43048(2), -rand.method_43048(2), -(i1 + 1) + rand.method_43048(2));
                }
            }
        }

        public static void generatePumpkins(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand, boolean jungle) {
            if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
                worldIn.method_8652(blockpos, jungle ? class_2246.field_10545.method_9564() : class_2246.field_10261.method_9564(), 2);
            }
        }

        public static void generateCocoon(class_1936 worldIn, class_2338 blockpos, class_5819 rand, boolean jungle, class_2960 lootTable) {
            if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
                class_2586 class_25862;
                worldIn.method_8652(blockpos, jungle ? ((class_2248)IafBlocks.JUNGLE_MYRMEX_COCOON.get()).method_9564() : ((class_2248)IafBlocks.DESERT_MYRMEX_COCOON.get()).method_9564(), 3);
                if (worldIn.method_8321(blockpos) != null && (class_25862 = worldIn.method_8321(blockpos)) instanceof class_2621) {
                    class_2621 lootable = (class_2621)class_25862;
                    class_2586 tileentity1 = worldIn.method_8321(blockpos);
                    assert (tileentity1 != null);
                    lootable.method_11285(lootTable, rand.method_43055());
                }
            }
        }

        public static void generateMushrooms(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand) {
            if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
                worldIn.method_8652(blockpos, rand.method_43056() ? class_2246.field_10251.method_9564() : class_2246.field_10559.method_9564(), 2);
            }
        }

        public static void generateGold(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand) {
            class_2680 gold = ((class_2248)IafBlocks.GOLD_PILE.get()).method_9564();
            int choice = rand.method_43048(2);
            if (choice == 1) {
                gold = ((class_2248)IafBlocks.SILVER_PILE.get()).method_9564();
            } else if (choice == 2) {
                gold = ((class_2248)IafBlocks.COPPER_PILE.get()).method_9564();
            }
            if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
                worldIn.method_8652(blockpos, (class_2680)gold.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
                worldIn.method_8652(MyrmexHive.getGroundedPos(worldIn, blockpos.method_10095()), (class_2680)gold.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + class_5819.method_43047().method_43048(7))), 3);
                worldIn.method_8652(MyrmexHive.getGroundedPos(worldIn, blockpos.method_10072()), (class_2680)gold.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + class_5819.method_43047().method_43048(7))), 3);
                worldIn.method_8652(MyrmexHive.getGroundedPos(worldIn, blockpos.method_10067()), (class_2680)gold.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + class_5819.method_43047().method_43048(7))), 3);
                worldIn.method_8652(MyrmexHive.getGroundedPos(worldIn, blockpos.method_10078()), (class_2680)gold.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + class_5819.method_43047().method_43048(7))), 3);
                if (rand.method_43048(3) == 0) {
                    class_2586 tileentity1;
                    worldIn.method_8652(blockpos.method_10084(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)GenerationConstants.HORIZONTALS[class_5819.method_43047().method_43048(3)]), 2);
                    if (worldIn.method_8320(blockpos.method_10084()).method_26204() instanceof class_2281 && (tileentity1 = worldIn.method_8321(blockpos.method_10084())) instanceof class_2595) {
                        class_2595 chest = (class_2595)tileentity1;
                        chest.method_11285(MYRMEX_GOLD_CHEST, rand.method_43055());
                    }
                }
            }
        }

        public static void generateTrashHeap(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand) {
            if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
                class_2248 blob = switch (rand.method_43048(3)) {
                    case 0 -> class_2246.field_10566;
                    case 1 -> class_2246.field_10102;
                    case 2 -> class_2246.field_10445;
                    case 3 -> class_2246.field_10255;
                    default -> class_2246.field_10124;
                };
                int i1 = 0;
                for (int i = 0; i < 3; ++i) {
                    int j = i1 + rand.method_43048(2);
                    int k = i1 + rand.method_43048(2);
                    int l = i1 + rand.method_43048(2);
                    float f = (float)(j + k + l) * 0.333f + 0.5f;
                    for (class_2338 pos : class_2338.method_20437((class_2338)blockpos.method_10069(-j, -k, -l), (class_2338)blockpos.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                        if (!(pos.method_10262((class_2382)blockpos) <= (double)(f * f))) continue;
                        worldIn.method_8652(pos, blob.method_9564(), 4);
                    }
                    blockpos = blockpos.method_10069(-(i1 + 1) + rand.method_43048(2), -rand.method_43048(2), -(i1 + 1) + rand.method_43048(2));
                }
            }
        }

        public static void generateTrashOre(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand) {
            class_2248 current = worldIn.method_8320(blockpos).method_26204();
            if (origin.method_10262((class_2382)blockpos) <= (double)(radius * radius) && (current == class_2246.field_10566 || current == class_2246.field_10102 || current == class_2246.field_10445 || current == class_2246.field_10255)) {
                class_2248 ore = class_2246.field_10080;
                if (rand.method_43048(3) == 0) {
                    class_2248 class_22482 = ore = rand.method_43056() ? class_2246.field_10571 : (class_2248)IafBlocks.SILVER_ORE.get();
                    if (rand.method_43048(2) == 0) {
                        ore = class_2246.field_27120;
                    }
                } else if (rand.method_43048(3) == 0) {
                    ore = class_2246.field_10442;
                } else if (rand.method_43048(2) == 0) {
                    class_2248 class_22483 = ore = rand.method_43056() ? class_2246.field_10013 : (class_2248)IafBlocks.SAPPHIRE_ORE.get();
                    if (rand.method_43048(2) == 0) {
                        ore = class_2246.field_27161;
                    }
                }
                worldIn.method_8652(blockpos, ore.method_9564(), 2);
            }
        }
    }

    public static enum RoomType {
        DEFAULT(false),
        TUNNEL(false),
        ENTERANCE(false),
        QUEEN(false),
        FOOD(true),
        EMPTY(true),
        NURSERY(true),
        SHINY(true),
        TRASH(true);

        final boolean random;

        private RoomType(boolean random) {
            this.random = random;
        }

        public static RoomType random(class_5819 rand) {
            ArrayList<RoomType> list = new ArrayList<RoomType>();
            for (RoomType type : RoomType.values()) {
                if (!type.random) continue;
                list.add(type);
            }
            return (RoomType)((Object)list.get(rand.method_43048(list.size())));
        }
    }
}

