/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.registry.tag.CommonTags;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.iafenvoy.iceandfire.world.structure.DragonRoostStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3773;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_7151;

public class LightningDragonRoostStructure
extends DragonRoostStructure {
    public static final Codec<LightningDragonRoostStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LightningDragonRoostStructure.method_42697((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, LightningDragonRoostStructure::new)).codec();

    protected LightningDragonRoostStructure(class_3195.class_7302 config) {
        super(config);
    }

    @Override
    protected DragonRoostStructure.DragonRoostPiece createPiece(class_3341 boundingBox, boolean isMale) {
        return new LightningDragonRoostPiece(0, boundingBox, (class_2248)IafBlocks.COPPER_PILE.get(), isMale);
    }

    public class_7151<?> method_41618() {
        return (class_7151)IafStructureTypes.LIGHTNING_DRAGON_ROOST.get();
    }

    public static class LightningDragonRoostPiece
    extends DragonRoostStructure.DragonRoostPiece {
        private static final class_2960 DRAGON_CHEST = class_2960.method_43902((String)"iceandfire", (String)"chest/lightning_dragon_roost");

        protected LightningDragonRoostPiece(int length, class_3341 boundingBox, class_2248 treasureBlock, boolean isMale) {
            super((class_3773)IafStructurePieces.LIGHTNING_DRAGON_ROOST.get(), length, boundingBox, treasureBlock, isMale);
        }

        public LightningDragonRoostPiece(class_6625 context, class_2487 nbt) {
            super((class_3773)IafStructurePieces.LIGHTNING_DRAGON_ROOST.get(), nbt);
        }

        @Override
        protected class_1299<? extends EntityDragonBase> getDragonType() {
            return (class_1299)IafEntities.LIGHTNING_DRAGON.get();
        }

        @Override
        protected class_2960 getRoostLootTable() {
            return DRAGON_CHEST;
        }

        @Override
        protected class_2680 transform(class_2680 state) {
            class_2248 block = null;
            if (state.method_27852(class_2246.field_10219)) {
                block = (class_2248)IafBlocks.CRACKLED_GRASS.get();
            } else if (state.method_27852(class_2246.field_10194)) {
                block = (class_2248)IafBlocks.CRACKLED_DIRT_PATH.get();
            } else if (state.method_26164(CommonTags.Blocks.GRAVEL)) {
                block = (class_2248)IafBlocks.CRACKLED_GRAVEL.get();
            } else if (state.method_26164(class_3481.field_29822)) {
                block = (class_2248)IafBlocks.CRACKLED_DIRT.get();
            } else if (state.method_26164(CommonTags.Blocks.STONE)) {
                block = (class_2248)IafBlocks.CRACKLED_STONE.get();
            } else if (state.method_26164(CommonTags.Blocks.COBBLESTONE)) {
                block = (class_2248)IafBlocks.CRACKLED_COBBLESTONE.get();
            } else if (state.method_26164(class_3481.field_15475) || state.method_26164(class_3481.field_15471)) {
                block = (class_2248)IafBlocks.ASH.get();
            } else if (state.method_27852(class_2246.field_10479) || state.method_26164(class_3481.field_15503) || state.method_26164(class_3481.field_20339) || state.method_26164(class_3481.field_20341)) {
                block = class_2246.field_10124;
            }
            if (block != null) {
                return block.method_9564();
            }
            return state;
        }

        @Override
        protected void handleCustomGeneration(class_5281 world, class_2338 origin, class_5819 random, class_2338 position, double distance) {
            if (distance > 0.05 && random.method_43048(800) == 0) {
                this.generateSpire((class_1936)world, random, this.getSurfacePosition(world, position));
            }
            if (distance > 0.05 && random.method_43048(1000) == 0) {
                this.generateSpike((class_1936)world, random, this.getSurfacePosition(world, position), GenerationConstants.HORIZONTALS[random.method_43048(3)]);
            }
        }

        private void generateSpike(class_1936 worldIn, class_5819 rand, class_2338 position, class_2350 direction) {
            int radius = 5;
            for (int i = 0; i < 5; ++i) {
                int j = Math.max(0, radius - (int)((float)i * 1.75f));
                int l = radius - i;
                int k = Math.max(0, radius - (int)((float)i * 1.5f));
                float f = (float)(j + l) * 0.333f + 0.5f;
                class_2338 up = position.method_10084().method_10079(direction, i);
                int xOrZero = direction.method_10166() == class_2350.class_2351.field_11051 ? j : 0;
                int zOrZero = direction.method_10166() == class_2350.class_2351.field_11051 ? 0 : k;
                for (class_2338 blockpos : class_2338.method_20437((class_2338)up.method_10069(-xOrZero, -l, -zOrZero), (class_2338)up.method_10069(xOrZero, l, zOrZero)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                    if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f))) continue;
                    int height = Math.max(blockpos.method_10264() - up.method_10264(), 0);
                    if (i == 0) {
                        if (!(rand.method_43057() < (float)height * 0.3f)) continue;
                        worldIn.method_8652(blockpos, ((class_2248)IafBlocks.CRACKLED_STONE.get()).method_9564(), 2);
                        continue;
                    }
                    worldIn.method_8652(blockpos, ((class_2248)IafBlocks.CRACKLED_STONE.get()).method_9564(), 2);
                }
            }
        }

        private void generateSpire(class_1936 worldIn, class_5819 rand, class_2338 position) {
            int height = 5 + rand.method_43048(5);
            class_2350 bumpDirection = class_2350.field_11043;
            for (int i = 0; i < height; ++i) {
                worldIn.method_8652(position.method_10086(i), ((class_2248)IafBlocks.CRACKLED_STONE.get()).method_9564(), 2);
                if (rand.method_43056()) {
                    bumpDirection = bumpDirection.method_10170();
                }
                int offset = 1;
                if (i < 4) {
                    worldIn.method_8652(position.method_10086(i).method_10095(), ((class_2248)IafBlocks.CRACKLED_GRAVEL.get()).method_9564(), 2);
                    worldIn.method_8652(position.method_10086(i).method_10072(), ((class_2248)IafBlocks.CRACKLED_GRAVEL.get()).method_9564(), 2);
                    worldIn.method_8652(position.method_10086(i).method_10078(), ((class_2248)IafBlocks.CRACKLED_GRAVEL.get()).method_9564(), 2);
                    worldIn.method_8652(position.method_10086(i).method_10067(), ((class_2248)IafBlocks.CRACKLED_GRAVEL.get()).method_9564(), 2);
                    offset = 2;
                }
                if (i >= height - 2) continue;
                worldIn.method_8652(position.method_10086(i).method_10079(bumpDirection, offset), ((class_2248)IafBlocks.CRACKLED_COBBLESTONE.get()).method_9564(), 2);
            }
        }
    }
}

