/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_7923;

public abstract class DragonRoostStructure
extends class_3195 {
    protected DragonRoostStructure(class_3195.class_7302 config) {
        super(config);
    }

    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2470 blockRotation = class_2470.method_16548((class_5819)context.comp_566());
        class_2338 blockPos = this.method_42382(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new class_3195.class_7150(blockPos, collector -> collector.method_35462((class_3443)this.createPiece(new class_3341(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), context.comp_566().method_43056()))));
    }

    protected abstract DragonRoostPiece createPiece(class_3341 var1, boolean var2);

    protected static abstract class DragonRoostPiece
    extends class_3443 {
        protected final class_2248 treasureBlock;
        private final boolean isMale;

        protected DragonRoostPiece(class_3773 type, int length, class_3341 boundingBox, class_2248 treasureBlock, boolean isMale) {
            super(type, length, boundingBox);
            this.treasureBlock = treasureBlock;
            this.isMale = isMale;
        }

        public DragonRoostPiece(class_3773 type, class_2487 nbt) {
            super(type, nbt);
            this.treasureBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)nbt.method_10558("treasureBlock")));
            this.isMale = nbt.method_10577("isMale");
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
            nbt.method_10582("treasureBlock", class_7923.field_41175.method_10221((Object)this.treasureBlock).toString());
            nbt.method_10556("isMale", this.isMale);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            int radius = 12 + random.method_43048(8);
            this.spawnDragon(world, pivot, random, radius, this.isMale);
            this.generateSurface(world, pivot, random, radius);
            this.generateShell(world, pivot, random, radius);
            this.hollowOut(world, pivot, radius -= 2);
            this.generateDecoration(world, pivot, random, radius += 15, this.isMale);
        }

        protected void generateRoostPile(class_5281 level, class_5819 random, class_2338 position, class_2248 block) {
            int radius = random.method_43048(4);
            for (int i = 0; i < radius; ++i) {
                int layeredRadius = radius - i;
                double circularArea = this.getCircularArea(radius);
                class_2338 up = position.method_10086(i);
                for (class_2338 blockpos : class_2338.method_20437((class_2338)up.method_10069(-layeredRadius, 0, -layeredRadius), (class_2338)up.method_10069(layeredRadius, 0, layeredRadius)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                    if (!(blockpos.method_10262((class_2382)position) <= circularArea)) continue;
                    level.method_8652(blockpos, block.method_9564(), 2);
                }
            }
        }

        protected double getCircularArea(int radius, int height) {
            double area = (float)(radius + height + radius) * 0.333f + 0.5f;
            return class_3532.method_15357((double)(area * area));
        }

        protected double getCircularArea(int radius) {
            double area = (float)(radius + radius) * 0.333f + 0.5f;
            return class_3532.method_15357((double)(area * area));
        }

        protected class_2338 getSurfacePosition(class_5281 level, class_2338 position) {
            return level.method_8598(class_2902.class_2903.field_13194, position);
        }

        protected class_2680 transform(class_2248 block) {
            return this.transform(block.method_9564());
        }

        private void generateDecoration(class_5281 world, class_2338 origin, class_5819 random, int radius, boolean isMale) {
            int height = radius / 5;
            double circularArea = this.getCircularArea(radius, height);
            class_2338.method_20437((class_2338)origin.method_10069(-radius, -height, -radius), (class_2338)origin.method_10069(radius, height, radius)).map(class_2338::method_10062).forEach(position -> {
                if (position.method_10262((class_2382)origin) <= circularArea) {
                    class_2586 blockEntity;
                    class_2338 surfacePosition;
                    boolean wasPlaced;
                    class_2680 transformed;
                    class_2680 state;
                    double distance = position.method_10262((class_2382)origin) / circularArea;
                    if (!world.method_22347(origin) && random.method_43058() > distance * 0.5 && !((state = world.method_8320(position)).method_26204() instanceof class_2237) && state.method_26214((class_1922)world, position) >= 0.0f && (transformed = this.transform(state)) != state) {
                        world.method_8652(position, transformed, 2);
                    }
                    this.handleCustomGeneration(world, origin, random, (class_2338)position, distance);
                    if (distance > 0.5 && random.method_43048(1000) == 0) {
                        this.generateBoulder((class_1936)world, random, this.getSurfacePosition(world, (class_2338)position), this.transform(class_2246.field_10445).method_26204(), random.method_43048(3), true);
                    }
                    if (distance < 0.3 && random.method_43048(isMale ? 200 : 300) == 0) {
                        this.generateTreasurePile(world, random, (class_2338)position);
                    }
                    if (distance < 0.3 && random.method_43048(isMale ? 500 : 700) == 0 && (wasPlaced = world.method_8652(surfacePosition = world.method_8598(class_2902.class_2903.field_13202, position), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)GenerationConstants.HORIZONTALS[random.method_43048(3)]), 2)) && (blockEntity = world.method_8321(surfacePosition)) instanceof class_2595) {
                        class_2595 chest = (class_2595)blockEntity;
                        chest.method_11285(this.getRoostLootTable(), random.method_43055());
                    }
                    if (random.method_43048(5000) == 0) {
                        this.generateArch((class_1936)world, random, this.getSurfacePosition(world, (class_2338)position), this.transform(class_2246.field_10445).method_26204());
                    }
                }
            });
        }

        public void generateBoulder(class_1936 worldIn, class_5819 rand, class_2338 position, class_2248 block, int startRadius, boolean replaceAir) {
            while (position.method_10264() > 3) {
                if (worldIn.method_22347(position.method_10074())) {
                    position = position.method_10074();
                    continue;
                }
                class_2248 b = worldIn.method_8320(position.method_10074()).method_26204();
                if (b == class_2246.field_10479 || b == class_2246.field_10566 || b == class_2246.field_10340) break;
                position = position.method_10074();
            }
            if (position.method_10264() > 3) {
                for (int i = 0; startRadius >= 0 && i < 3; ++i) {
                    int j = startRadius + rand.method_43048(2);
                    int k = startRadius + rand.method_43048(2);
                    int l = startRadius + rand.method_43048(2);
                    float f = (float)(j + k + l) * 0.333f + 0.5f;
                    for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                        if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f)) || !replaceAir && !worldIn.method_8320(blockpos).method_26225()) continue;
                        worldIn.method_8652(blockpos, block.method_9564(), 2);
                    }
                    position = position.method_10069(-(startRadius + 1) + rand.method_43048(2 + startRadius * 2), -rand.method_43048(2), -(startRadius + 1) + rand.method_43048(2 + startRadius * 2));
                }
            }
        }

        private void generateArch(class_1936 worldIn, class_5819 rand, class_2338 position, class_2248 block) {
            int height = 3 + rand.method_43048(3);
            int width = Math.min(3, height - 2);
            class_2350 direction = GenerationConstants.HORIZONTALS[rand.method_43048(GenerationConstants.HORIZONTALS.length - 1)];
            boolean diagonal = rand.method_43056();
            for (int i = 0; i < height; ++i) {
                worldIn.method_8652(position.method_10086(i), block.method_9564(), 2);
            }
            class_2338 offsetPos = position;
            int placedWidths = 0;
            for (int i = 0; i < width; ++i) {
                offsetPos = position.method_10086(height).method_10079(direction, i);
                if (diagonal) {
                    offsetPos = position.method_10086(height).method_10079(direction, i).method_10079(direction.method_10170(), i);
                }
                if (placedWidths < width - 1 || rand.method_43056()) {
                    worldIn.method_8652(offsetPos, block.method_9564(), 2);
                }
                ++placedWidths;
            }
            while (worldIn.method_22347(offsetPos.method_10074()) && offsetPos.method_10264() > 0) {
                worldIn.method_8652(offsetPos.method_10074(), block.method_9564(), 2);
                offsetPos = offsetPos.method_10074();
            }
        }

        private void hollowOut(class_5281 world, class_2338 origin, int radius) {
            int height = 2;
            double circularArea = this.getCircularArea(radius, height);
            class_2338 up = origin.method_10086(height - 1);
            class_2338.method_20437((class_2338)up.method_10069(-radius, 0, -radius), (class_2338)up.method_10069(radius, height, radius)).map(class_2338::method_10062).forEach(position -> {
                if (position.method_10262((class_2382)origin) <= circularArea) {
                    world.method_8652(position, class_2246.field_10124.method_9564(), 2);
                }
            });
        }

        private void generateShell(class_5281 world, class_2338 origin, class_5819 random, int radius) {
            int height = radius / 5;
            double circularArea = this.getCircularArea(radius, height);
            class_2338.method_20437((class_2338)origin.method_10069(-radius, -height, -radius), (class_2338)origin.method_10069(radius, 1, radius)).map(class_2338::method_10062).forEach(position -> {
                if (position.method_10262((class_2382)origin) < circularArea) {
                    world.method_8652(position, random.method_43056() ? this.transform(class_2246.field_10255) : this.transform(class_2246.field_10566), 2);
                } else if (position.method_10262((class_2382)origin) == circularArea) {
                    world.method_8652(position, this.transform(class_2246.field_10445), 2);
                }
            });
        }

        private void generateSurface(class_5281 world, class_2338 origin, class_5819 random, int radius) {
            int height = 2;
            double circularArea = this.getCircularArea(radius, height);
            class_2338.method_20437((class_2338)origin.method_10069(-radius, height, -radius), (class_2338)origin.method_10069(radius, 0, radius)).map(class_2338::method_10062).forEach(position -> {
                int heightDifference = position.method_10264() - origin.method_10264();
                if (position.method_10262((class_2382)origin) <= circularArea && heightDifference < 2 + random.method_43048(height) && !world.method_22347(position.method_10074())) {
                    if (world.method_22347(position.method_10084())) {
                        world.method_8652(position, this.transform(class_2246.field_10479), 2);
                    } else {
                        world.method_8652(position, this.transform(class_2246.field_10566), 2);
                    }
                }
            });
        }

        private void generateTreasurePile(class_5281 world, class_5819 random, class_2338 origin) {
            int layers = random.method_43048(3);
            for (int i = 0; i < layers; ++i) {
                int radius = layers - i;
                double circularArea = this.getCircularArea(radius);
                for (class_2338 position : class_2338.method_20437((class_2338)origin.method_10069(-radius, i, -radius), (class_2338)origin.method_10069(radius, i, radius)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                    if (!(position.method_10262((class_2382)origin) <= circularArea)) continue;
                    position = world.method_8598(class_2902.class_2903.field_13202, position);
                    if (!(this.treasureBlock instanceof BlockGoldPile)) continue;
                    class_2680 state = world.method_8320(position);
                    boolean placed = false;
                    if (state.method_26215()) {
                        world.method_8652(position, (class_2680)this.treasureBlock.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + random.method_43048(7))), 2);
                        placed = true;
                    } else if (state.method_26204() instanceof class_2488) {
                        world.method_8652(position.method_10074(), (class_2680)this.treasureBlock.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)((Integer)state.method_11654((class_2769)class_2488.field_11518))), 2);
                        placed = true;
                    }
                    if (!placed || !(world.method_8320(position.method_10074()).method_26204() instanceof BlockGoldPile)) continue;
                    world.method_8652(position.method_10074(), (class_2680)this.treasureBlock.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 2);
                }
            }
        }

        private void spawnDragon(class_5281 world, class_2338 origin, class_5819 random, int ageOffset, boolean isMale) {
            EntityDragonBase dragon = (EntityDragonBase)this.getDragonType().method_5883((class_1937)world.method_8410());
            assert (dragon != null);
            dragon.setGender(isMale);
            dragon.growDragon(40 + ageOffset);
            dragon.setAgingDisabled(true);
            dragon.method_6033(dragon.method_6063());
            List<DragonColor> colors = DragonColor.getColorsByType(DragonType.getTypeByEntityType(this.getDragonType()));
            dragon.setVariant(colors.get(random.method_43048(colors.size())).name());
            dragon.method_5641((double)origin.method_10263() + 0.5, (double)world.method_8598(class_2902.class_2903.field_13194, origin).method_10264() + 1.5, (double)origin.method_10260() + 0.5, random.method_43057() * 360.0f, 0.0f);
            dragon.homePos = new HomePosition(origin, (class_1937)world.method_8410());
            dragon.hasHomePosition = true;
            dragon.setHunger(50);
            world.method_8649((class_1297)dragon);
        }

        protected abstract class_1299<? extends EntityDragonBase> getDragonType();

        protected abstract class_2960 getRoostLootTable();

        protected abstract class_2680 transform(class_2680 var1);

        protected abstract void handleCustomGeneration(class_5281 var1, class_2338 var2, class_5819 var3, class_2338 var4, double var5);
    }
}

