/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexQueen;
import com.iafenvoy.iceandfire.entity.EntityMyrmexSwarmer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackMelee;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIFindMate;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIMoveThroughHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIMoveToMate;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIWander;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIWanderHiveCenter;
import com.iafenvoy.iceandfire.entity.util.MyrmexTrades;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AdvancedPathNavigate;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3853;
import net.minecraft.class_3959;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class EntityMyrmexRoyal
extends EntityMyrmexBase {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public static final class_2960 DESERT_LOOT = class_2960.method_43902((String)"iceandfire", (String)"entities/myrmex_royal_desert");
    public static final class_2960 JUNGLE_LOOT = class_2960.method_43902((String)"iceandfire", (String)"entities/myrmex_royal_jungle");
    private static final class_2960 TEXTURE_DESERT = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_desert_royal.png");
    private static final class_2960 TEXTURE_JUNGLE = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_jungle_royal.png");
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(EntityMyrmexRoyal.class, (class_2941)class_2943.field_13323);
    public int releaseTicks = 0;
    public int daylightTicks = 0;
    public float flyProgress;
    public EntityMyrmexRoyal mate;
    private int hiveTicks = 0;
    private int breedingTicks = 0;
    private boolean isFlying;
    private boolean isLandNavigator;
    private boolean isMating = false;

    public EntityMyrmexRoyal(class_1299<? extends EntityMyrmexRoyal> t, class_1937 worldIn) {
        super(t, worldIn);
        this.switchNavigator(true);
    }

    public static class_2338 getPositionRelativetoGround(class_1297 entity, class_1937 world, double x, double z, class_5819 rand) {
        class_2338 pos = class_2338.method_49637((double)x, (double)entity.method_31478(), (double)z);
        for (int yDown = 0; yDown < 10; ++yDown) {
            if (world.method_22347(pos.method_10087(yDown))) continue;
            return pos.method_10086(yDown);
        }
        return pos;
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, (Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue() * 2.0).method_26868(class_5134.field_23717, 64.0).method_26868(class_5134.field_23724, 9.0);
    }

    @Override
    protected class_3853.class_1652[] getLevel1Trades() {
        return this.isJungle() ? (class_3853.class_1652[])MyrmexTrades.JUNGLE_ROYAL.get(1) : (class_3853.class_1652[])MyrmexTrades.DESERT_ROYAL.get(1);
    }

    @Override
    protected class_3853.class_1652[] getLevel2Trades() {
        return this.isJungle() ? (class_3853.class_1652[])MyrmexTrades.JUNGLE_ROYAL.get(2) : (class_3853.class_1652[])MyrmexTrades.DESERT_ROYAL.get(2);
    }

    protected class_2960 method_5991() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    public int method_6110() {
        return 10;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FLYING, (Object)Boolean.FALSE);
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_6207 = new class_1335((class_1308)this);
            this.field_6189 = this.createNavigator(this.method_37908(), AdvancedPathNavigate.MovementType.CLIMBING);
            this.isLandNavigator = true;
        } else {
            this.field_6207 = new FlyMoveHelper(this);
            this.field_6189 = this.createNavigator(this.method_37908(), AdvancedPathNavigate.MovementType.FLYING);
            this.isLandNavigator = false;
        }
    }

    public boolean isFlying() {
        if (this.method_37908().field_9236) {
            this.isFlying = (Boolean)this.field_6011.method_12789(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
        if (!this.method_37908().field_9236) {
            this.isFlying = flying;
        }
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("HiveTicks", this.hiveTicks);
        tag.method_10569("ReleaseTicks", this.releaseTicks);
        tag.method_10556("Flying", this.isFlying());
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.hiveTicks = tag.method_10550("HiveTicks");
        this.releaseTicks = tag.method_10550("ReleaseTicks");
        this.setFlying(tag.method_10577("Flying"));
    }

    public void method_6007() {
        super.method_6007();
        boolean flying = this.isFlying() && !this.method_24828();
        class_1309 attackTarget = this.method_5968();
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 1.0f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (flying) {
            double up = this.method_5799() ? 0.16 : 0.08;
            this.method_18799(this.method_18798().method_1031(0.0, up, 0.0));
        }
        if (flying && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!flying && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.daylightTicks = this.canSeeSky() ? ++this.daylightTicks : 0;
        if (flying && this.canSeeSky() && this.isBreedingSeason()) {
            ++this.releaseTicks;
        }
        if (!flying && this.canSeeSky() && this.daylightTicks > 300 && this.isBreedingSeason() && attackTarget == null && this.canMove() && this.method_24828() && !this.isMating) {
            this.setFlying(true);
            this.method_18799(this.method_18798().method_1031(0.0, 0.42, 0.0));
        }
        if (this.getGrowthStage() >= 2) {
            ++this.hiveTicks;
        }
        if (this.getAnimation() == ANIMATION_BITE && attackTarget != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            if (this.getAttackBounds().method_994(attackTarget.method_5829())) {
                attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && attackTarget != null && this.getAnimationTick() == 6) {
            this.playStingSound();
            if (this.getAttackBounds().method_994(attackTarget.method_5829())) {
                attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194() * 2));
                attackTarget.method_6092(new class_1293(class_1294.field_5899, 70, 1));
            }
        }
        if (this.mate != null) {
            this.method_37908().method_8421((class_1297)this, (byte)77);
            if (this.method_5739((class_1297)this.mate) < 10.0f) {
                this.setFlying(false);
                this.mate.setFlying(false);
                this.isMating = true;
                if (this.method_24828() && this.mate.method_24828()) {
                    ++this.breedingTicks;
                    if (this.breedingTicks > 100) {
                        if (this.method_5805()) {
                            this.mate.method_5650(class_1297.class_5529.field_26998);
                            this.method_5650(class_1297.class_5529.field_26998);
                            EntityMyrmexQueen queen = new EntityMyrmexQueen((class_1299<EntityMyrmexQueen>)((class_1299)IafEntities.MYRMEX_QUEEN.get()), this.method_37908());
                            queen.method_5719((class_1297)this);
                            queen.setJungleVariant(this.isJungle());
                            queen.setMadeHome(false);
                            if (!this.method_37908().field_9236) {
                                this.method_37908().method_8649((class_1297)queen);
                            }
                        }
                        this.isMating = false;
                    }
                }
            }
            this.mate.mate = this;
            if (!this.mate.method_5805()) {
                this.mate.mate = null;
                this.mate = null;
            }
        }
    }

    protected double attackDistance() {
        return 8.0;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new MyrmexAITradePlayer(this));
        this.field_6201.method_6277(0, (class_1352)new MyrmexAILookAtTradePlayer(this));
        this.field_6201.method_6277(0, (class_1352)new MyrmexAIMoveToMate(this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new AIFlyAtTarget());
        this.field_6201.method_6277(2, (class_1352)new AIFlyRandom());
        this.field_6201.method_6277(3, (class_1352)new MyrmexAIAttackMelee(this, 1.0, true));
        this.field_6201.method_6277(4, (class_1352)new MyrmexAILeaveHive(this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new MyrmexAIReEnterHive(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new MyrmexAIMoveThroughHive(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new MyrmexAIWanderHiveCenter(this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new MyrmexAIWander(this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new MyrmexAIDefendHive(this));
        this.field_6185.method_6277(2, (class_1352)new MyrmexAIFindMate(this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new MyrmexAIAttackPlayers(this));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, true, (Predicate)((com.google.common.base.Predicate)entity -> {
            if (entity instanceof EntityMyrmexBase && this.isBreedingSeason() || entity instanceof EntityMyrmexRoyal) {
                return false;
            }
            return entity != null && !EntityMyrmexBase.haveSameHive(this, (class_1297)entity) && DragonUtils.isAlive(entity) && !(entity instanceof class_1569);
        })));
    }

    public boolean method_6474(class_1429 otherAnimal) {
        if (otherAnimal == this || otherAnimal == null) {
            return false;
        }
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        if (((EntityMyrmexBase)otherAnimal).getHive() != null && this.getHive() != null) {
            return !this.getHive().equals(((EntityMyrmexBase)otherAnimal).getHive());
        }
        return true;
    }

    @Override
    public boolean shouldMoveThroughHive() {
        return false;
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23721).method_6192((Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue() * 2.0);
    }

    @Override
    public class_2960 getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 1.25f;
    }

    @Override
    public int getCasteImportance() {
        return 2;
    }

    @Override
    public boolean shouldLeaveHive() {
        return this.isBreedingSeason();
    }

    @Override
    public boolean shouldEnterHive() {
        return !this.isBreedingSeason();
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(this.method_6051().method_43056() ? ANIMATION_STING : ANIMATION_BITE);
            return true;
        }
        return false;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING};
    }

    public boolean isBreedingSeason() {
        return this.getGrowthStage() >= 2 && (this.getHive() == null || this.getHive().reproduces);
    }

    @Override
    public void method_5711(byte id) {
        if (id == 76) {
            this.playEffect(20);
        } else if (id == 77) {
            this.playEffect(7);
        } else {
            super.method_5711(id);
        }
    }

    protected void playEffect(int hearts) {
        for (int i = 0; i < hearts; ++i) {
            double d0 = this.field_5974.method_43059() * 0.02;
            double d1 = this.field_5974.method_43059() * 0.02;
            double d2 = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + 0.5 + (double)(this.field_5974.method_43057() * this.method_17682()), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), d0, d1, d2);
        }
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    public int method_19269() {
        return 0;
    }

    public boolean method_19270() {
        return false;
    }

    protected boolean isDirectPathBetweenPoints(class_2338 posVec31, class_2338 posVec32) {
        class_243 vector3d = class_243.method_24953((class_2382)posVec31);
        class_243 vector3d1 = class_243.method_24953((class_2382)posVec32);
        return this.method_37908().method_17742(new class_3959(vector3d, vector3d1, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    public boolean method_38069() {
        return this.method_37908().field_9236;
    }

    class FlyMoveHelper
    extends class_1335 {
        public FlyMoveHelper(EntityMyrmexRoyal pixie) {
            super((class_1308)pixie);
            this.field_6372 = 1.75;
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                if (EntityMyrmexRoyal.this.field_5976) {
                    EntityMyrmexRoyal.this.method_36456(EntityMyrmexRoyal.this.method_36454() + 180.0f);
                    this.field_6372 = 0.1f;
                    class_2338 target = EntityMyrmexRoyal.getPositionRelativetoGround((class_1297)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.method_37908(), EntityMyrmexRoyal.this.method_23317() + (double)EntityMyrmexRoyal.this.field_5974.method_43048(15) - 7.0, EntityMyrmexRoyal.this.method_23321() + (double)EntityMyrmexRoyal.this.field_5974.method_43048(15) - 7.0, EntityMyrmexRoyal.this.field_5974);
                    this.field_6370 = target.method_10263();
                    this.field_6369 = target.method_10264();
                    this.field_6367 = target.method_10260();
                }
                double d0 = this.field_6370 - EntityMyrmexRoyal.this.method_23317();
                double d1 = this.field_6369 - EntityMyrmexRoyal.this.method_23318();
                double d2 = this.field_6367 - EntityMyrmexRoyal.this.method_23321();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = Math.sqrt(d3)) < EntityMyrmexRoyal.this.method_5829().method_995()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    EntityMyrmexRoyal.this.method_18799(EntityMyrmexRoyal.this.method_18798().method_18805(0.5, 0.5, 0.5));
                } else {
                    EntityMyrmexRoyal.this.method_18799(EntityMyrmexRoyal.this.method_18798().method_1031(d0 / d3 * 0.1 * this.field_6372, d1 / d3 * 0.1 * this.field_6372, d2 / d3 * 0.1 * this.field_6372));
                    if (EntityMyrmexRoyal.this.method_5968() == null) {
                        EntityMyrmexRoyal.this.method_36456(-((float)class_3532.method_15349((double)EntityMyrmexRoyal.this.method_18798().field_1352, (double)EntityMyrmexRoyal.this.method_18798().field_1350)) * 57.295776f);
                        EntityMyrmexRoyal.this.field_6283 = EntityMyrmexRoyal.this.method_36454();
                    } else {
                        double d4 = EntityMyrmexRoyal.this.method_5968().method_23317() - EntityMyrmexRoyal.this.method_23317();
                        double d5 = EntityMyrmexRoyal.this.method_5968().method_23321() - EntityMyrmexRoyal.this.method_23321();
                        EntityMyrmexRoyal.this.method_36456(-((float)class_3532.method_15349((double)d4, (double)d5)) * 57.295776f);
                        EntityMyrmexRoyal.this.field_6283 = EntityMyrmexRoyal.this.method_36454();
                    }
                }
            }
        }
    }

    class AIFlyAtTarget
    extends class_1352 {
        public boolean method_6264() {
            if (EntityMyrmexRoyal.this.method_5968() != null && !EntityMyrmexRoyal.this.method_5962().method_6241() && EntityMyrmexRoyal.this.field_5974.method_43048(7) == 0) {
                return EntityMyrmexRoyal.this.method_5858((class_1297)EntityMyrmexRoyal.this.method_5968()) > 4.0;
            }
            return false;
        }

        public boolean method_6266() {
            return EntityMyrmexRoyal.this.method_5962().method_6241() && EntityMyrmexRoyal.this.method_5968() != null && EntityMyrmexRoyal.this.method_5968().method_5805();
        }

        public void method_6269() {
            class_1309 LivingEntity = EntityMyrmexRoyal.this.method_5968();
            assert (LivingEntity != null);
            class_243 Vector3d = LivingEntity.method_5836(1.0f);
            EntityMyrmexRoyal.this.field_6207.method_6239(Vector3d.field_1352, Vector3d.field_1351, Vector3d.field_1350, 1.0);
        }

        public void method_6270() {
        }

        public void method_6268() {
            class_1309 LivingEntity = EntityMyrmexRoyal.this.method_5968();
            if (LivingEntity != null) {
                if (EntityMyrmexRoyal.this.method_5829().method_994(LivingEntity.method_5829())) {
                    EntityMyrmexRoyal.this.method_6121((class_1297)LivingEntity);
                } else {
                    double d0 = EntityMyrmexRoyal.this.method_5858((class_1297)LivingEntity);
                    if (d0 < 9.0) {
                        class_243 Vector3d = LivingEntity.method_5836(1.0f);
                        EntityMyrmexRoyal.this.field_6207.method_6239(Vector3d.field_1352, Vector3d.field_1351, Vector3d.field_1350, 1.0);
                    }
                }
            }
        }
    }

    class AIFlyRandom
    extends class_1352 {
        class_2338 target;

        public AIFlyRandom() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (EntityMyrmexRoyal.this.isFlying() && EntityMyrmexRoyal.this.method_5968() == null) {
                if (EntityMyrmexRoyal.this instanceof EntityMyrmexSwarmer && ((EntityMyrmexSwarmer)EntityMyrmexRoyal.this).getSummoner() != null) {
                    class_1309 summon = ((EntityMyrmexSwarmer)EntityMyrmexRoyal.this).getSummoner();
                    this.target = EntityMyrmexRoyal.getPositionRelativetoGround((class_1297)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.method_37908(), summon.method_23317() + (double)EntityMyrmexRoyal.this.field_5974.method_43048(10) - 5.0, summon.method_23321() + (double)EntityMyrmexRoyal.this.field_5974.method_43048(10) - 5.0, EntityMyrmexRoyal.this.field_5974);
                } else {
                    this.target = EntityMyrmexRoyal.getPositionRelativetoGround((class_1297)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.method_37908(), EntityMyrmexRoyal.this.method_23317() + (double)EntityMyrmexRoyal.this.field_5974.method_43048(30) - 15.0, EntityMyrmexRoyal.this.method_23321() + (double)EntityMyrmexRoyal.this.field_5974.method_43048(30) - 15.0, EntityMyrmexRoyal.this.field_5974);
                }
                return EntityMyrmexRoyal.this.isDirectPathBetweenPoints(EntityMyrmexRoyal.this.method_24515(), this.target) && !EntityMyrmexRoyal.this.method_5962().method_6241() && EntityMyrmexRoyal.this.field_5974.method_43048(2) == 0;
            }
            return false;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6268() {
            if (!EntityMyrmexRoyal.this.isDirectPathBetweenPoints(EntityMyrmexRoyal.this.method_24515(), this.target)) {
                if (EntityMyrmexRoyal.this instanceof EntityMyrmexSwarmer && ((EntityMyrmexSwarmer)EntityMyrmexRoyal.this).getSummoner() != null) {
                    class_1309 summon = ((EntityMyrmexSwarmer)EntityMyrmexRoyal.this).getSummoner();
                    this.target = EntityMyrmexRoyal.getPositionRelativetoGround((class_1297)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.method_37908(), summon.method_23317() + (double)EntityMyrmexRoyal.this.field_5974.method_43048(10) - 5.0, summon.method_23321() + (double)EntityMyrmexRoyal.this.field_5974.method_43048(10) - 5.0, EntityMyrmexRoyal.this.field_5974);
                } else {
                    this.target = EntityMyrmexRoyal.getPositionRelativetoGround((class_1297)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.method_37908(), EntityMyrmexRoyal.this.method_23317() + (double)EntityMyrmexRoyal.this.field_5974.method_43048(30) - 15.0, EntityMyrmexRoyal.this.method_23321() + (double)EntityMyrmexRoyal.this.field_5974.method_43048(30) - 15.0, EntityMyrmexRoyal.this.field_5974);
                }
            }
            if (EntityMyrmexRoyal.this.method_37908().method_22347(this.target)) {
                EntityMyrmexRoyal.this.field_6207.method_6239((double)this.target.method_10263() + 0.5, (double)this.target.method_10264() + 0.5, (double)this.target.method_10260() + 0.5, 0.25);
                if (EntityMyrmexRoyal.this.method_5968() == null) {
                    EntityMyrmexRoyal.this.method_5988().method_6230((double)this.target.method_10263() + 0.5, (double)this.target.method_10264() + 0.5, (double)this.target.method_10260() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }
}

