/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.component.NeedUpdateData;
import com.iafenvoy.iceandfire.entity.EntitySiren;
import com.iafenvoy.iceandfire.entity.util.IHearsSiren;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3988;

public class SirenData
extends NeedUpdateData {
    public EntitySiren charmedBy;
    public int charmTime;
    public boolean isCharmed;
    private UUID charmedByUUID;
    private int charmedById;
    private boolean isInitialized;

    public void tickCharmed(class_1309 holder) {
        if (!(holder instanceof class_1657 || holder instanceof class_3988 || holder instanceof IHearsSiren)) {
            return;
        }
        if (!this.isInitialized) {
            this.initialize(holder.method_37908());
        }
        if (this.charmedBy == null) {
            return;
        }
        if (this.charmedBy.isActuallySinging()) {
            class_1657 player;
            if (EntitySiren.isWearingEarplugs(holder) || this.charmTime > (Integer)IafCommonConfig.INSTANCE.siren.maxSingTime.getValue()) {
                this.charmedBy.singCooldown = (Integer)IafCommonConfig.INSTANCE.siren.timeBetweenSongs.getValue();
                this.clearCharm();
                return;
            }
            if (!this.charmedBy.method_5805() || holder.method_5739((class_1297)this.charmedBy) > 64.0f || holder instanceof class_1657 && ((player = (class_1657)holder).method_7337() || player.method_7325())) {
                this.clearCharm();
                return;
            }
            if (holder.method_5739((class_1297)this.charmedBy) < 5.0f) {
                this.charmedBy.singCooldown = (Integer)IafCommonConfig.INSTANCE.siren.timeBetweenSongs.getValue();
                this.charmedBy.setSinging(false);
                this.charmedBy.method_5980(holder);
                this.charmedBy.method_19540(true);
                this.charmedBy.triggerOtherSirens(holder);
                this.clearCharm();
                return;
            }
            this.isCharmed = true;
            ++this.charmTime;
            if (holder.method_6051().method_43048(7) == 0) {
                for (int i = 0; i < 5; ++i) {
                    holder.method_37908().method_8406((class_2394)class_2398.field_11201, holder.method_23317() + (holder.method_6051().method_43058() - 0.5) * 3.0, holder.method_23318() + (holder.method_6051().method_43058() - 0.5) * 3.0, holder.method_23321() + (holder.method_6051().method_43058() - 0.5) * 3.0, 0.0, 0.0, 0.0);
                }
            }
            if (holder.field_5976) {
                holder.method_6100(true);
            }
            double motionXAdd = (Math.signum(this.charmedBy.method_23317() - holder.method_23317()) * 0.5 - holder.method_18798().field_1352) * 0.100000000372529;
            double motionYAdd = (Math.signum(this.charmedBy.method_23318() - holder.method_23318() + 1.0) * 0.5 - holder.method_18798().field_1351) * 0.100000000372529;
            double motionZAdd = (Math.signum(this.charmedBy.method_23321() - holder.method_23321()) * 0.5 - holder.method_18798().field_1350) * 0.100000000372529;
            holder.method_18799(holder.method_18798().method_1031(motionXAdd, motionYAdd, motionZAdd));
            if (holder.method_5765()) {
                holder.method_5848();
            }
            if (!(holder instanceof class_1657)) {
                double x = this.charmedBy.method_23317() - holder.method_23317();
                double y = this.charmedBy.method_23318() - 1.0 - holder.method_23318();
                double z = this.charmedBy.method_23321() - holder.method_23321();
                double radius = Math.sqrt(x * x + z * z);
                float xRot = (float)(-(class_3532.method_15349((double)y, (double)radius) * 57.29577951308232));
                float yRot = (float)(class_3532.method_15349((double)z, (double)x) * 57.29577951308232) - 90.0f;
                holder.method_36457(this.updateRotation(holder.method_36455(), xRot));
                holder.method_36456(this.updateRotation(holder.method_36454(), yRot));
            }
        }
    }

    public void setCharmed(class_1297 entity) {
        if (!(entity instanceof EntitySiren)) {
            return;
        }
        EntitySiren siren = (EntitySiren)entity;
        this.charmedBy = siren;
        this.isCharmed = true;
        this.triggerUpdate();
    }

    public void clearCharm() {
        this.charmTime = 0;
        this.isCharmed = false;
        this.charmedBy = null;
        this.triggerUpdate();
    }

    public void serialize(class_2487 tag) {
        class_2487 sirenData = new class_2487();
        if (this.charmedBy != null) {
            sirenData.method_10566("charmedByUUID", (class_2520)class_2512.method_25929((UUID)this.charmedBy.method_5667()));
            sirenData.method_10569("charmedById", this.charmedBy.method_5628());
        } else {
            sirenData.method_10569("charmedById", -1);
        }
        sirenData.method_10569("charmTime", this.charmTime);
        sirenData.method_10556("isCharmed", this.isCharmed);
        tag.method_10566("sirenData", (class_2520)sirenData);
    }

    public void deserialize(class_2487 tag) {
        class_2487 sirenData = tag.method_10562("sirenData");
        class_2520 uuidTag = sirenData.method_10580("charmedByUUID");
        if (uuidTag != null) {
            this.charmedByUUID = class_2512.method_25930((class_2520)uuidTag);
        }
        this.charmedById = sirenData.method_10550("charmedById");
        this.charmTime = sirenData.method_10550("charmTime");
        this.isCharmed = sirenData.method_10577("isCharmed");
        this.isInitialized = false;
    }

    private float updateRotation(float angle, float targetAngle) {
        float f = class_3532.method_15393((float)(targetAngle - angle));
        if (f > 30.0f) {
            f = 30.0f;
        }
        if (f < -30.0f) {
            f = -30.0f;
        }
        return angle + f;
    }

    private void initialize(class_1937 level) {
        class_1297 entity;
        this.charmedBy = null;
        if (this.charmedByUUID != null && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_1297 entity2 = serverLevel.method_14190(this.charmedByUUID);
            if (entity2 instanceof EntitySiren) {
                EntitySiren siren = (EntitySiren)entity2;
                this.triggerUpdate();
                this.charmedByUUID = null;
                this.charmedBy = siren;
            }
        } else if (this.charmedById != -1 && (entity = level.method_8469(this.charmedById)) instanceof EntitySiren) {
            EntitySiren siren;
            this.charmedBy = siren = (EntitySiren)entity;
        }
        this.isInitialized = true;
    }
}

