/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.data.component.NeedUpdateData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class MiscData
extends NeedUpdateData {
    public int loveTicks;
    public int lungeTicks;
    public boolean hasDismounted;
    public List<class_1309> targetedByScepter;
    private List<Integer> targetedByScepterIds;
    private boolean isInitialized;

    public void tickMisc(class_1309 entity) {
        if (!this.isInitialized) {
            this.initialize(entity.method_37908());
        }
        if (this.loveTicks > 0) {
            --this.loveTicks;
            if (this.loveTicks == 0) {
                this.triggerUpdate();
                if (entity instanceof class_1308) {
                    class_1308 mob = (class_1308)entity;
                    mob.method_5942().method_6356();
                }
                return;
            }
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.method_29505(null);
                mob.method_6015(null);
                mob.method_5980(null);
                mob.method_19540(false);
                mob.method_5942().method_6340();
            }
            this.createLoveParticles(entity);
        }
    }

    public List<class_1309> getTargetedByScepter() {
        return Objects.requireNonNullElse(this.targetedByScepter, Collections.emptyList());
    }

    public void addScepterTarget(class_1309 target) {
        if (this.targetedByScepter == null) {
            this.targetedByScepter = new ArrayList<class_1309>();
        } else if (this.targetedByScepter.contains(target)) {
            return;
        }
        this.targetedByScepter.add(target);
        this.triggerUpdate();
    }

    public void removeScepterTarget(class_1309 target) {
        if (this.targetedByScepter == null) {
            return;
        }
        this.targetedByScepter.remove(target);
        this.triggerUpdate();
    }

    public void checkScepterTarget() {
        if (this.targetedByScepter == null) {
            return;
        }
        this.targetedByScepter.removeIf(living -> living.method_31481() || living.method_6112(class_1294.field_5920) == null || living.method_6112(class_1294.field_5920).method_5584() <= 0);
    }

    public void setLoveTicks(int loveTicks) {
        this.loveTicks = loveTicks;
        this.triggerUpdate();
    }

    public void setLungeTicks(int lungeTicks) {
        this.lungeTicks = lungeTicks;
        this.triggerUpdate();
    }

    public void setDismounted(boolean hasDismounted) {
        this.hasDismounted = hasDismounted;
        this.triggerUpdate();
    }

    public void serialize(class_2487 tag) {
        class_2487 miscData = new class_2487();
        miscData.method_10569("loveTicks", this.loveTicks);
        miscData.method_10569("lungeTicks", this.lungeTicks);
        miscData.method_10556("hasDismounted", this.hasDismounted);
        if (this.targetedByScepter != null) {
            int[] ids = new int[this.targetedByScepter.size()];
            for (int i = 0; i < this.targetedByScepter.size(); ++i) {
                ids[i] = this.targetedByScepter.get(i).method_5628();
            }
            tag.method_10539("targetedByScepterIds", ids);
        }
        tag.method_10566("miscData", (class_2520)miscData);
    }

    public void deserialize(class_2487 tag) {
        class_2487 miscData = tag.method_10562("miscData");
        this.loveTicks = miscData.method_10550("loveTicks");
        this.lungeTicks = miscData.method_10550("lungeTicks");
        this.hasDismounted = miscData.method_10577("hasDismounted");
        int[] loadedChainedToIds = miscData.method_10561("targetedByScepterIds");
        this.isInitialized = false;
        if (loadedChainedToIds.length > 0) {
            this.targetedByScepterIds = new ArrayList<Integer>();
            for (int loadedChainedToId : loadedChainedToIds) {
                this.targetedByScepterIds.add(loadedChainedToId);
            }
        }
    }

    private void createLoveParticles(class_1309 entity) {
        if (entity.method_6051().method_43048(7) == 0) {
            for (int i = 0; i < 5; ++i) {
                entity.method_37908().method_8406((class_2394)class_2398.field_11201, entity.method_23317() + (entity.method_6051().method_43058() - 0.5) * 3.0, entity.method_23318() + (entity.method_6051().method_43058() - 0.5) * 3.0, entity.method_23321() + (entity.method_6051().method_43058() - 0.5) * 3.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void initialize(class_1937 level) {
        ArrayList<class_1309> entities = new ArrayList<class_1309>();
        if (this.targetedByScepterIds != null) {
            for (int id : this.targetedByScepterIds) {
                class_1297 entity;
                if (id == -1 || !((entity = level.method_8469(id)) instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity;
                entities.add(livingEntity);
            }
        }
        this.targetedByScepter = !entities.isEmpty() ? entities : null;
        this.targetedByScepterIds = null;
        this.isInitialized = true;
    }
}

