/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.data.component.ChainData;
import com.iafenvoy.iceandfire.data.component.ChickenData;
import com.iafenvoy.iceandfire.data.component.FrozenData;
import com.iafenvoy.iceandfire.data.component.MiscData;
import com.iafenvoy.iceandfire.data.component.SirenData;
import com.iafenvoy.iceandfire.impl.ComponentManager;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class IafEntityData {
    public final FrozenData frozenData = new FrozenData();
    public final ChainData chainData = new ChainData();
    public final SirenData sirenData = new SirenData();
    public final ChickenData chickenData = new ChickenData();
    public final MiscData miscData = new MiscData();
    private final class_1309 entity;
    private boolean isDirty = false;

    public IafEntityData(class_1309 entity) {
        this.entity = entity;
    }

    public void deserialize(@NotNull class_2487 tag) {
        this.frozenData.deserialize(tag);
        this.chainData.deserialize(tag);
        this.sirenData.deserialize(tag);
        this.chickenData.deserialize(tag);
        this.miscData.deserialize(tag);
    }

    public void serialize(@NotNull class_2487 tag) {
        this.frozenData.serialize(tag);
        this.chainData.serialize(tag);
        this.sirenData.serialize(tag);
        this.chickenData.serialize(tag);
        this.miscData.serialize(tag);
    }

    public void tick() {
        this.frozenData.tickFrozen(this.entity);
        this.chainData.tickChain(this.entity);
        this.sirenData.tickCharmed(this.entity);
        this.chickenData.tickChicken(this.entity);
        this.miscData.tickMisc(this.entity);
        this.isDirty = this.frozenData.doesClientNeedUpdate() || this.chainData.doesClientNeedUpdate() || this.sirenData.doesClientNeedUpdate() || this.miscData.doesClientNeedUpdate();
    }

    public boolean isDirty() {
        boolean d = this.isDirty;
        this.isDirty = false;
        return d;
    }

    public static IafEntityData get(class_1309 living) {
        return ComponentManager.getIafEntityData(living);
    }
}

