/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.offline;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.wispforest.owo.Owo;
import io.wispforest.owo.mixin.offline.AdvancementProgressAccessor;
import io.wispforest.owo.offline.DataSavedEvents;
import io.wispforest.owo.offline.OfflineAdvancementState;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_155;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2960;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import net.minecraft.class_5218;
import org.jetbrains.annotations.Nullable;

public final class OfflineAdvancementLookup {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_167.class, (Object)new class_167.class_168()).registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).setPrettyPrinting().create();
    private static final TypeToken<Map<class_2960, class_167>> JSON_TYPE = new TypeToken<Map<class_2960, class_167>>(){};

    private OfflineAdvancementLookup() {
    }

    public static void put(UUID player, Map<class_2960, class_167> map) {
        ((DataSavedEvents.Advancements)DataSavedEvents.ADVANCEMENTS.invoker()).onSaved(player, map);
        try {
            Path advancementsPath = Owo.currentServer().method_27050(class_5218.field_24180);
            Path advancementPath = advancementsPath.resolve(player.toString() + ".json");
            JsonElement savedElement = GSON.toJsonTree(map);
            savedElement.getAsJsonObject().addProperty("DataVersion", (Number)class_155.method_16673().method_37912().method_38494());
            try (OutputStream os = Files.newOutputStream(advancementPath, new OpenOption[0]);
                 OutputStreamWriter osWriter = new OutputStreamWriter(os, Charsets.UTF_8.newEncoder());){
                GSON.toJson(savedElement, (Appendable)osWriter);
            }
        }
        catch (IOException e) {
            Owo.LOGGER.error("Couldn't save advancements of offline player {}", (Object)player, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static Map<class_2960, class_167> get(UUID player) {
        try {
            Dynamic dynamic;
            Path advancementsPath = Owo.currentServer().method_27050(class_5218.field_24180);
            if (!Files.exists(advancementsPath, new LinkOption[0])) {
                return null;
            }
            Path advancementFile = advancementsPath.resolve(player + ".json");
            if (!Files.exists(advancementFile, new LinkOption[0])) {
                return null;
            }
            try (InputStream s = Files.newInputStream(advancementFile, new OpenOption[0]);
                 InputStreamReader streamReader = new InputStreamReader(s);
                 JsonReader reader = new JsonReader((Reader)streamReader);){
                reader.setLenient(false);
                dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)reader));
            }
            if (dynamic.get("DataVersion").asNumber().result().isEmpty()) {
                dynamic = dynamic.set("DataVersion", dynamic.createInt(1343));
            }
            dynamic = class_4284.field_19220.method_48128(class_3551.method_15450(), dynamic, dynamic.get("DataVersion").asInt(0));
            dynamic = dynamic.remove("DataVersion");
            Map parsedMap = (Map)GSON.getAdapter(JSON_TYPE).fromJsonTree((JsonElement)dynamic.getValue());
            for (Map.Entry entry : parsedMap.entrySet()) {
                class_161 adv;
                if (((AdvancementProgressAccessor)entry.getValue()).getRequirements().length != 0 || (adv = Owo.currentServer().method_3851().method_12896((class_2960)entry.getKey())) == null) continue;
                ((AdvancementProgressAccessor)entry.getValue()).setRequirements(adv.method_680());
            }
            return parsedMap;
        }
        catch (IOException e) {
            Owo.LOGGER.error("Couldn't get advancements for offline player {}", (Object)player, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void edit(UUID player, Consumer<OfflineAdvancementState> editor) {
        Map<class_2960, class_167> advancementData = OfflineAdvancementLookup.get(player);
        if (advancementData == null) {
            advancementData = new HashMap<class_2960, class_167>();
        }
        OfflineAdvancementState transaction = new OfflineAdvancementState(advancementData);
        editor.accept(transaction);
        OfflineAdvancementLookup.put(player, transaction.advancementData());
    }

    public static List<UUID> savedPlayers() {
        Path advancementsPath = Owo.currentServer().method_27050(class_5218.field_24180);
        if (!Files.isDirectory(advancementsPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<UUID> list = new ArrayList<UUID>();
        try {
            Iterator iterator = Files.list(advancementsPath).iterator();
            while (iterator.hasNext()) {
                Path savedPlayerFile = (Path)iterator.next();
                if (Files.isDirectory(savedPlayerFile, new LinkOption[0]) || !savedPlayerFile.toString().endsWith(".json")) continue;
                try {
                    String filename = savedPlayerFile.getFileName().toString();
                    String uuidStr = filename.substring(0, filename.lastIndexOf(46));
                    UUID uuid = UUID.fromString(uuidStr);
                    list.add(uuid);
                }
                catch (IllegalArgumentException iae) {
                    Owo.LOGGER.error("Encountered invalid UUID in advancements directory", (Throwable)iae);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }
}

