/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1311;
import net.minecraft.class_5483;

public interface ControlledSpawns {
    public List<class_5483.class_1964> getCombinedMonsterSpawnableList();

    public List<class_5483.class_1964> getCombinedCreatureSpawnableList();

    public List<class_5483.class_1964> getSpawnableList(class_1311 var1);

    public List<class_5483.class_1964> getSpawnableMonsterList(int var1);

    public record ControlledSpawningConfig(Map<String, List<class_5483.class_1964>> spawnableMonsterLists, List<class_5483.class_1964> ambientCreatureList, List<class_5483.class_1964> waterCreatureList, List<class_5483.class_1964> combinedMonsterSpawnableCache, List<class_5483.class_1964> combinedCreatureSpawnableCache) {
        public static final MapCodec<ControlledSpawningConfig> FLAT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_5483.class_1964.field_24681.listOf()).fieldOf("labelled_monster_spawns").forGetter(ControlledSpawningConfig::spawnableMonsterLists), (App)class_5483.class_1964.field_24681.listOf().fieldOf("ambient_spawns").forGetter(ControlledSpawningConfig::ambientCreatureList), (App)class_5483.class_1964.field_24681.listOf().fieldOf("water_spawns").forGetter(ControlledSpawningConfig::waterCreatureList)).apply((Applicative)instance, ControlledSpawningConfig::create));
        public static final ControlledSpawningConfig EMPTY = ControlledSpawningConfig.create(Map.of(), List.of(), List.of());

        public static ControlledSpawningConfig firstIndexMonsters(class_5483.class_1964 ... spawnableMonsterList) {
            return ControlledSpawningConfig.create(List.of(List.of(spawnableMonsterList)), List.of(), List.of());
        }

        public static ControlledSpawningConfig create(List<List<class_5483.class_1964>> spawnableMonsterLists, List<class_5483.class_1964> ambientCreatureList, List<class_5483.class_1964> waterCreatureList) {
            return ControlledSpawningConfig.create(ControlledSpawningConfig.convertMonsterList(spawnableMonsterLists), ambientCreatureList, waterCreatureList);
        }

        public static ControlledSpawningConfig create(Map<String, List<class_5483.class_1964>> spawnableMonsterLists, List<class_5483.class_1964> ambientCreatureList, List<class_5483.class_1964> waterCreatureList) {
            return new ControlledSpawningConfig(spawnableMonsterLists, ambientCreatureList, waterCreatureList, spawnableMonsterLists.values().stream().flatMap(Collection::stream).toList(), Streams.concat((Stream[])new Stream[]{ambientCreatureList.stream(), waterCreatureList.stream()}).toList());
        }

        private static Map<String, List<class_5483.class_1964>> convertMonsterList(List<List<class_5483.class_1964>> lists) {
            int i = 0;
            HashMap<String, List<class_5483.class_1964>> map = new HashMap<String, List<class_5483.class_1964>>();
            for (List<class_5483.class_1964> list : lists) {
                map.put("" + i, list);
                ++i;
            }
            return map;
        }

        public List<class_5483.class_1964> getForLabel(String index) {
            return this.spawnableMonsterLists().getOrDefault(index, List.of());
        }
    }
}

