/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer.vanillalegacy.context;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_4540;
import net.minecraft.class_5321;
import twilightforest.init.TFDimensionSettings;
import twilightforest.world.components.layer.vanillalegacy.Area;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.BigContext;

public class LazyAreaContext
implements BigContext<LazyArea> {
    private final Long2ObjectLinkedOpenHashMap<class_5321<class_1959>> cache;
    private final int maxCache;
    private final long seed;
    private long rval;

    public LazyAreaContext(int maxCache, long salt) {
        this.seed = LazyAreaContext.mixSeed(TFDimensionSettings.seed, salt);
        this.cache = new Long2ObjectLinkedOpenHashMap(16, 0.25f);
        this.cache.defaultReturnValue((Object)class_1972.field_9473);
        this.maxCache = maxCache;
    }

    @Override
    public LazyArea createResult(Area transformer) {
        return new LazyArea(this.cache, this.maxCache, transformer);
    }

    @Override
    public LazyArea createResult(Area transformer, LazyArea layer) {
        return new LazyArea(this.cache, Math.min(1024, layer.getMaxCache() * 4), transformer);
    }

    @Override
    public LazyArea createResult(Area transformer, LazyArea layer1, LazyArea layer2) {
        return new LazyArea(this.cache, Math.min(1024, Math.max(layer1.getMaxCache(), layer2.getMaxCache()) * 4), transformer);
    }

    @Override
    public void initRandom(long x, long z) {
        long i = this.seed;
        i = class_4540.method_22372((long)i, (long)x);
        i = class_4540.method_22372((long)i, (long)z);
        i = class_4540.method_22372((long)i, (long)x);
        this.rval = i = class_4540.method_22372((long)i, (long)z);
    }

    @Override
    public int nextRandom(int limit) {
        int i = Math.floorMod(this.rval >> 24, limit);
        this.rval = class_4540.method_22372((long)this.rval, (long)this.seed);
        return i;
    }

    private static long mixSeed(long seed, long salt) {
        long i = class_4540.method_22372((long)salt, (long)salt);
        i = class_4540.method_22372((long)i, (long)salt);
        i = class_4540.method_22372((long)i, (long)salt);
        long j = class_4540.method_22372((long)seed, (long)i);
        j = class_4540.method_22372((long)j, (long)i);
        return class_4540.method_22372((long)j, (long)i);
    }
}

