/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.LongFunction;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.world.components.layer.IThornsTransformer;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerType;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;

public record BorderLayer(class_5321<class_1959> targetBiome, class_5321<class_1959> borderBiome) implements IThornsTransformer
{
    @Override
    public class_5321<class_1959> apply(Context noise, class_5321<class_1959> up, class_5321<class_1959> left, class_5321<class_1959> down, class_5321<class_1959> right, class_5321<class_1959> center, class_5321<class_1959> nw, class_5321<class_1959> sw, class_5321<class_1959> se, class_5321<class_1959> ne) {
        if (BorderLayer.onBorder(this.targetBiome, center, right, left, up, down)) {
            return this.borderBiome;
        }
        if (BorderLayer.onBorder(this.targetBiome, center, ne, nw, se, sw)) {
            return this.borderBiome;
        }
        return center;
    }

    private static boolean onBorder(class_5321<class_1959> biomeID, class_5321<class_1959> center, class_5321<class_1959> right, class_5321<class_1959> left, class_5321<class_1959> up, class_5321<class_1959> down) {
        return center != biomeID && (right == biomeID || left == biomeID || up == biomeID || down == biomeID);
    }

    public static final class Factory
    implements BiomeLayerFactory {
        public static final Codec<Factory> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.LONG.fieldOf("salt").forGetter(Factory::salt), (App)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("target_biome").forGetter(Factory::target), (App)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("bordering_biome").forGetter(Factory::borderingBiome), (App)BiomeLayerStack.HOLDER_CODEC.fieldOf("parent").forGetter(Factory::parent)).apply((Applicative)inst, Factory::new));
        private final long salt;
        private final class_5321<class_1959> target;
        private final class_5321<class_1959> borderingBiome;
        private final class_6880<BiomeLayerFactory> parent;
        private final BorderLayer instance;

        public Factory(long salt, class_5321<class_1959> centerBiome, class_5321<class_1959> borderingBiome, class_6880<BiomeLayerFactory> parent) {
            this.salt = salt;
            this.target = centerBiome;
            this.borderingBiome = borderingBiome;
            this.parent = parent;
            this.instance = new BorderLayer(centerBiome, borderingBiome);
        }

        @Override
        public LazyArea build(LongFunction<LazyAreaContext> contextFactory) {
            return this.instance.run(contextFactory.apply(this.salt), ((BiomeLayerFactory)this.parent.comp_349()).build(contextFactory));
        }

        @Override
        public BiomeLayerType getType() {
            return (BiomeLayerType)BiomeLayerTypes.BORDER.get();
        }

        public long salt() {
            return this.salt;
        }

        public class_5321<class_1959> target() {
            return this.target;
        }

        public class_5321<class_1959> borderingBiome() {
            return this.borderingBiome;
        }

        public class_6880<BiomeLayerFactory> parent() {
            return this.parent;
        }
    }
}

