/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4662;

public class TFTreeFeatureConfig
implements class_3037 {
    public static final Codec<TFTreeFeatureConfig> codecTFTreeConfig = RecordCodecBuilder.create(instance -> instance.group((App)class_4651.field_24937.fieldOf("trunk_provider").forGetter(obj -> obj.trunkProvider), (App)class_4651.field_24937.fieldOf("leaves_provider").forGetter(obj -> obj.leavesProvider), (App)class_4651.field_24937.fieldOf("branch_provider").forGetter(obj -> obj.branchProvider), (App)class_4651.field_24937.fieldOf("roots_provider").forGetter(obj -> obj.rootsProvider), (App)Codec.INT.fieldOf("minimum_size").orElse((Object)20).forGetter(obj -> obj.minHeight), (App)Codec.INT.fieldOf("add_first_five_chance").orElse((Object)1).forGetter(obj -> obj.chanceAddFiveFirst), (App)Codec.INT.fieldOf("add_second_five_chance").orElse((Object)1).forGetter(obj -> obj.chanceAddFiveSecond), (App)Codec.BOOL.fieldOf("has_leaves").orElse((Object)true).forGetter(obj -> obj.hasLeaves), (App)Codec.BOOL.fieldOf("check_water").orElse((Object)false).forGetter(obj -> obj.checkWater), (App)class_4662.field_24962.listOf().fieldOf("decorators").orElseGet(ImmutableList::of).forGetter(obj -> obj.decorators)).apply((Applicative)instance, TFTreeFeatureConfig::new));
    public final class_4651 trunkProvider;
    public final class_4651 leavesProvider;
    public final class_4651 branchProvider;
    public final class_4651 rootsProvider;
    public final int minHeight;
    public final int chanceAddFiveFirst;
    public final int chanceAddFiveSecond;
    public final boolean hasLeaves;
    public final boolean checkWater;
    public transient boolean forcePlacement;
    public final List<class_4662> decorators;

    public TFTreeFeatureConfig(class_4651 trunk, class_4651 leaves, class_4651 branch, class_4651 roots, int height, int chanceFiveFirst, int chanceFiveSecond, boolean hasLeaves, boolean checkWater, List<class_4662> decorators) {
        this.trunkProvider = trunk;
        this.leavesProvider = leaves;
        this.branchProvider = branch;
        this.rootsProvider = roots;
        this.minHeight = height;
        this.chanceAddFiveFirst = Math.max(chanceFiveFirst, 1);
        this.chanceAddFiveSecond = Math.max(chanceFiveSecond, 1);
        this.hasLeaves = hasLeaves;
        this.checkWater = checkWater;
        this.decorators = decorators;
    }

    public void forcePlacement() {
        this.forcePlacement = true;
    }

    public static class Builder {
        private final class_4651 trunkProvider;
        private final class_4651 leavesProvider;
        private final class_4651 branchProvider;
        private final class_4651 rootsProvider;
        private int baseHeight;
        private int chanceFirstFive;
        private int chanceSecondFive;
        private boolean hasLeaves;
        private boolean checkWater;
        private final List<class_4662> decorators = Lists.newArrayList();

        public Builder(class_4651 trunk, class_4651 leaves, class_4651 branch, class_4651 roots) {
            this.trunkProvider = trunk;
            this.leavesProvider = leaves;
            this.branchProvider = branch;
            this.rootsProvider = roots;
        }

        public Builder minHeight(int height) {
            this.baseHeight = height;
            return this;
        }

        public Builder chanceFirstFive(int chance) {
            this.chanceFirstFive = chance;
            return this;
        }

        public Builder chanceSecondFive(int chance) {
            this.chanceSecondFive = chance;
            return this;
        }

        public Builder noLeaves() {
            this.hasLeaves = false;
            return this;
        }

        public Builder checksWater() {
            this.checkWater = true;
            return this;
        }

        public Builder addDecorator(class_4662 deco) {
            this.decorators.add(deco);
            return this;
        }

        public TFTreeFeatureConfig build() {
            return new TFTreeFeatureConfig(this.trunkProvider, this.leavesProvider, this.branchProvider, this.rootsProvider, this.baseHeight, this.chanceFirstFive, this.chanceSecondFive, this.hasLeaves, this.checkWater, this.decorators);
        }
    }
}

