/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.Maps;
import io.github.fabricators_of_create.porting_lib.tags.TagHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2265;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3449;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5454;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFPortalBlock;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.custom.Restrictions;
import twilightforest.item.MagicMapItem;
import twilightforest.util.LandmarkUtil;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.ITFTeleporter;
import twilightforest.world.registration.TFGenerationSettings;

public class TFTeleporter
implements ITFTeleporter {
    private static final Map<class_2960, Map<class_2265, PortalPosition>> destinationCoordinateCache = new HashMap<class_2960, Map<class_2265, PortalPosition>>();
    private static boolean locked;

    public TFTeleporter(boolean locked) {
        TFTeleporter.locked = locked;
    }

    public static class_2487 saveLinks(class_2487 tag) {
        class_2499 dcc = new class_2499();
        destinationCoordinateCache.forEach((rl, map) -> {
            class_2487 ct = new class_2487();
            class_2499 links = new class_2499();
            map.forEach((columnPos, portalPos) -> {
                class_2487 link = new class_2487();
                class_2487 column = new class_2487();
                column.method_10569("x", columnPos.comp_638());
                column.method_10569("z", columnPos.comp_639());
                link.method_10566("column", (class_2520)column);
                class_2487 portal = new class_2487();
                portal.method_10544("time", portalPos.lastUpdateTime);
                portal.method_10544("pos", portalPos.pos.method_10063());
                link.method_10566("portal", (class_2520)portal);
                links.add((Object)link);
            });
            ct.method_10566("links", (class_2520)links);
            ct.method_10582("name", rl.toString());
            dcc.add((Object)ct);
        });
        tag.method_10566("dest", (class_2520)dcc);
        return tag;
    }

    public static void loadLinks(class_2487 tag) {
        tag.method_10554("dest", 10).stream().map(class_2487.class::cast).forEach(dest -> {
            class_2960 name = new class_2960(dest.method_10558("name"));
            destinationCoordinateCache.putIfAbsent(name, Maps.newHashMapWithExpectedSize((int)4096));
            dest.method_10554("links", 10).stream().map(class_2487.class::cast).forEach(link -> {
                class_2487 column = link.method_10562("column");
                class_2487 portal = link.method_10562("portal");
                destinationCoordinateCache.get(name).put(new class_2265(column.method_10550("x"), column.method_10550("z")), new PortalPosition(class_2338.method_10092((long)portal.method_10537("pos")), portal.method_10537("time")));
            });
        });
    }

    @Override
    @Nullable
    public class_5454 getPortalInfo(class_1297 entity, class_3218 dest, Function<class_3218, class_5454> defaultPortalInfo) {
        class_3218 tfDim = dest.method_8503().method_3847(TFGenerationSettings.DIMENSION_KEY);
        double scale = tfDim == null ? 0.125 : tfDim.method_8597().comp_646();
        scale = dest.method_27983().equals(TFGenerationSettings.DIMENSION_KEY) ? 1.0 / scale : scale;
        class_2338 destPos = dest.method_8621().method_39538((double)entity.method_24515().method_10263() * scale, (double)entity.method_24515().method_10264(), (double)entity.method_24515().method_10260() * scale);
        class_5454 pos = TFTeleporter.placeInExistingPortal(dest, entity, destPos);
        if (pos == null) {
            TwilightForestMod.LOGGER.debug("Did not find existing portal, making a new one.");
            pos = TFTeleporter.moveToSafeCoords(dest, entity, destPos);
            this.makePortal(entity, dest, pos.field_25879);
            pos = TFTeleporter.placeInExistingPortal(dest, entity, class_2338.method_49638((class_2374)pos.field_25879));
        }
        return pos == null ? ITFTeleporter.super.getPortalInfo(entity, dest, defaultPortalInfo) : pos;
    }

    public static void changeDimension(class_1297 entity, class_3218 destWorld, ITFTeleporter teleporter) {
        class_5454 portalinfo = teleporter.getPortalInfo(entity, destWorld, arg_0 -> ((class_1297)entity).method_30329(arg_0));
        if (portalinfo == null) {
            TwilightForestMod.LOGGER.error("TwilightForest unexpected error - portalInfo returned null, can't enter dimension safely. entity - {}", (Object)entity.toString());
            return;
        }
        entity.method_38785();
        FabricDimensions.teleport((class_1297)entity, (class_3218)destWorld, (class_5454)portalinfo);
    }

    @Nullable
    private static class_5454 placeInExistingPortal(class_3218 destDim, class_1297 entity, class_2338 pos) {
        class_2338 blockpos;
        PortalPosition portalPosition;
        boolean flag = true;
        class_2265 columnPos = new class_2265(entity.method_24515().method_10263(), entity.method_24515().method_10260());
        PortalPosition portalPosition2 = portalPosition = destinationCoordinateCache.containsKey(destDim.method_27983().method_29177()) ? destinationCoordinateCache.get(destDim.method_27983().method_29177()).get(columnPos) : null;
        if (portalPosition != null) {
            blockpos = portalPosition.pos;
            portalPosition.lastUpdateTime = destDim.method_8510();
            flag = false;
            TwilightForestMod.LOGGER.debug("Using cache, validating. {}", (Object)blockpos);
            if (blockpos == null || !destDim.method_8320(blockpos).method_27852((class_2248)TFBlocks.TWILIGHT_PORTAL.get())) {
                TwilightForestMod.LOGGER.debug("Portal Invalid, recreating.");
                blockpos = null;
                destinationCoordinateCache.get(destDim.method_27983().method_29177()).remove(columnPos);
            }
        } else {
            blockpos = TFTeleporter.getPortalPosition(destDim, pos);
        }
        if (blockpos == null) {
            return null;
        }
        if (flag) {
            TwilightForestMod.LOGGER.debug("Caching Src Portal Blocks to {}", (Object)blockpos);
            destinationCoordinateCache.putIfAbsent(destDim.method_27983().method_29177(), Maps.newHashMapWithExpectedSize((int)4096));
            HashMap<class_2338, Boolean> portalBlocks = new HashMap<class_2338, Boolean>();
            portalBlocks.put(entity.method_24515(), true);
            TFPortalBlock.recursivelyValidatePortal(entity.method_37908(), entity.method_24515(), portalBlocks, new MutableInt(0), entity.method_37908().method_8320(entity.method_24515()));
            class_2338 finalBlockpos = blockpos;
            portalBlocks.forEach((blockPos, b) -> {
                if (b.booleanValue()) {
                    TwilightForestMod.LOGGER.debug("Caching {}", blockPos);
                    destinationCoordinateCache.get(destDim.method_27983().method_29177()).put(new class_2265(blockPos.method_10263(), blockPos.method_10260()), new PortalPosition(finalBlockpos, destDim.method_8510()));
                }
            });
            destDim.method_14178().method_17297(class_3230.field_19280, new class_1923(blockpos), 3, (Object)new class_2338(columnPos.comp_638(), blockpos.method_10264(), columnPos.comp_639()));
        }
        class_2338[] portalBorder = TFTeleporter.getBoundaryPositions(destDim, blockpos).toArray(new class_2338[0]);
        class_2338 borderPos = portalBorder[0];
        double portalX = (double)borderPos.method_10263() + 0.5;
        double portalY = (double)borderPos.method_10264() + 1.0;
        double portalZ = (double)borderPos.method_10260() + 0.5;
        return TFTeleporter.makePortalInfo(entity, portalX, portalY, portalZ);
    }

    @Nullable
    private static class_2338 getPortalPosition(class_3218 destDim, class_2338 pos) {
        int i = 200;
        double d0 = Double.MAX_VALUE;
        class_2338 result = null;
        for (int i1 = -i; i1 <= i; ++i1) {
            for (int j1 = -i; j1 <= i; ++j1) {
                if (!destDim.method_8621().method_11952(pos.method_10069(i1, 0, j1))) continue;
                class_1923 chunkPos = new class_1923(pos.method_10069(i1, 0, j1));
                class_2818 chunk = destDim.method_14178().method_21730(chunkPos.field_9181, chunkPos.field_9180);
                if (chunk == null || chunk.method_12225() == class_3194.field_19334) continue;
                class_2338 blockpos1 = pos.method_10069(i1, TFTeleporter.getScanHeight(destDim, pos) - pos.method_10264(), j1);
                while (blockpos1.method_10264() >= 0) {
                    class_2338 blockpos2 = blockpos1.method_10074();
                    if (!(d0 >= 0.0 && blockpos1.method_10262((class_2382)pos) >= d0 || !TFTeleporter.isPortal(chunk.method_8320(blockpos1)))) {
                        blockpos2 = blockpos1.method_10074();
                        while (TFTeleporter.isPortal(chunk.method_8320(blockpos2))) {
                            blockpos1 = blockpos2;
                            blockpos2 = blockpos2.method_10074();
                        }
                        float d1 = (float)blockpos1.method_10262((class_2382)pos);
                        if (d0 < 0.0 || (double)d1 < d0) {
                            d0 = d1;
                            result = blockpos1;
                            i = class_3532.method_15386((float)class_3532.method_15355((float)d1));
                        }
                    }
                    blockpos1 = blockpos2;
                }
            }
        }
        return result;
    }

    private static int getScanHeight(class_3218 world, class_2338 pos) {
        return TFTeleporter.getScanHeight(world, pos.method_10263(), pos.method_10260());
    }

    private static int getScanHeight(class_3218 world, int x, int z) {
        int worldHeight = world.method_31600() - 1;
        int chunkHeight = world.method_8497(x >> 4, z >> 4).method_12031() + 15;
        return Math.min(worldHeight, chunkHeight);
    }

    private static boolean isPortal(class_2680 state) {
        return state.method_26204() == TFBlocks.TWILIGHT_PORTAL.get();
    }

    private static Set<class_2338> getBoundaryPositions(class_3218 world, class_2338 start) {
        HashSet<class_2338> result = new HashSet<class_2338>();
        HashSet<class_2338> checked = new HashSet<class_2338>();
        checked.add(start);
        TFTeleporter.checkAdjacent(world, start, checked, result);
        return result;
    }

    private static void checkAdjacent(class_3218 world, class_2338 pos, Set<class_2338> checked, Set<class_2338> result) {
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            class_2338 offset = pos.method_10093(facing);
            if (!checked.add(offset)) continue;
            if (TFTeleporter.isPortalAt(world, offset)) {
                TFTeleporter.checkAdjacent(world, offset, checked, result);
                continue;
            }
            result.add(offset);
        }
    }

    private static boolean isPortalAt(class_3218 world, class_2338 pos) {
        return TFTeleporter.isPortal(world.method_8320(pos));
    }

    private static class_5454 moveToSafeCoords(class_3218 world, class_1297 entity, class_2338 pos) {
        boolean checkProgression = LandmarkUtil.isProgressionEnforced((class_1937)world);
        if (TFTeleporter.isSafeAround((class_1937)world, pos, entity, checkProgression)) {
            TwilightForestMod.LOGGER.debug("Portal destination looks safe!");
            return TFTeleporter.makePortalInfo(entity, class_243.method_24953((class_2382)pos));
        }
        TwilightForestMod.LOGGER.debug("Portal destination looks unsafe, rerouting!");
        class_2338 safeCoords = TFTeleporter.findSafeCoords(world, 200, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.debug("Safely rerouted!");
            return TFTeleporter.makePortalInfo(entity, safeCoords.method_10263(), entity.method_23318(), safeCoords.method_10260());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot first try, trying again with longer range.");
        safeCoords = TFTeleporter.findSafeCoords(world, 400, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to long range portal. Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(entity, safeCoords.method_10263(), entity.method_23318(), safeCoords.method_10260());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot second try, trying to move slightly towards the center between key biomes.");
        safeCoords = TFTeleporter.findSafeCoords(world, 400, TFTeleporter.moveTowardsCenter(pos, 0.5f), entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to slightly centered portal. Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(entity, safeCoords.method_10263(), entity.method_23318(), safeCoords.method_10260());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot third try, trying to move further towards the center between key biomes.");
        safeCoords = TFTeleporter.findSafeCoords(world, 400, TFTeleporter.moveTowardsCenter(pos, 0.9f), entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to very centered portal. Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(entity, safeCoords.method_10263(), entity.method_23318(), safeCoords.method_10260());
        }
        TwilightForestMod.LOGGER.warn("Still did not find a safe portal spot.");
        return TFTeleporter.makePortalInfo(entity, class_243.method_24953((class_2382)pos));
    }

    private static class_2338 moveTowardsCenter(class_2338 pos, float lerp) {
        class_2265 centerPos = MagicMapItem.getMagicMapCenter(pos.method_10263(), pos.method_10260());
        float vx = centerPos.comp_638() - pos.method_10263();
        float vz = centerPos.comp_639() - pos.method_10260();
        float nx = (float)pos.method_10263() + vx * lerp;
        float nz = (float)pos.method_10260() + vz * lerp;
        return class_2338.method_49637((double)nx, (double)pos.method_10264(), (double)nz);
    }

    public static boolean isSafeAround(class_1937 world, class_2338 pos, class_1297 entity, boolean checkProgression) {
        if (!TFTeleporter.isSafe(world, pos, entity, checkProgression)) {
            return false;
        }
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            if (TFTeleporter.isSafe(world, pos.method_10079(facing, 16), entity, checkProgression)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafe(class_1937 world, class_2338 pos, class_1297 entity, boolean checkProgression) {
        return !world.method_27983().equals(TFGenerationSettings.DIMENSION_KEY) || TFTeleporter.checkPos(world, pos) && (!checkProgression || TFTeleporter.checkBiome(world, pos, entity)) && TFTeleporter.checkStructure(world, pos);
    }

    private static boolean checkPos(class_1937 world, class_2338 pos) {
        return world.method_8621().method_11952(pos);
    }

    private static boolean checkStructure(class_1937 world, class_2338 pos) {
        boolean outsideLandmarkRange;
        boolean bl = outsideLandmarkRange = !LegacyLandmarkPlacements.blockNearLandmarkCenter(pos.method_10263(), pos.method_10260(), 5);
        if (!outsideLandmarkRange) {
            return false;
        }
        Optional<class_3449> possibleNearLandmark = LandmarkUtil.locateNearestLandmarkStart((class_1936)world, class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()));
        return possibleNearLandmark.isEmpty() || possibleNearLandmark.get().method_14969().method_14662((class_2382)pos);
    }

    private static boolean checkBiome(class_1937 world, class_2338 pos, class_1297 entity) {
        return Restrictions.isBiomeSafeFor((class_1959)world.method_23753(pos).comp_349(), entity);
    }

    @Nullable
    private static class_2338 findSafeCoords(class_3218 world, int range, class_2338 pos, class_1297 entity, boolean checkProgression) {
        int attempts = range / 8;
        for (int x = 0; x < attempts; ++x) {
            for (int z = 0; z < attempts; ++z) {
                class_2338 dPos = new class_2338(pos.method_10263() + x * attempts - range / 2, 100, pos.method_10260() + z * attempts - range / 2);
                if (!TFTeleporter.isSafeAround((class_1937)world, dPos, entity, checkProgression)) continue;
                return dPos;
            }
        }
        return null;
    }

    private void makePortal(class_1297 entity, class_3218 world, class_243 pos) {
        class_3218 serverLevel;
        class_1937 class_19372 = entity.method_37908();
        class_3218 src = class_19372 instanceof class_3218 ? (serverLevel = (class_3218)class_19372) : null;
        TFTeleporter.loadSurroundingArea(world, pos);
        class_2338 spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isPortalAt(world, blockPos));
        String name = entity.method_5477().getString();
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found existing portal for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cacheNewPortalCoords(src, spot, entity.method_24515());
            return;
        }
        spot = TFTeleporter.findPortalCoords(world, pos, blockpos -> TFTeleporter.isIdealForPortal(world, blockpos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found ideal portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cacheNewPortalCoords(src, this.makePortalAt((class_1937)world, spot), entity.method_24515());
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not find ideal portal spot, shooting for okay one for {}", (Object)name);
        spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isOkayForPortal(world, blockPos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found okay portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cacheNewPortalCoords(src, this.makePortalAt((class_1937)world, spot), entity.method_24515());
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not even find an okay portal spot, just making a random one for {}", (Object)name);
        double yFactor = TFTeleporter.getYFactor(world);
        TFTeleporter.cacheNewPortalCoords(src, this.makePortalAt((class_1937)world, class_2338.method_49637((double)entity.method_23317(), (double)(entity.method_23318() * yFactor - 1.0), (double)entity.method_23321())), entity.method_24515());
    }

    private static void loadSurroundingArea(class_3218 world, class_243 pos) {
        int x = class_3532.method_15357((double)pos.field_1352) >> 4;
        int z = class_3532.method_15357((double)pos.field_1351) >> 4;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                world.method_8497(x + dx, z + dz);
            }
        }
    }

    @Nullable
    private static class_2338 findPortalCoords(class_3218 world, class_243 loc, Predicate<class_2338> predicate) {
        double yFactor = TFTeleporter.getYFactor(world);
        int entityX = class_3532.method_15357((double)loc.field_1352);
        int entityZ = class_3532.method_15357((double)loc.field_1350);
        class_2338.class_2339 pos = new class_2338.class_2339();
        double spotWeight = -1.0;
        class_2338 spot = null;
        int range = 16;
        for (int rx = entityX - range; rx <= entityX + range; ++rx) {
            double xWeight = (double)rx + 0.5 - loc.field_1352;
            for (int rz = entityZ - range; rz <= entityZ + range; ++rz) {
                double zWeight = (double)rz + 0.5 - loc.field_1350;
                for (int ry = TFTeleporter.getScanHeight(world, rx, rz); ry >= world.method_31607(); --ry) {
                    if (!world.method_22347((class_2338)pos.method_10103(rx, ry, rz))) continue;
                    while (ry > world.method_31607() && world.method_22347((class_2338)pos.method_10103(rx, ry - 1, rz))) {
                        --ry;
                    }
                    double yWeight = (double)ry + 0.5 - loc.field_1351 * yFactor;
                    double rPosWeight = xWeight * xWeight + yWeight * yWeight + zWeight * zWeight;
                    if (!(spotWeight < 0.0) && !(rPosWeight < spotWeight) || !predicate.test((class_2338)pos)) continue;
                    spotWeight = rPosWeight;
                    spot = pos.method_10062();
                }
            }
        }
        return spot;
    }

    private static double getYFactor(class_3218 world) {
        return world.method_27983().method_29177().equals((Object)class_1937.field_25179.method_29177()) ? 2.0 : 0.5;
    }

    private static void cacheNewPortalCoords(@Nullable class_3218 srcDim, class_2338 pos, class_2338 srcPos) {
        if (srcDim == null) {
            return;
        }
        class_2338 exitPos = TFTeleporter.getPortalPosition(srcDim, srcPos);
        if (exitPos == null) {
            return;
        }
        TwilightForestMod.LOGGER.debug("Caching Dest Portal Blocks to {}", (Object)exitPos);
        destinationCoordinateCache.putIfAbsent(srcDim.method_27983().method_29177(), Maps.newHashMapWithExpectedSize((int)4096));
        destinationCoordinateCache.get(srcDim.method_27983().method_29177()).put(new class_2265(pos.method_10263(), pos.method_10260()), new PortalPosition(exitPos, srcDim.method_8510()));
        destinationCoordinateCache.get(srcDim.method_27983().method_29177()).put(new class_2265(pos.method_10072().method_10263(), pos.method_10072().method_10260()), new PortalPosition(exitPos, srcDim.method_8510()));
        destinationCoordinateCache.get(srcDim.method_27983().method_29177()).put(new class_2265(pos.method_10078().method_10263(), pos.method_10078().method_10260()), new PortalPosition(exitPos, srcDim.method_8510()));
        destinationCoordinateCache.get(srcDim.method_27983().method_29177()).put(new class_2265(pos.method_10072().method_10078().method_10263(), pos.method_10072().method_10078().method_10260()), new PortalPosition(exitPos, srcDim.method_8510()));
    }

    private static boolean isIdealForPortal(class_3218 world, class_2338 pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    class_2338 tPos = pos.method_10069(potentialX - 1, potentialY, potentialZ - 1);
                    class_2680 state = world.method_8320(tPos);
                    if ((potentialY != 0 || state.method_26164(class_3481.field_29822)) && (potentialY < 1 || state.method_45474())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected class_2338 makePortalAt(class_1937 world, class_2338 pos) {
        class_2680 grass = class_2246.field_10219.method_9564();
        world.method_8501(pos.method_10067().method_10095(), grass);
        world.method_8501(pos.method_10095(), grass);
        world.method_8501(pos.method_10078().method_10095(), grass);
        world.method_8501(pos.method_10089(2).method_10095(), grass);
        world.method_8501(pos.method_10067(), grass);
        world.method_8501(pos.method_10089(2), grass);
        world.method_8501(pos.method_10067().method_10072(), grass);
        world.method_8501(pos.method_10089(2).method_10072(), grass);
        world.method_8501(pos.method_10067().method_10077(2), grass);
        world.method_8501(pos.method_10077(2), grass);
        world.method_8501(pos.method_10078().method_10077(2), grass);
        world.method_8501(pos.method_10089(2).method_10077(2), grass);
        class_2680 dirt = class_2246.field_10566.method_9564();
        world.method_8501(pos.method_10074(), dirt);
        world.method_8501(pos.method_10078().method_10074(), dirt);
        world.method_8501(pos.method_10072().method_10074(), dirt);
        world.method_8501(pos.method_10078().method_10072().method_10074(), dirt);
        class_2680 portal = (class_2680)((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).method_9564().method_11657((class_2769)TFPortalBlock.DISALLOW_RETURN, (Comparable)Boolean.valueOf(locked || (Boolean)TFConfig.COMMON_CONFIG.shouldReturnPortalBeUsable.get() == false));
        world.method_8652(pos, portal, 2);
        world.method_8652(pos.method_10078(), portal, 2);
        world.method_8652(pos.method_10072(), portal, 2);
        world.method_8652(pos.method_10078().method_10072(), portal, 2);
        for (int dx = -1; dx <= 2; ++dx) {
            for (int dz = -1; dz <= 2; ++dz) {
                for (int dy = 1; dy <= 5; ++dy) {
                    world.method_8650(pos.method_10069(dx, dy, dz), false);
                }
            }
        }
        world.method_8652(pos.method_10067().method_10095().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10095().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10078().method_10095().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10089(2).method_10095().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10067().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10089(2).method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10067().method_10072().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10089(2).method_10072().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10067().method_10077(2).method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10077(2).method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10078().method_10077(2).method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10089(2).method_10077(2).method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        return pos;
    }

    private static class_2680 randNatureBlock(class_5819 random) {
        return ((class_2248)TagHelper.getRandomElement((class_2378)class_7923.field_41175, BlockTagGenerator.GENERATED_PORTAL_DECO, (class_5819)random).get()).method_9564();
    }

    private static boolean isOkayForPortal(class_3218 world, class_2338 pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    class_2338 tPos = pos.method_10069(potentialX - 1, potentialY, potentialZ - 1);
                    class_2680 state = world.method_8320(tPos);
                    if ((potentialY != 0 || state.method_51367() || state.method_51176()) && (potentialY < 1 || state.method_45474())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static class_5454 makePortalInfo(class_1297 entity, double x, double y, double z) {
        return TFTeleporter.makePortalInfo(entity, new class_243(x, y, z));
    }

    private static class_5454 makePortalInfo(class_1297 entity, class_243 pos) {
        return new class_5454(pos, class_243.field_1353, entity.method_36454(), entity.method_36455());
    }

    static class PortalPosition {
        public final class_2338 pos;
        long lastUpdateTime;

        PortalPosition(class_2338 pos, long time) {
            this.pos = pos;
            this.lastUpdateTime = time;
        }
    }
}

