/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import net.minecraft.class_7923;
import twilightforest.block.BanisterBlock;
import twilightforest.util.FeaturePlacers;

public class WoodPalette {
    public static final Codec<WoodPalette> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("planks").forGetter(p -> p.planks), (App)class_7923.field_41175.method_39673().fieldOf("stairs").forGetter(p -> p.stairs), (App)class_7923.field_41175.method_39673().fieldOf("slab").forGetter(p -> p.slab), (App)class_7923.field_41175.method_39673().fieldOf("button").forGetter(p -> p.button), (App)class_7923.field_41175.method_39673().fieldOf("fence").forGetter(p -> p.fence), (App)class_7923.field_41175.method_39673().fieldOf("gate").forGetter(p -> p.gate), (App)class_7923.field_41175.method_39673().fieldOf("plate").forGetter(p -> p.plate), (App)class_7923.field_41175.method_39673().fieldOf("banister").forGetter(p -> p.banister)).apply((Applicative)instance, WoodPalette::new));
    private final Set<class_2248> blocks;
    private final class_2248 planks;
    private final class_2248 stairs;
    private final class_2248 slab;
    private final class_2248 button;
    private final class_2248 fence;
    private final class_2248 gate;
    private final class_2248 plate;
    private final class_2248 banister;

    public WoodPalette(Supplier<class_2248> planks, Supplier<class_2510> stairs, Supplier<class_2248> slab, Supplier<class_2248> button, Supplier<class_2248> fence, Supplier<class_2248> gate, Supplier<class_2248> plate, Supplier<BanisterBlock> banister) {
        this(planks.get(), (class_2248)stairs.get(), slab.get(), button.get(), fence.get(), gate.get(), plate.get(), (class_2248)banister.get());
    }

    public WoodPalette(class_2248 planks, class_2248 stairs, class_2248 slab, class_2248 button, class_2248 fence, class_2248 gate, class_2248 plate, class_2248 banister) {
        this.planks = planks;
        this.stairs = stairs;
        this.slab = slab;
        this.button = button;
        this.fence = fence;
        this.gate = gate;
        this.plate = plate;
        this.banister = banister;
        this.blocks = new HashSet<class_2248>(List.of(this.planks, this.stairs, this.slab, this.button, this.fence, this.gate, this.plate, this.banister));
    }

    public boolean contains(class_2248 block) {
        return this.blocks.contains(block);
    }

    public class_3499.class_3501 modifyBlockWithType(WoodPalette targetPalette, class_3499.class_3501 state) {
        class_2680 newState = state.comp_1342();
        if (targetPalette.contains(newState.method_26204())) {
            return new class_3499.class_3501(state.comp_1341(), this.modifyBlockWithType(targetPalette, newState), state.comp_1343());
        }
        return state;
    }

    public class_2680 modifyBlockWithType(WoodPalette targetPalette, class_2680 state) {
        return switch (targetPalette.getWoodShapeFromBlock(state.method_26204())) {
            case WoodShapes.BLOCK -> this.planks.method_9564();
            case WoodShapes.STAIRS -> FeaturePlacers.transferAllStateKeys(state, this.stairs);
            case WoodShapes.SLAB -> FeaturePlacers.transferAllStateKeys(state, this.slab);
            case WoodShapes.FENCE -> FeaturePlacers.transferAllStateKeys(state, this.fence);
            case WoodShapes.GATE -> FeaturePlacers.transferAllStateKeys(state, this.gate);
            case WoodShapes.BUTTON -> FeaturePlacers.transferAllStateKeys(state, this.button);
            case WoodShapes.PLATE -> FeaturePlacers.transferAllStateKeys(state, this.plate);
            case WoodShapes.BANISTER -> FeaturePlacers.transferAllStateKeys(state, this.banister);
            default -> state;
        };
    }

    public WoodShapes getWoodShapeFromBlock(class_2248 b) {
        if (b == this.planks) {
            return WoodShapes.BLOCK;
        }
        if (b == this.stairs) {
            return WoodShapes.STAIRS;
        }
        if (b == this.slab) {
            return WoodShapes.SLAB;
        }
        if (b == this.button) {
            return WoodShapes.BUTTON;
        }
        if (b == this.fence) {
            return WoodShapes.FENCE;
        }
        if (b == this.gate) {
            return WoodShapes.GATE;
        }
        if (b == this.plate) {
            return WoodShapes.PLATE;
        }
        if (b == this.banister) {
            return WoodShapes.BANISTER;
        }
        return WoodShapes.INVALID;
    }

    public static enum WoodShapes {
        BLOCK,
        STAIRS,
        SLAB,
        BUTTON,
        FENCE,
        GATE,
        PLATE,
        BANISTER,
        INVALID;

    }
}

