/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.attributes.PortingLibAttributes;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.LivingEntityAccessor;
import io.github.fabricators_of_create.porting_lib.tags.TagHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1530;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1657;
import net.minecraft.class_1687;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2839;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7406;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.EnforcedHomePoint;

public class EntityUtil {
    public static <T extends class_1308> class_2338 bossChestLocation(T boss) {
        return !((EnforcedHomePoint)boss).isRestrictionPointValid((class_5321<class_1937>)boss.method_37908().method_27983()) ? boss.method_24515() : ((EnforcedHomePoint)boss).getRestrictionPoint().method_19446().method_10074();
    }

    public static boolean canDestroyBlock(class_1937 world, class_2338 pos, class_1297 entity) {
        return EntityUtil.canDestroyBlock(world, pos, world.method_8320(pos), entity);
    }

    public static boolean canDestroyBlock(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        float hardness = state.method_26214((class_1922)world, pos);
        return hardness >= 0.0f && hardness < 50.0f && !state.method_26215() && !(world.method_8321(pos) instanceof class_1263) && EntityUtil.canEntityDestroy(state, world, pos, entity) && !(entity instanceof class_1309);
    }

    private static boolean canEntityDestroy(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1510) {
            return !state.method_26164(class_3481.field_17753);
        }
        if (entity instanceof class_1528 || entity instanceof class_1687) {
            return state.method_26215() || class_1528.method_6883((class_2680)state);
        }
        return true;
    }

    public static class_3965 rayTrace(class_1297 entity, double range) {
        class_243 position = entity.method_5836(1.0f);
        class_243 look = entity.method_5828(1.0f);
        class_243 dest = position.method_1031(look.field_1352 * range, look.field_1351 * range, look.field_1350 * range);
        return entity.method_37908().method_17742(new class_3959(position, dest, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, entity));
    }

    public static class_3965 rayTrace(class_1657 player) {
        return EntityUtil.rayTrace(player, null);
    }

    public static class_3965 rayTrace(class_1657 player, @Nullable DoubleUnaryOperator modifier) {
        double range = player.method_5996(PortingLibAttributes.BLOCK_REACH).method_6194();
        return EntityUtil.rayTrace((class_1297)player, modifier == null ? range : modifier.applyAsDouble(range));
    }

    public static class_3414 getDeathSound(class_1309 living) {
        return ((LivingEntityAccessor)living).port_lib$getDeathSound();
    }

    public static void killLavaAround(class_1297 entity) {
        class_238 bounds = entity.method_5829().method_1014(9.0);
        for (double x = bounds.field_1323; x < bounds.field_1320; x += 1.0) {
            for (double z = bounds.field_1321; z < bounds.field_1324; z += 1.0) {
                for (double y = bounds.field_1322; y < bounds.field_1325; y += 1.0) {
                    class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
                    class_2680 state = entity.method_37908().method_8320(pos);
                    if (!state.method_27852(class_2246.field_10164)) continue;
                    entity.method_37908().method_8501(pos, class_2246.field_10124.method_9564());
                }
            }
        }
    }

    public static boolean properlyApplyCustomDamageSource(class_1308 entity, class_1297 victim, class_1282 source) {
        boolean flag;
        int i;
        float f = (float)entity.method_26825(class_5134.field_23721);
        float f1 = (float)entity.method_26825(class_5134.field_23722);
        if (victim instanceof class_1309) {
            f += class_1890.method_8218((class_1799)entity.method_6047(), (class_1310)((class_1309)victim).method_6046());
            f1 += (float)class_1890.method_8205((class_1309)entity);
        }
        if ((i = class_1890.method_8199((class_1309)entity)) > 0) {
            victim.method_5639(i * 4);
        }
        if (flag = victim.method_5643(source, f)) {
            if (f1 > 0.0f && victim instanceof class_1309) {
                ((class_1309)victim).method_6005((double)(f1 * 0.5f), (double)class_3532.method_15374((float)(entity.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(entity.method_36454() * ((float)Math.PI / 180)))));
                entity.method_18799(entity.method_18798().method_18805(0.6, 1.0, 0.6));
            }
            if (victim instanceof class_1657) {
                class_1657 player = (class_1657)victim;
                entity.method_24521(player, entity.method_6047(), player.method_6115() ? player.method_6030() : class_1799.field_8037);
            }
            entity.method_5723((class_1309)entity, victim);
            entity.method_6114(victim);
        }
        return flag;
    }

    @Nullable
    private static <T extends class_1297> T createEntityIgnoreException(class_1299<T> type, class_5425 levelAccessor) {
        try {
            return (T)type.method_5883((class_1937)levelAccessor.method_8410());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void tryHangPainting(class_5281 world, class_2338 pos, class_2350 direction, @Nullable class_5321<class_1535> chosenPainting) {
        if (chosenPainting == null) {
            return;
        }
        class_1534 painting = (class_1534)EntityUtil.createEntityIgnoreException(class_1299.field_6120, (class_5425)world);
        painting.method_5814((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        painting.method_6892(direction);
        painting.method_43402((class_6880)class_7923.field_41182.method_40264(chosenPainting).get());
        if (EntityUtil.checkValidPaintingPosition(world, painting)) {
            world.method_8649((class_1297)painting);
        }
    }

    @Nullable
    public static class_5321<class_1535> getPaintingOfSize(class_5819 rand, int minSize) {
        return EntityUtil.getPaintingOfSize(rand, minSize, minSize, false);
    }

    @Nullable
    public static class_5321<class_1535> getPaintingOfSize(class_5819 rand, int width, int height, boolean exactMeasurements) {
        ArrayList<class_5321> valid = new ArrayList<class_5321>();
        for (class_1535 art : TagHelper.getContents((class_2378)class_7923.field_41182, (class_6862)class_7406.field_38929)) {
            if (exactMeasurements) {
                if (art.method_6945() != width || art.method_6943() != height) continue;
                valid.add(class_5321.method_29179((class_5321)class_7924.field_41209, (class_2960)Objects.requireNonNull(class_7923.field_41182.method_10221((Object)art))));
                continue;
            }
            if (art.method_6945() < width && art.method_6943() < height) continue;
            valid.add(class_5321.method_29179((class_5321)class_7924.field_41209, (class_2960)Objects.requireNonNull(class_7923.field_41182.method_10221((Object)art))));
        }
        if (!valid.isEmpty()) {
            return (class_5321)valid.get(rand.method_43048(valid.size()));
        }
        return null;
    }

    public static boolean checkValidPaintingPosition(class_5281 world, @Nullable class_1534 painting) {
        if (painting == null) {
            return false;
        }
        class_238 largerBox = painting.method_5829();
        if (!world.method_8587((class_1297)painting, largerBox)) {
            return false;
        }
        List<class_1297> collidingEntities = EntityUtil.getEntitiesInAABB(world, largerBox);
        for (class_1297 entityOnList : collidingEntities) {
            if (!(entityOnList instanceof class_1530)) continue;
            return false;
        }
        return true;
    }

    public static List<class_1297> getEntitiesInAABB(class_5281 world, class_238 boundingBox) {
        ArrayList list = Lists.newArrayList();
        int i = class_3532.method_15357((double)((boundingBox.field_1323 - 2.0) / 16.0));
        int j = class_3532.method_15357((double)((boundingBox.field_1320 + 2.0) / 16.0));
        int k = class_3532.method_15357((double)((boundingBox.field_1321 - 2.0) / 16.0));
        int l = class_3532.method_15357((double)((boundingBox.field_1324 + 2.0) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                class_2791 chunk = world.method_22342(i1, j1, class_2806.field_16423);
                if (!(chunk instanceof class_2839)) continue;
                class_2839 proto = (class_2839)chunk;
                proto.method_12295().forEach(nbt -> {
                    class_1297 entity = class_1299.method_17842((class_2487)nbt, (class_1937)world.method_8410(), e -> e);
                    if (entity != null && boundingBox.method_994(entity.method_5829())) {
                        list.add(entity);
                    }
                });
            }
        }
        return list;
    }
}

