/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.inventory;

import io.github.fabricators_of_create.porting_lib.tags.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1715;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8566;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFMenuTypes;
import twilightforest.init.TFRecipes;
import twilightforest.inventory.UncraftingContainer;
import twilightforest.inventory.UncraftingInputContainer;
import twilightforest.inventory.slot.AssemblySlot;
import twilightforest.inventory.slot.UncraftingResultSlot;
import twilightforest.inventory.slot.UncraftingSlot;
import twilightforest.item.recipe.UncraftingRecipe;
import twilightforest.util.TFItemStackUtils;

public class UncraftingMenu
extends class_1703 {
    private static final String TAG_MARKER = "TwilightForestMarker";
    private final UncraftingContainer uncraftingMatrix = new UncraftingContainer(this);
    public final class_8566 assemblyMatrix = new class_1715((class_1703)this, 3, 3);
    private final class_8566 combineMatrix = new class_1715((class_1703)this, 3, 3);
    public final class_1263 tinkerInput = new UncraftingInputContainer(this);
    private final class_1731 tinkerResult = new class_1731();
    private final class_3914 positionData;
    private final class_1937 level;
    private final class_1657 player;
    public int unrecipeInCycle = 0;
    public int ingredientsInCycle = 0;
    public int recipeInCycle = 0;
    @Nullable
    public class_1860<?> storedGhostRecipe = null;

    public static UncraftingMenu fromNetwork(int id, class_1661 inventory) {
        return new UncraftingMenu(id, inventory, inventory.field_7546.method_37908(), class_3914.field_17304);
    }

    public UncraftingMenu(int id, class_1661 inventory, class_1937 level, class_3914 positionData) {
        super((class_3917)TFMenuTypes.UNCRAFTING.get(), id);
        int invY;
        int invX;
        this.positionData = positionData;
        this.level = level;
        this.player = inventory.field_7546;
        this.method_7621(new class_1735(this.tinkerInput, 0, 13, 35));
        this.method_7621((class_1735)new UncraftingResultSlot(inventory.field_7546, this.tinkerInput, this.uncraftingMatrix, (class_1263)this.assemblyMatrix, (class_1263)this.tinkerResult, 0, 147, 35));
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.method_7621(new UncraftingSlot(inventory.field_7546, this.tinkerInput, this.uncraftingMatrix, (class_1263)this.assemblyMatrix, invY + invX * 3, 300000 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.method_7621(new AssemblySlot((class_1263)this.assemblyMatrix, invY + invX * 3, 62 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 9; ++invY) {
                this.method_7621(new class_1735((class_1263)inventory, invY + invX * 9 + 9, 8 + invY * 18, 84 + invX * 18));
            }
        }
        for (invX = 0; invX < 9; ++invX) {
            this.method_7621(new class_1735((class_1263)inventory, invX, 8 + invX * 18, 142));
        }
        this.method_7609((class_1263)this.assemblyMatrix);
    }

    public void method_7609(class_1263 inventory) {
        if (inventory == this.tinkerInput) {
            this.uncraftingMatrix.method_5448();
            class_1799 inputStack = this.tinkerInput.method_5438(0);
            class_1860<?>[] recipes = UncraftingMenu.getRecipesFor(inputStack, this.level);
            int size = recipes.length;
            if (size > 0 && !inputStack.method_31573(ItemTagGenerator.BANNED_UNCRAFTABLES)) {
                int n;
                int i;
                class_1860<?> recipe = recipes[Math.floorMod(this.unrecipeInCycle, size)];
                this.storedGhostRecipe = recipe;
                class_1799[] recipeItems = this.getIngredients(recipe);
                if (recipe instanceof class_1869) {
                    class_1869 rec = (class_1869)recipe;
                    int recipeWidth = rec.method_8150();
                    int recipeHeight = rec.method_8158();
                    for (int invY = 0; invY < recipeHeight; ++invY) {
                        for (int invX = 0; invX < recipeWidth; ++invX) {
                            int index = invX + invY * recipeWidth;
                            if (index >= recipeItems.length) continue;
                            class_1799 ingredient = UncraftingMenu.normalizeIngredient(recipeItems[index].method_7972());
                            this.uncraftingMatrix.method_5447(invX + invY * 3, ingredient);
                        }
                    }
                } else {
                    for (i = 0; i < this.uncraftingMatrix.method_5439(); ++i) {
                        if (i >= recipeItems.length) continue;
                        class_1799 ingredient = UncraftingMenu.normalizeIngredient(recipeItems[i].method_7972());
                        this.uncraftingMatrix.method_5447(i, ingredient);
                    }
                }
                if (inputStack.method_7986()) {
                    int damagedParts = this.countDamagedParts(inputStack);
                    for (i = 0; i < 9 && damagedParts > 0; ++i) {
                        class_1799 stack = this.uncraftingMatrix.method_5438(i);
                        if (!UncraftingMenu.isDamageableComponent(stack)) continue;
                        UncraftingMenu.markStack(stack);
                        --damagedParts;
                    }
                }
                for (int i2 = 0; i2 < 9; ++i2) {
                    class_1799 ingredient = this.uncraftingMatrix.method_5438(i2);
                    if (!UncraftingMenu.isIngredientProblematic(ingredient)) continue;
                    UncraftingMenu.markStack(ingredient);
                }
                if (recipe instanceof UncraftingRecipe) {
                    UncraftingRecipe uncraftingRecipe = (UncraftingRecipe)recipe;
                    n = uncraftingRecipe.count();
                } else {
                    n = recipe.method_8110(this.level.method_30349()).method_7947();
                }
                this.uncraftingMatrix.numberOfInputItems = n;
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
                this.uncraftingMatrix.recraftingCost = 0;
            } else {
                this.storedGhostRecipe = null;
                this.uncraftingMatrix.numberOfInputItems = 0;
                this.uncraftingMatrix.uncraftingCost = 0;
            }
        }
        if (inventory == this.assemblyMatrix || inventory == this.tinkerInput) {
            if (this.tinkerInput.method_5442()) {
                this.chooseRecipe(this.assemblyMatrix);
            } else {
                this.tinkerResult.method_5447(0, class_1799.field_8037);
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
            }
            this.uncraftingMatrix.recraftingCost = 0;
        }
        if (inventory != this.combineMatrix && !this.uncraftingMatrix.method_5442() && !this.assemblyMatrix.method_5442()) {
            for (int i = 0; i < 9; ++i) {
                class_1799 assembly = this.assemblyMatrix.method_5438(i);
                class_1799 uncrafting = this.uncraftingMatrix.method_5438(i);
                if (!assembly.method_7960()) {
                    this.combineMatrix.method_5447(i, assembly);
                    continue;
                }
                if (!uncrafting.method_7960() && !UncraftingMenu.isMarked(uncrafting)) {
                    this.combineMatrix.method_5447(i, uncrafting);
                    continue;
                }
                this.combineMatrix.method_5447(i, class_1799.field_8037);
            }
            this.chooseRecipe(this.combineMatrix);
            class_1799 input = this.tinkerInput.method_5438(0);
            class_1799 result = this.tinkerResult.method_5438(0);
            if (!result.method_7960() && UncraftingMenu.isValidMatchForInput(input, result)) {
                class_2487 inputTags = null;
                if (input.method_7969() != null) {
                    inputTags = input.method_7969().method_10553();
                }
                Map resultInnateEnchantments = class_1890.method_8222((class_1799)result);
                Map inputEnchantments = class_1890.method_8222((class_1799)input);
                inputEnchantments.keySet().removeIf(enchantment -> enchantment == null || !enchantment.method_8192(result));
                if (inputTags != null) {
                    inputTags.method_10551("ench");
                    inputTags.method_10551("Damage");
                    result.method_7980(inputTags);
                    class_1890.method_8214((Map)inputEnchantments, (class_1799)result);
                }
                for (Map.Entry entry : resultInnateEnchantments.entrySet()) {
                    class_1887 ench = (class_1887)entry.getKey();
                    int level = (Integer)entry.getValue();
                    if (!class_1890.method_8201(class_1890.method_8222((class_1799)result).keySet(), (class_1887)ench) || class_1890.method_8225((class_1887)ench, (class_1799)result) >= level) continue;
                    result.method_7978(ench, level);
                }
                this.tinkerResult.method_5447(0, result);
                this.uncraftingMatrix.uncraftingCost = 0;
                this.uncraftingMatrix.recraftingCost = this.calculateRecraftingCost();
            }
        }
    }

    public static void markStack(class_1799 stack) {
        stack.method_7959(TAG_MARKER, (class_2520)class_2481.method_23233((byte)1));
    }

    public static boolean isMarked(class_1799 stack) {
        class_2487 stackTag = stack.method_7969();
        return stackTag != null && stackTag.method_10577(TAG_MARKER);
    }

    public static void unmarkStack(class_1799 stack) {
        TFItemStackUtils.clearInfoTag(stack, TAG_MARKER);
    }

    private static boolean isIngredientProblematic(class_1799 ingredient) {
        return !ingredient.method_7960() && ingredient.method_7909().method_7857() || ingredient.method_31574(class_1802.field_8077);
    }

    private static class_1799 normalizeIngredient(class_1799 ingredient) {
        if (ingredient.method_7947() > 1) {
            ingredient.method_7939(1);
        }
        return ingredient;
    }

    private static class_1860<?>[] getRecipesFor(class_1799 inputStack, class_1937 world) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        if (!inputStack.method_7960()) {
            for (class_1860 recipe : world.method_8433().method_8126()) {
                if (!UncraftingMenu.isRecipeSupported(recipe) || recipe.method_31584() || !recipe.method_8113(3, 3) || recipe.method_8117().isEmpty() || !UncraftingMenu.matches(inputStack, recipe.method_8110(world.method_30349())) || ((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.reverseRecipeBlacklist.get()).booleanValue() != ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingRecipes.get()).contains(recipe.method_8114().toString()) || ((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.flipUncraftingModIdList.get()).booleanValue() != ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.get()).contains(recipe.method_8114().method_12836())) continue;
                recipes.add(recipe);
            }
            for (UncraftingRecipe uncraftingRecipe : world.method_8433().method_30027((class_3956)TFRecipes.UNCRAFTING_RECIPE.get())) {
                if (!uncraftingRecipe.isItemStackAnIngredient(inputStack)) continue;
                recipes.add(uncraftingRecipe);
            }
        }
        return recipes.toArray(new class_1860[0]);
    }

    private static boolean isRecipeSupported(class_1860<?> recipe) {
        return (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.allowShapelessUncrafting.get() != false ? recipe instanceof class_3955 : recipe instanceof class_1869;
    }

    private static boolean matches(class_1799 input, class_1799 output) {
        return input.method_31574(output.method_7909()) && input.method_7947() >= output.method_7947();
    }

    private static class_3955[] getRecipesFor(class_8566 matrix, class_1937 world) {
        return world.method_8433().method_17877(class_3956.field_17545, (class_1263)matrix, world).toArray(new class_3955[0]);
    }

    private void chooseRecipe(class_8566 inventory) {
        class_3955[] recipes = UncraftingMenu.getRecipesFor(inventory, this.level);
        if (recipes.length == 0) {
            this.tinkerResult.method_5447(0, class_1799.field_8037);
            return;
        }
        class_3955 recipe = recipes[Math.floorMod(this.recipeInCycle, recipes.length)];
        if (!(recipe == null || recipe.method_8118() || this.level.method_8450().method_8355(class_1928.field_19407) && !((class_3222)this.player).method_14253().method_14878((class_1860)recipe))) {
            this.tinkerResult.method_7662((class_1860)recipe);
            this.tinkerResult.method_5447(0, recipe.method_8116((class_1263)inventory, this.level.method_30349()));
        } else {
            this.tinkerResult.method_5447(0, class_1799.field_8037);
        }
    }

    private static boolean isValidMatchForInput(class_1799 inputStack, class_1799 resultStack) {
        if (inputStack.method_31573(class_3489.field_42614) && resultStack.method_31573(class_3489.field_42614)) {
            return true;
        }
        if (inputStack.method_31573(class_3489.field_42612) && resultStack.method_31573(class_3489.field_42612)) {
            return true;
        }
        if (inputStack.method_31573(class_3489.field_42615) && resultStack.method_31573(class_3489.field_42615)) {
            return true;
        }
        if (inputStack.method_31573(class_3489.field_42613) && resultStack.method_31573(class_3489.field_42613)) {
            return true;
        }
        if (inputStack.method_31573(class_3489.field_42611) && resultStack.method_31573(class_3489.field_42611)) {
            return true;
        }
        if (inputStack.method_31573(Tags.Items.TOOLS_BOWS) && resultStack.method_31573(Tags.Items.TOOLS_BOWS)) {
            return true;
        }
        if (inputStack.method_31573(Tags.Items.TOOLS_CROSSBOWS) && resultStack.method_31573(Tags.Items.TOOLS_CROSSBOWS)) {
            return true;
        }
        if (inputStack.method_31573(Tags.Items.TOOLS_FISHING_RODS) && resultStack.method_31573(Tags.Items.TOOLS_FISHING_RODS)) {
            return true;
        }
        if (inputStack.method_31573(Tags.Items.ARMORS) && resultStack.method_31573(Tags.Items.ARMORS)) {
            return class_1309.method_32326((class_1799)inputStack) == class_1309.method_32326((class_1799)resultStack);
        }
        return false;
    }

    public int getUncraftingCost() {
        return this.uncraftingMatrix.uncraftingCost;
    }

    public int getRecraftingCost() {
        return this.uncraftingMatrix.recraftingCost;
    }

    private int calculateUncraftingCost() {
        if ((!((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.get()).booleanValue() || this.storedGhostRecipe instanceof UncraftingRecipe) && this.assemblyMatrix.method_5442()) {
            int n;
            class_1860<?> class_18602 = this.storedGhostRecipe;
            if (class_18602 instanceof UncraftingRecipe) {
                UncraftingRecipe recipe = (UncraftingRecipe)class_18602;
                n = recipe.cost();
            } else {
                n = (int)Math.round((double)UncraftingMenu.countDamageableParts(this.uncraftingMatrix) * (Double)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.uncraftingXpCostMultiplier.get());
            }
            return n;
        }
        return 0;
    }

    private int calculateRecraftingCost() {
        class_1799 input = this.tinkerInput.method_5438(0);
        class_1799 output = this.tinkerResult.method_5438(0);
        if (input.method_7960() || output.method_7960()) {
            return 0;
        }
        int cost = 0;
        if (!class_1799.method_7984((class_1799)input, (class_1799)output)) {
            cost += this.assemblyMatrix.method_51305().stream().filter(stack -> !stack.method_7960()).toList().size();
        }
        int enchantCost = UncraftingMenu.countTotalEnchantmentCost(input);
        cost += enchantCost;
        int damagedCost = (1 + this.countDamagedParts(input)) * class_1890.method_8222((class_1799)output).size();
        cost += damagedCost;
        cost = Math.max(1, cost);
        return (int)Math.round((double)cost * (Double)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.repairingXpCostMultiplier.get());
    }

    private static int countTotalEnchantmentCost(class_1799 stack) {
        int count = 0;
        for (Map.Entry entry : class_1890.method_8222((class_1799)stack).entrySet()) {
            class_1887 ench = (class_1887)entry.getKey();
            int level = (Integer)entry.getValue();
            if (ench == null || level <= 0) continue;
            count += UncraftingMenu.getWeightModifier(ench) * level;
            ++count;
        }
        return count;
    }

    private static int getWeightModifier(class_1887 ench) {
        return switch (ench.method_8186().method_8197()) {
            case 1 -> 8;
            case 2 -> 4;
            case 3, 4, 5 -> 2;
            default -> 1;
        };
    }

    public void method_7593(int slotNum, int mouseButton, class_1713 clickType, class_1657 player) {
        if (slotNum > 0 && ((class_1735)this.field_7761.get((int)slotNum)).field_7871 == this.assemblyMatrix && player.field_7512.method_34255().method_7960() && !((class_1735)this.field_7761.get(slotNum)).method_7681() && this.assemblyMatrix.method_5442() && (clickType != class_1713.field_7791 || player.method_31548().method_5438(mouseButton).method_7960())) {
            slotNum -= 9;
        }
        if (slotNum > 0 && ((class_1735)this.field_7761.get((int)slotNum)).field_7871 == this.tinkerResult && this.calculateRecraftingCost() > player.field_7520 && !player.method_31549().field_7477) {
            return;
        }
        if (slotNum > 0 && ((class_1735)this.field_7761.get((int)slotNum)).field_7871 == this.uncraftingMatrix) {
            if (((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.get()).booleanValue() && !(this.storedGhostRecipe instanceof UncraftingRecipe)) {
                return;
            }
            if (this.calculateUncraftingCost() > player.field_7520 && !player.method_31549().field_7477) {
                return;
            }
            class_1799 stackInSlot = ((class_1735)this.field_7761.get(slotNum)).method_7677();
            if (stackInSlot.method_7960() || UncraftingMenu.isMarked(stackInSlot)) {
                return;
            }
        }
        super.method_7593(slotNum, mouseButton, clickType, player);
        if (slotNum > 0 && ((class_1735)this.field_7761.get((int)slotNum)).field_7871 == this.tinkerInput) {
            this.method_7609(this.tinkerInput);
        }
    }

    private static boolean isDamageableComponent(class_1799 stack) {
        return !stack.method_7960() && !stack.method_31573(ItemTagGenerator.UNCRAFTING_IGNORES_COST);
    }

    private static int countDamageableParts(class_1263 matrix) {
        int count = matrix.method_5439();
        for (int i = 0; i < matrix.method_5439(); ++i) {
            if (!UncraftingMenu.isIngredientProblematic(matrix.method_5438(i)) && !UncraftingMenu.isMarked(matrix.method_5438(i)) && UncraftingMenu.isDamageableComponent(matrix.method_5438(i))) continue;
            --count;
        }
        return count;
    }

    private int countDamagedParts(class_1799 input) {
        int totalMax4 = Math.max(4, UncraftingMenu.countDamageableParts(this.uncraftingMatrix));
        float damage = (float)input.method_7919() / (float)input.method_7936();
        return (int)Math.ceil((float)totalMax4 * damage);
    }

    public class_1799 method_7601(class_1657 player, int slotNum) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotNum);
        if (slot != null && slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            if (slotNum == 0) {
                if (!this.method_7616(itemstack1, 20, 56, false)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemstack1, itemstack);
            } else if (slotNum == 1) {
                this.positionData.method_17393((p_39378_, p_39379_) -> itemstack1.method_7909().method_7843(itemstack1, p_39378_, player));
                if (!this.method_7616(itemstack1, 20, 56, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemstack1, itemstack);
            } else if (slotNum >= 20 && slotNum < 56) {
                if (!this.method_7616(itemstack1, 0, 1, false)) {
                    return class_1799.field_8037;
                }
            } else if (slot.field_7871 == this.assemblyMatrix) {
                if (!this.method_7616(itemstack1, 20, 56, false)) {
                    return class_1799.field_8037;
                }
            } else if (this.method_7616(itemstack1, 20, 56, false)) {
                slot.method_7667(player, itemstack1);
                return class_1799.field_8037;
            }
            if (itemstack1.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemstack1.method_7947() == itemstack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemstack1);
            if (slotNum == 1) {
                player.method_7328(itemstack1, false);
            }
        }
        return itemstack;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.positionData.method_17393((world, pos) -> {
            this.method_7607(player, (class_1263)this.assemblyMatrix);
            this.method_7607(player, this.tinkerInput);
        });
    }

    private class_1799[] getIngredients(class_1860<?> recipe) {
        class_1799[] stacks = new class_1799[recipe.method_8117().size()];
        for (int i = 0; i < recipe.method_8117().size(); ++i) {
            class_1799[] matchingStacks = (class_1799[])Arrays.stream(((class_1856)recipe.method_8117().get(i)).method_8105()).filter(s -> !s.method_31573(ItemTagGenerator.BANNED_UNCRAFTING_INGREDIENTS)).toArray(class_1799[]::new);
            stacks[i] = matchingStacks.length > 0 ? matchingStacks[Math.floorMod(this.ingredientsInCycle, matchingStacks.length)] : class_1799.field_8037;
        }
        return stacks;
    }

    public boolean method_7597(class_1657 player) {
        return (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableEntireTable.get() == false && UncraftingMenu.method_17695((class_3914)this.positionData, (class_1657)player, (class_2248)((class_2248)TFBlocks.UNCRAFTING_TABLE.get()));
    }
}

