/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import com.mojang.serialization.Codec;
import io.github.fabricators_of_create.porting_lib.util.LazyRegistrar;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFStructures;
import twilightforest.init.custom.Enforcement;
import twilightforest.util.PlayerHelper;
import twilightforest.util.Restriction;

public class Restrictions {
    public static final class_5321<class_2378<Restriction>> RESTRICTION_KEY = class_5321.method_29180((class_2960)TwilightForestMod.namedRegistry("restrictions"));
    public static final LazyRegistrar<Restriction> RESTRICTIONS = LazyRegistrar.create(RESTRICTION_KEY, (String)"twilightforest");
    public static final Codec<class_6880<Restriction>> CODEC = class_5381.method_31192(RESTRICTION_KEY, Restriction.CODEC, (boolean)false);
    public static final class_5321<Restriction> DARK_FOREST = Restrictions.makeKey(TFBiomes.DARK_FOREST.method_29177());
    public static final class_5321<Restriction> DARK_FOREST_CENTER = Restrictions.makeKey(TFBiomes.DARK_FOREST_CENTER.method_29177());
    public static final class_5321<Restriction> FINAL_PLATEAU = Restrictions.makeKey(TFBiomes.FINAL_PLATEAU.method_29177());
    public static final class_5321<Restriction> FIRE_SWAMP = Restrictions.makeKey(TFBiomes.FIRE_SWAMP.method_29177());
    public static final class_5321<Restriction> GLACIER = Restrictions.makeKey(TFBiomes.GLACIER.method_29177());
    public static final class_5321<Restriction> HIGHLANDS = Restrictions.makeKey(TFBiomes.HIGHLANDS.method_29177());
    public static final class_5321<Restriction> SNOWY_FOREST = Restrictions.makeKey(TFBiomes.SNOWY_FOREST.method_29177());
    public static final class_5321<Restriction> SWAMP = Restrictions.makeKey(TFBiomes.SWAMP.method_29177());
    public static final class_5321<Restriction> THORNLANDS = Restrictions.makeKey(TFBiomes.THORNLANDS.method_29177());
    public static final Restriction DARK_FOREST_RESTRICTION = new Restriction(TFStructures.KNIGHT_STRONGHOLD, (class_5321<Enforcement>)Enforcement.DARKNESS.getKey(), 0.0f, Restrictions.asStack(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE), List.of(TwilightForestMod.prefix("progress_lich")));
    public static final Restriction DARK_FOREST_CENTER_RESTRICTION = new Restriction(TFStructures.DARK_TOWER, (class_5321<Enforcement>)Enforcement.DARKNESS.getKey(), 0.0f, Restrictions.asStack(TFBlocks.KNIGHT_PHANTOM_TROPHY), List.of(TwilightForestMod.prefix("progress_knights")));
    public static final Restriction FINAL_PLATEAU_RESTRICTION = new Restriction(TFStructures.FINAL_CASTLE, (class_5321<Enforcement>)Enforcement.ACID_RAIN.getKey(), 1.5f, Restrictions.asStack(TFItems.LAMP_OF_CINDERS), List.of(TwilightForestMod.prefix("progress_troll")));
    public static final Restriction FIRE_SWAMP_RESTRICTION = new Restriction(TFStructures.HYDRA_LAIR, (class_5321<Enforcement>)Enforcement.FIRE.getKey(), 8.0f, Restrictions.asStack(TFItems.MEEF_STROGANOFF), List.of(TwilightForestMod.prefix("progress_labyrinth")));
    public static final Restriction GLACIER_RESTRICTION = new Restriction(TFStructures.AURORA_PALACE, (class_5321<Enforcement>)Enforcement.FROST.getKey(), 3.0f, Restrictions.asStack(TFItems.ALPHA_YETI_FUR), List.of(TwilightForestMod.prefix("progress_yeti")));
    public static final Restriction HIGHLANDS_RESTRICTION = new Restriction(TFStructures.TROLL_CAVE, (class_5321<Enforcement>)Enforcement.ACID_RAIN.getKey(), 0.5f, Restrictions.asStack(TFBlocks.UBEROUS_SOIL), List.of(TwilightForestMod.prefix("progress_merge")));
    public static final Restriction SNOWY_FOREST_RESTRICTION = new Restriction(TFStructures.YETI_CAVE, (class_5321<Enforcement>)Enforcement.FROST.getKey(), 2.0f, Restrictions.asStack(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE), List.of(TwilightForestMod.prefix("progress_lich")));
    public static final Restriction SWAMP_RESTRICTION = new Restriction(TFStructures.LABYRINTH, (class_5321<Enforcement>)Enforcement.HUNGER.getKey(), 1.0f, Restrictions.asStack(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE), List.of(TwilightForestMod.prefix("progress_lich")));
    public static final Restriction THORNLANDS_RESTRICTION = new Restriction(TFStructures.FINAL_CASTLE, (class_5321<Enforcement>)Enforcement.ACID_RAIN.getKey(), 1.0f, Restrictions.asStack(TFItems.LAMP_OF_CINDERS), List.of(TwilightForestMod.prefix("progress_troll")));

    private static class_5321<Restriction> makeKey(class_2960 name) {
        return class_5321.method_29179(RESTRICTION_KEY, (class_2960)name);
    }

    public static void bootstrap(class_7891<Restriction> context) {
        context.method_46838(DARK_FOREST, (Object)DARK_FOREST_RESTRICTION);
        context.method_46838(DARK_FOREST_CENTER, (Object)DARK_FOREST_CENTER_RESTRICTION);
        context.method_46838(FINAL_PLATEAU, (Object)FINAL_PLATEAU_RESTRICTION);
        context.method_46838(FIRE_SWAMP, (Object)FIRE_SWAMP_RESTRICTION);
        context.method_46838(GLACIER, (Object)GLACIER_RESTRICTION);
        context.method_46838(HIGHLANDS, (Object)HIGHLANDS_RESTRICTION);
        context.method_46838(SNOWY_FOREST, (Object)SNOWY_FOREST_RESTRICTION);
        context.method_46838(SWAMP, (Object)SWAMP_RESTRICTION);
        context.method_46838(THORNLANDS, (Object)THORNLANDS_RESTRICTION);
    }

    public static class_1799 asStack(RegistryObject<?> item) {
        class_1935 itemLike;
        Object object = item.get();
        return Restrictions.asStack(object instanceof class_1935 ? (itemLike = (class_1935)object) : (class_1935)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE.get());
    }

    public static class_1799 asStack(class_1935 itemLike) {
        return new class_1799(itemLike);
    }

    public static Optional<Restriction> getRestrictionForBiome(class_1959 biome, class_1297 entity) {
        if (entity instanceof class_1657) {
            Restriction restrictions;
            class_1657 player = (class_1657)entity;
            class_5455 access = entity.method_37908().method_30349();
            class_2960 biomeLocation = access.method_30530(class_7924.field_41236).method_10221((Object)biome);
            if (biomeLocation != null && (restrictions = (Restriction)access.method_30530(RESTRICTION_KEY).method_10223(biomeLocation)) != null && !PlayerHelper.doesPlayerHaveRequiredAdvancements(player, restrictions.advancements())) {
                return Optional.of(restrictions);
            }
        }
        return Optional.empty();
    }

    public static boolean isBiomeSafeFor(class_1959 biome, class_1297 entity) {
        return Restrictions.getRestrictionForBiome(biome, entity).isEmpty();
    }

    public static void registerRestrictions() {
        RESTRICTIONS.register(DARK_FOREST.method_29177(), () -> DARK_FOREST_RESTRICTION);
        RESTRICTIONS.register(DARK_FOREST_CENTER.method_29177(), () -> DARK_FOREST_CENTER_RESTRICTION);
        RESTRICTIONS.register(FINAL_PLATEAU.method_29177(), () -> FINAL_PLATEAU_RESTRICTION);
        RESTRICTIONS.register(FIRE_SWAMP.method_29177(), () -> FIRE_SWAMP_RESTRICTION);
        RESTRICTIONS.register(GLACIER.method_29177(), () -> GLACIER_RESTRICTION);
        RESTRICTIONS.register(HIGHLANDS.method_29177(), () -> HIGHLANDS_RESTRICTION);
        RESTRICTIONS.register(SNOWY_FOREST.method_29177(), () -> SNOWY_FOREST_RESTRICTION);
        RESTRICTIONS.register(SWAMP.method_29177(), () -> SWAMP_RESTRICTION);
        RESTRICTIONS.register(THORNLANDS.method_29177(), () -> THORNLANDS_RESTRICTION);
    }
}

