/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import io.github.fabricators_of_create.porting_lib.util.LazyRegistrar;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import twilightforest.TwilightForestMod;
import twilightforest.data.AtlasGenerator;
import twilightforest.data.LangGenerator;
import twilightforest.util.MagicPaintingVariant;

public class MagicPaintingVariants {
    public static final class_5321<class_2378<MagicPaintingVariant>> REGISTRY_KEY = class_5321.method_29180((class_2960)TwilightForestMod.namedRegistry("magic_paintings"));
    public static final LazyRegistrar<MagicPaintingVariant> MAGIC_PAINTINGS = LazyRegistrar.create(REGISTRY_KEY, (String)"twilightforest");
    public static final Codec<class_6880<MagicPaintingVariant>> CODEC = class_5381.method_31192(REGISTRY_KEY, MagicPaintingVariant.CODEC, (boolean)false);
    public static final class_5321<MagicPaintingVariant> DARKNESS = MagicPaintingVariants.makeKey(TwilightForestMod.prefix("darkness"));
    public static final MagicPaintingVariant DARKNESS_PAINTING = new MagicPaintingVariant(64, 32, List.of(new MagicPaintingVariant.Layer("background", null, null, true), new MagicPaintingVariant.Layer("sky", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.01f, 128, 32), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.SINE_TIME, 0.03f, false), true), new MagicPaintingVariant.Layer("terrain", null, null, false), new MagicPaintingVariant.Layer("gems", null, null, true), new MagicPaintingVariant.Layer("gems", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.DAY_TIME, 2.0f, true), true), new MagicPaintingVariant.Layer("lightning", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.LIGHTNING, 1.0f, false), true)));
    public static final MagicPaintingVariant LUCID_LANDS_PAINTING = new MagicPaintingVariant(32, 32, List.of(new MagicPaintingVariant.Layer("background", null, null, true), new MagicPaintingVariant.Layer("clouds", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.SINE_TIME, 0.01f, 48, 32), null, true), new MagicPaintingVariant.Layer("volcanic_lands", null, null, true), new MagicPaintingVariant.Layer("agate_jungle", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.02f, 44, 32), null, true), new MagicPaintingVariant.Layer("crystal_plains", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.025f, 58, 32), null, true)));
    public static final class_5321<MagicPaintingVariant> LUCID_LANDS = MagicPaintingVariants.makeKey(TwilightForestMod.prefix("lucid_lands"));

    private static class_5321<MagicPaintingVariant> makeKey(class_2960 name) {
        return class_5321.method_29179(REGISTRY_KEY, (class_2960)name);
    }

    public static void bootstrap(class_7891<MagicPaintingVariant> context) {
        MagicPaintingVariants.register(context, DARKNESS, "Darkness", "???", DARKNESS_PAINTING);
        MagicPaintingVariants.register(context, LUCID_LANDS, "Lucid Lands", "Androsa", LUCID_LANDS_PAINTING);
    }

    public static void register(class_7891<MagicPaintingVariant> context, class_5321<MagicPaintingVariant> key, String title, String author, MagicPaintingVariant variant) {
        AtlasGenerator.MAGIC_PAINTING_HELPER.put(key.method_29177(), variant);
        LangGenerator.MAGIC_PAINTING_HELPER.put(key.method_29177(), (Pair<String, String>)Pair.of((Object)title, (Object)author));
        context.method_46838(key, (Object)variant);
    }

    public static Optional<MagicPaintingVariant> getVariant(class_5455 regAccess, String id) {
        return MagicPaintingVariants.getVariant(regAccess, new class_2960(id));
    }

    public static Optional<MagicPaintingVariant> getVariant(class_5455 regAccess, class_2960 id) {
        return regAccess.method_33310(REGISTRY_KEY).map(reg -> (MagicPaintingVariant)reg.method_10223(id));
    }

    public static String getVariantId(class_5455 regAccess, MagicPaintingVariant variant) {
        return MagicPaintingVariants.getVariantResourceLocation(regAccess, variant).toString();
    }

    public static class_2960 getVariantResourceLocation(class_5455 regAccess, MagicPaintingVariant variant) {
        return regAccess.method_33310(REGISTRY_KEY).map(reg -> reg.method_10221((Object)variant)).orElse(new class_2960("null"));
    }

    public static void registerMagicPaintings() {
        MAGIC_PAINTINGS.register(DARKNESS.method_29177(), () -> DARKNESS_PAINTING);
        MAGIC_PAINTINGS.register(LUCID_LANDS.method_29177(), () -> LUCID_LANDS_PAINTING);
    }
}

