/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import io.github.fabricators_of_create.porting_lib.util.LazyRegistrar;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBiomes;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.world.components.layer.BorderLayer;
import twilightforest.world.components.layer.CompanionBiomesLayer;
import twilightforest.world.components.layer.FilteredBiomeLayer;
import twilightforest.world.components.layer.KeyBiomesLayer;
import twilightforest.world.components.layer.RandomBiomeLayer;
import twilightforest.world.components.layer.SeamLayer;
import twilightforest.world.components.layer.StabilizeLayer;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerType;
import twilightforest.world.components.layer.vanillalegacy.SmoothLayer;
import twilightforest.world.components.layer.vanillalegacy.ZoomLayer;

public class BiomeLayerStack {
    public static final class_5321<class_2378<BiomeLayerFactory>> BIOME_STACK_KEY = class_5321.method_29180((class_2960)TwilightForestMod.namedRegistry("biome_layer_stack"));
    public static final LazyRegistrar<BiomeLayerFactory> BIOME_LAYER_STACKS = LazyRegistrar.create(BIOME_STACK_KEY, (String)"twilightforest");
    public static final Codec<BiomeLayerFactory> DISPATCH_CODEC = BiomeLayerTypes.CODEC.dispatch("layer_type", BiomeLayerFactory::getType, BiomeLayerType::getCodec);
    public static final Codec<class_6880<BiomeLayerFactory>> HOLDER_CODEC = class_5381.method_31192(BIOME_STACK_KEY, DISPATCH_CODEC, (boolean)true);
    public static final class_5321<BiomeLayerFactory> RANDOM_FOREST_BIOMES = BiomeLayerStack.registerKey("random_forest_biomes");
    public static final class_5321<BiomeLayerFactory> BIOMES_ALONG_STREAMS = BiomeLayerStack.registerKey("biomes_along_streams");
    @Deprecated
    private static class_6880<BiomeLayerFactory> allBiomesHolder;

    public static class_6880<BiomeLayerFactory> getAllBiomesHolder() {
        if (allBiomesHolder == null) {
            allBiomesHolder = BiomeLayerStack.buildDefault();
        }
        return allBiomesHolder;
    }

    public static class_5321<BiomeLayerFactory> registerKey(String name) {
        return class_5321.method_29179(BIOME_STACK_KEY, (class_2960)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(class_7891<BiomeLayerFactory> context) {
        FilteredBiomeLayer.Factory biomeLayerFactory = (FilteredBiomeLayer.Factory)BiomeLayerStack.getAllBiomesHolder().comp_349();
        context.method_46838(RANDOM_FOREST_BIOMES, (Object)((BiomeLayerFactory)biomeLayerFactory.fallbackLayer().comp_349()));
        context.method_46838(BIOMES_ALONG_STREAMS, (Object)biomeLayerFactory);
    }

    public static class_6880<BiomeLayerFactory> buildDefault() {
        BiomeLayerFactory biomes = new RandomBiomeLayer.Factory(1L, 15, (List<class_5321<class_1959>>)ImmutableList.of(TFBiomes.FOREST, TFBiomes.DENSE_FOREST, TFBiomes.MUSHROOM_FOREST, TFBiomes.OAK_SAVANNAH, TFBiomes.FIREFLY_FOREST), (List<class_5321<class_1959>>)ImmutableList.of(TFBiomes.LAKE, TFBiomes.DENSE_MUSHROOM_FOREST, TFBiomes.ENCHANTED_FOREST, TFBiomes.CLEARING, TFBiomes.SPOOKY_FOREST));
        biomes = new KeyBiomesLayer.Factory(1000L, List.of(TFBiomes.GLACIER, TFBiomes.FIRE_SWAMP, TFBiomes.DARK_FOREST_CENTER, TFBiomes.FINAL_PLATEAU), (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        biomes = new CompanionBiomesLayer.Factory(1000L, List.of(Pair.of(TFBiomes.FIRE_SWAMP, TFBiomes.SWAMP), Pair.of(TFBiomes.GLACIER, TFBiomes.SNOWY_FOREST), Pair.of(TFBiomes.DARK_FOREST_CENTER, TFBiomes.DARK_FOREST), Pair.of(TFBiomes.FINAL_PLATEAU, TFBiomes.HIGHLANDS)), (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        biomes = new ZoomLayer.Factory(1000L, false, (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        biomes = new ZoomLayer.Factory(1001L, false, (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        biomes = new StabilizeLayer.Factory(700L, (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        biomes = new BorderLayer.Factory(500L, TFBiomes.FINAL_PLATEAU, TFBiomes.THORNLANDS, (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        biomes = new ZoomLayer.Factory(1002L, false, (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        biomes = new ZoomLayer.Factory(1003L, false, (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        biomes = new ZoomLayer.Factory(1004L, false, (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        biomes = new ZoomLayer.Factory(1005L, false, (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        BiomeLayerFactory riverLayer = new SeamLayer.Factory(1L, TFBiomes.STREAM, List.of(TFBiomes.LAKE, TFBiomes.THORNLANDS, TFBiomes.CLEARING, TFBiomes.OAK_SAVANNAH), List.of(Pair.of(TFBiomes.SNOWY_FOREST, TFBiomes.GLACIER), Pair.of(TFBiomes.MUSHROOM_FOREST, TFBiomes.DENSE_MUSHROOM_FOREST), Pair.of(TFBiomes.SWAMP, TFBiomes.FIRE_SWAMP), Pair.of(TFBiomes.DARK_FOREST, TFBiomes.DARK_FOREST_CENTER), Pair.of(TFBiomes.HIGHLANDS, TFBiomes.FINAL_PLATEAU)), (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes));
        riverLayer = new SmoothLayer.Factory(7000L, (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)riverLayer));
        return class_6880.method_40223((Object)new FilteredBiomeLayer.Factory(100L, TFBiomes.STREAM, (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)riverLayer), (class_6880<BiomeLayerFactory>)class_6880.method_40223((Object)biomes)));
    }

    public static void registerBiomeLayerStacks() {
        FilteredBiomeLayer.Factory biomeLayerFactory = (FilteredBiomeLayer.Factory)BiomeLayerStack.getAllBiomesHolder().comp_349();
        BIOME_LAYER_STACKS.register(RANDOM_FOREST_BIOMES.method_29177(), () -> (BiomeLayerFactory)biomeLayerFactory.fallbackLayer().comp_349());
        BIOME_LAYER_STACKS.register(BIOMES_ALONG_STREAMS.method_29177(), () -> biomeLayerFactory);
    }
}

