/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_52;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import twilightforest.TFConfig;
import twilightforest.init.TFSounds;

public interface IBossLootBuffer {
    public static final int CONTAINER_SIZE = 27;

    default public class_1799 getItem(int slot) {
        return (class_1799)this.getItemStacks().get(slot);
    }

    default public void setItem(int slot, class_1799 stack) {
        this.getItemStacks().set(slot, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > 64) {
            stack.method_7939(64);
        }
    }

    default public void addDeathItemsSaveData(class_2487 tag) {
        class_1262.method_5426((class_2487)tag, this.getItemStacks());
    }

    default public void readDeathItemsSaveData(class_2487 tag) {
        class_1262.method_5429((class_2487)tag, this.getItemStacks());
    }

    public static <T extends class_1309> void saveDropsIntoBoss(T boss, class_8567 params, class_3218 serverLevel) {
        if (((Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get()).booleanValue()) {
            class_52 table = serverLevel.method_8503().method_3857().getLootTable(boss.method_5989());
            ObjectArrayList stacks = table.method_51878(params);
            ((IBossLootBuffer)boss).fill(boss, params, table);
            if (stacks.size() > 27) {
                for (class_1799 stack : stacks.subList(28, stacks.size())) {
                    class_1542 item = new class_1542((class_1937)serverLevel, boss.method_23317(), boss.method_23318(), boss.method_23321(), stack);
                    item.method_6976();
                    item.method_6975();
                    serverLevel.method_8649((class_1297)item);
                }
            }
        }
    }

    public static <T extends class_1309> void depositDropsIntoChest(T boss, class_2680 chest, class_2338 pos, class_3218 serverLevel) {
        class_2586 class_25862;
        if (((Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get()).booleanValue() && (serverLevel.method_8652(pos, chest, 2) || serverLevel.method_8320(pos).method_27852(chest.method_26204())) && (class_25862 = serverLevel.method_8321(pos)) instanceof class_1263) {
            class_1263 container = (class_1263)class_25862;
            for (int i = 0; i < 27 && i < container.method_5439(); ++i) {
                container.method_5447(i, ((IBossLootBuffer)boss).getItem(i));
            }
            class_243 vec3 = class_243.method_24953((class_2382)pos);
            serverLevel.method_43128(null, vec3.field_1352, vec3.field_1351, vec3.field_1350, (class_3414)TFSounds.BOSS_CHEST_APPEAR.get(), boss.method_5634(), 128.0f, (boss.method_6051().method_43057() - boss.method_6051().method_43057()) * 0.175f + 0.5f);
        }
    }

    default public <T extends class_1309> void fill(T boss, class_8567 context, class_52 table) {
        ObjectArrayList items = table.method_51878(context);
        class_5819 randomsource = boss.method_6051();
        List<Integer> list = this.getAvailableSlots(randomsource);
        table.method_333(items, list.size(), randomsource);
        for (class_1799 itemstack : items) {
            if (list.isEmpty()) {
                return;
            }
            if (itemstack.method_7960()) {
                this.setItem(list.remove(list.size() - 1), class_1799.field_8037);
                continue;
            }
            this.setItem(list.remove(list.size() - 1), itemstack);
        }
    }

    default public List<Integer> getAvailableSlots(class_5819 random) {
        ObjectArrayList arrayList = new ObjectArrayList();
        for (int i = 0; i < 27; ++i) {
            arrayList.add((Object)i);
        }
        class_156.method_43028((ObjectArrayList)arrayList, (class_5819)random);
        return arrayList;
    }

    public class_2371<class_1799> getItemStacks();
}

