/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.projectile.LichBolt;
import twilightforest.entity.projectile.LichBomb;
import twilightforest.init.TFItems;

public class LichShadowsGoal
extends class_1352 {
    private final Lich lich;

    public LichShadowsGoal(Lich boss) {
        this.lich = boss;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        return this.lich.getPhase() == 1;
    }

    public void method_6269() {
        this.lich.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.TWILIGHT_SCEPTER.get()));
    }

    public void method_6270() {
        this.despawnClones();
    }

    public void method_6268() {
        class_1309 targetedEntity;
        if (this.lich.isShadowClone()) {
            this.checkForMaster();
        }
        if ((targetedEntity = this.lich.method_5968()) == null) {
            return;
        }
        float dist = this.lich.method_5739((class_1297)targetedEntity);
        if (this.lich.getAttackCooldown() == 60) {
            this.lich.teleportToSightOfEntity((class_1297)targetedEntity);
            if (!this.lich.isShadowClone()) {
                this.checkAndSpawnClones();
            }
        }
        if (this.lich.method_5985().method_6369((class_1297)targetedEntity) && this.lich.getAttackCooldown() == 0 && dist < 20.0f) {
            if (this.lich.getNextAttackType() == 0) {
                this.lich.launchProjectileAt(new LichBolt(this.lich.method_37908(), (class_1309)this.lich));
            } else {
                this.lich.launchProjectileAt(new LichBomb(this.lich.method_37908(), (class_1309)this.lich));
            }
            this.lich.method_6104(class_1268.field_5808);
            if (this.lich.method_6051().method_43048(3) > 0) {
                this.lich.setNextAttackType(0);
            } else {
                this.lich.setNextAttackType(1);
            }
            this.lich.setAttackCooldown(100);
        }
    }

    private void checkForMaster() {
        if (this.lich.getMasterLich() == null) {
            this.findNewMaster();
        }
        if (!(this.lich.method_37908().method_8608() || this.lich.getMasterLich() != null && this.lich.getMasterLich().method_5805() && this.lich.getMasterLich().getPhase() == 1)) {
            this.lich.method_31472();
        }
    }

    private void checkAndSpawnClones() {
        if (this.lich.countMyClones() < 2) {
            this.spawnShadowClone();
        }
    }

    private void spawnShadowClone() {
        class_1309 targetedEntity = this.lich.method_5968();
        class_243 cloneSpot = this.lich.findVecInLOSOf((class_1297)targetedEntity);
        if (cloneSpot != null) {
            Lich newClone = new Lich(this.lich.method_37908(), this.lich);
            newClone.method_5814(cloneSpot.method_10216(), cloneSpot.method_10214(), cloneSpot.method_10215());
            this.lich.method_37908().method_8649((class_1297)newClone);
            newClone.method_5980(targetedEntity);
            newClone.setAttackCooldown(60 + this.lich.method_6051().method_43048(3) - this.lich.method_6051().method_43048(3));
            this.lich.makeTeleportTrail(this.lich.method_23317(), this.lich.method_23318(), this.lich.method_23321(), cloneSpot.method_10216(), cloneSpot.method_10214(), cloneSpot.method_10215());
        }
    }

    private void despawnClones() {
        for (Lich lich : this.lich.getNearbyLiches()) {
            if (!lich.isShadowClone()) continue;
            lich.method_5650(class_1297.class_5529.field_26999);
        }
    }

    private void findNewMaster() {
        for (Lich lich : this.lich.getNearbyLiches()) {
            if (lich.isShadowClone() || !lich.wantsNewClone(this.lich)) continue;
            this.lich.setMaster(lich);
            this.lich.makeTeleportTrail(this.lich.method_23317(), this.lich.method_23318(), this.lich.method_23321(), lich.method_23317(), lich.method_23318(), lich.method_23321());
            this.lich.method_5980(lich.method_5968());
            break;
        }
    }
}

