/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.IBreathAttacker;

public class BreathAttackGoal<T extends class_1308>
extends class_1352 {
    private final T entityHost;
    private class_1309 attackTarget;
    private class_243 breathPos;
    private final int maxDuration;
    private final float attackChance;
    private final float breathRange;
    private int durationLeft;

    public BreathAttackGoal(T living, float range, int time, float chance) {
        this.entityHost = living;
        this.breathRange = range;
        this.maxDuration = time;
        this.attackChance = chance;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        this.attackTarget = this.entityHost.method_6065();
        if (this.attackTarget == null || this.entityHost.method_5739((class_1297)this.attackTarget) > this.breathRange || !this.entityHost.method_5985().method_6369((class_1297)this.attackTarget) || !class_1301.field_6156.and(class_1301.field_6157).test(this.attackTarget)) {
            return false;
        }
        this.breathPos = this.attackTarget.method_33571();
        return this.entityHost.method_6051().method_43057() < this.attackChance;
    }

    public void method_6269() {
        this.durationLeft = this.maxDuration;
        ((IBreathAttacker)this.entityHost).setBreathing(true);
    }

    public boolean method_6266() {
        return this.durationLeft > 0 && this.entityHost.method_5805() && this.attackTarget.method_5805() && this.entityHost.method_5739((class_1297)this.attackTarget) <= this.breathRange && this.entityHost.method_5985().method_6369((class_1297)this.attackTarget) && class_1301.field_6156.and(class_1301.field_6157).test(this.attackTarget);
    }

    public void method_6268() {
        class_1297 target;
        --this.durationLeft;
        this.entityHost.method_5988().method_19615(this.breathPos);
        this.faceVec(this.breathPos, 100.0f, 100.0f);
        if (this.maxDuration - this.durationLeft > 5 && (target = this.getHeadLookTarget()) != null) {
            ((IBreathAttacker)this.entityHost).doBreathAttack(target);
            this.entityHost.method_32876(class_5712.field_28161);
        }
    }

    public void method_6270() {
        this.durationLeft = 0;
        this.attackTarget = null;
        ((IBreathAttacker)this.entityHost).setBreathing(false);
    }

    @Nullable
    private class_1297 getHeadLookTarget() {
        MultiPartEntity partEntity;
        class_1297 pointedEntity = null;
        double range = 30.0;
        double offset = 3.0;
        class_243 srcVec = new class_243(this.entityHost.method_23317(), this.entityHost.method_23318() + 0.25, this.entityHost.method_23321());
        class_243 lookVec = this.entityHost.method_5828(1.0f);
        class_243 destVec = srcVec.method_1031(lookVec.method_10216() * range, lookVec.method_10214() * range, lookVec.method_10215() * range);
        float var9 = 0.5f;
        List possibleList = this.entityHost.method_37908().method_8335(this.entityHost, this.entityHost.method_5829().method_989(lookVec.method_10216() * offset, lookVec.method_10214() * offset, lookVec.method_10215() * offset).method_1009((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        T t = this.entityHost;
        if (t instanceof MultiPartEntity && (partEntity = (MultiPartEntity)t).isMultipartEntity()) {
            possibleList.removeAll(Arrays.asList(Objects.requireNonNull(partEntity.getParts())));
        }
        for (class_1297 possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.method_5863() || possibleEntity == this.entityHost || !class_1301.field_6156.and(class_1301.field_6157).test(possibleEntity)) continue;
            float borderSize = possibleEntity.method_5871();
            class_238 collisionBB = possibleEntity.method_5829().method_1009((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.method_992(srcVec, destVec);
            if (collisionBB.method_1006(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.method_1022((class_243)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void faceVec(class_243 pos, float yawConstraint, float pitchConstraint) {
        double xOffset = pos.method_10216() - this.entityHost.method_23317();
        double zOffset = pos.method_10215() - this.entityHost.method_23321();
        double yOffset = this.entityHost.method_23318() + 0.25 - pos.method_10214();
        double distance = class_3532.method_15355((float)((float)(xOffset * xOffset + zOffset * zOffset)));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        this.entityHost.method_36457(-this.updateRotation(this.entityHost.method_36455(), zdAngle, pitchConstraint));
        this.entityHost.method_36456(this.updateRotation(this.entityHost.method_36454(), xyAngle, yawConstraint));
    }

    private float updateRotation(float current, float target, float maxDelta) {
        float delta = class_3532.method_15393((float)(target - current));
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (delta < -maxDelta) {
            delta = -maxDelta;
        }
        return current + delta;
    }
}

