/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.data.custom.stalactites.entry.StalactiteReloadListener;

public abstract class StalactiteProvider
implements class_2405 {
    private final class_7784 generator;
    private final String modid;
    private final class_7784.class_7489 entryPath;
    protected final Map<Pair<class_2960, Stalactite>, Stalactite.HollowHillType> builder = Maps.newLinkedHashMap();

    public StalactiteProvider(class_7784 generator, String modid) {
        this.generator = generator;
        this.modid = modid;
        this.entryPath = generator.method_45973(class_7784.class_7490.field_39367, "stalactites/entries");
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        HashMap map = Maps.newHashMap();
        HashMap smallHillEntries = Maps.newHashMap();
        HashMap medHillEntries = Maps.newHashMap();
        HashMap largeHillEntries = Maps.newHashMap();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.builder.clear();
        this.createStalactites();
        this.builder.forEach((stalactiteMap, type) -> {
            if (type == Stalactite.HollowHillType.LARGE) {
                largeHillEntries.put((class_2960)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            } else if (type == Stalactite.HollowHillType.MEDIUM) {
                medHillEntries.put((class_2960)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            } else {
                smallHillEntries.put((class_2960)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            }
            map.put((class_2960)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
        });
        map.forEach((resourceLocation, stalactite) -> {
            Path path = this.entryPath.method_44107(resourceLocation);
            futuresBuilder.add((Object)class_2405.method_10320((class_7403)output, (JsonElement)StalactiteReloadListener.serialize(stalactite), (Path)path));
        });
        Gson hillGson = new GsonBuilder().setPrettyPrinting().create();
        for (Stalactite.HollowHillType type2 : Stalactite.HollowHillType.values()) {
            Path hillPath = this.generator.method_45971().resolve("data/twilightforest/stalactites/" + type2.name().toLowerCase(Locale.ROOT) + "_hollow_hill.json");
            HashMap mapToUse = type2 == Stalactite.HollowHillType.LARGE ? largeHillEntries : (type2 == Stalactite.HollowHillType.MEDIUM ? medHillEntries : smallHillEntries);
            JsonObject object = new JsonObject();
            object.addProperty("replace", Boolean.valueOf(false));
            object.add("stalactites", hillGson.toJsonTree(mapToUse.keySet().stream().map(class_2960::toString).sorted().collect(Collectors.toList())));
            futuresBuilder.add((Object)class_2405.method_10320((class_7403)output, (JsonElement)object, (Path)hillPath));
        }
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    protected abstract void createStalactites();

    protected void makeStalactite(Stalactite stalactite, Stalactite.HollowHillType type) {
        StringJoiner nameBuilder = new StringJoiner("_", "", "_stalactite");
        for (class_2960 entry : stalactite.ores().keySet().stream().map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).sorted().toList()) {
            nameBuilder.add(entry.method_12832());
        }
        this.builder.putIfAbsent((Pair<class_2960, Stalactite>)Pair.of((Object)new class_2960(this.modid, nameBuilder.toString()), (Object)stalactite), type);
    }

    public String method_10321() {
        return this.modid + " Hollow Hill Stalactites";
    }
}

