/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFRecipes;

public class UncraftingRecipeBuilder
implements class_5797 {
    private final class_1856 input;
    private final int count;
    private int cost = -1;
    private final List<String> pattern = new ArrayList<String>();
    private final Map<Character, class_1856> outputs = new HashMap<Character, class_1856>();

    public UncraftingRecipeBuilder(class_1856 input, int count) {
        this.input = input;
        this.count = count;
    }

    public static UncraftingRecipeBuilder uncrafting(class_1935 input) {
        return UncraftingRecipeBuilder.uncrafting(class_1856.method_8091((class_1935[])new class_1935[]{input}), 1);
    }

    public static UncraftingRecipeBuilder uncrafting(class_6862<class_1792> input) {
        return UncraftingRecipeBuilder.uncrafting(class_1856.method_8106(input), 1);
    }

    public static UncraftingRecipeBuilder uncrafting(class_1935 input, int count) {
        return UncraftingRecipeBuilder.uncrafting(class_1856.method_8091((class_1935[])new class_1935[]{input}), count);
    }

    public static UncraftingRecipeBuilder uncrafting(class_6862<class_1792> input, int count) {
        return UncraftingRecipeBuilder.uncrafting(class_1856.method_8106(input), count);
    }

    public static UncraftingRecipeBuilder uncrafting(class_1856 input, int count) {
        return new UncraftingRecipeBuilder(input, count);
    }

    public UncraftingRecipeBuilder define(Character pSymbol, class_6862<class_1792> pTag) {
        return this.define(pSymbol, class_1856.method_8106(pTag));
    }

    public UncraftingRecipeBuilder define(Character pSymbol, class_1935 pItem) {
        return this.define(pSymbol, class_1856.method_8091((class_1935[])new class_1935[]{pItem}));
    }

    public UncraftingRecipeBuilder setCost(int cost) {
        this.cost = cost;
        return this;
    }

    public UncraftingRecipeBuilder define(Character pSymbol, class_1856 pIngredient) {
        if (this.outputs.containsKey(pSymbol)) {
            throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
        }
        if (pSymbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.outputs.put(pSymbol, pIngredient);
        return this;
    }

    public UncraftingRecipeBuilder pattern(String pattern) {
        if (!this.pattern.isEmpty() && pattern.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(pattern);
        return this;
    }

    public class_5797 method_33530(String pCriterionName, class_184 pCriterionTrigger) {
        return this;
    }

    public class_5797 method_33529(@Nullable String group) {
        return this;
    }

    public class_1792 method_36441() {
        return this.input.method_8105()[0].method_7909();
    }

    public void method_17972(Consumer<class_2444> consumer, class_2960 id) {
        this.ensureValid(id);
        consumer.accept(new Result(id, this.input, this.count, this.cost, this.pattern, this.outputs));
    }

    public void method_10431(Consumer<class_2444> consumer) {
        this.method_17972(consumer, new class_2960("twilightforest", "uncrafting/" + this.getDefaultRecipeId((class_1935)this.method_36441()).method_12832()));
    }

    private void ensureValid(class_2960 id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.outputs.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.outputs.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
    }

    private class_2960 getDefaultRecipeId(class_1935 item) {
        return class_7923.field_41178.method_10221((Object)item.method_8389());
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final class_1856 input;
        private final int count;
        private final int cost;
        private final List<String> pattern;
        private final Map<Character, class_1856> outputs;

        public Result(class_2960 id, class_1856 input, int count, int cost, List<String> pattern, Map<Character, class_1856> outputs) {
            this.id = id;
            this.input = input;
            this.count = count;
            this.cost = cost;
            this.pattern = pattern;
            this.outputs = outputs;
        }

        public void method_10416(JsonObject object) {
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            object.add("pattern", (JsonElement)jsonarray);
            JsonObject keys = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.outputs.entrySet()) {
                keys.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            object.add("key", (JsonElement)keys);
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("ingredient", this.input.method_8089());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            object.add("input", (JsonElement)jsonObject);
            if (this.cost > -1) {
                object.addProperty("cost", (Number)this.cost);
            }
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return (class_1865)TFRecipes.UNCRAFTING_SERIALIZER.get();
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

