/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_7924;
import twilightforest.TwilightForestMod;
import twilightforest.command.TFCommand;
import twilightforest.init.TFBiomes;
import twilightforest.item.MagicMapItem;
import twilightforest.util.ColorUtil;
import twilightforest.world.registration.TFGenerationSettings;

public class MapBiomesCommand {
    private static final DecimalFormat numberFormat = new DecimalFormat("#.00");
    private static final HashMap<class_2960, BiomeMapColor> BIOME2COLOR = new HashMap();

    private static void init() {
        BIOME2COLOR.put(TFBiomes.STREAM.method_29177(), new BiomeMapColor(0, 0, 255));
        BIOME2COLOR.put(TFBiomes.LAKE.method_29177(), new BiomeMapColor(0, 0, 255));
        BIOME2COLOR.put(TFBiomes.CLEARING.method_29177(), new BiomeMapColor(132, 245, 130));
        BIOME2COLOR.put(TFBiomes.OAK_SAVANNAH.method_29177(), new BiomeMapColor(239, 245, 130));
        BIOME2COLOR.put(TFBiomes.FOREST.method_29177(), new BiomeMapColor(0, 255, 0));
        BIOME2COLOR.put(TFBiomes.DENSE_FOREST.method_29177(), new BiomeMapColor(0, 170, 0));
        BIOME2COLOR.put(TFBiomes.FIREFLY_FOREST.method_29177(), new BiomeMapColor(88, 252, 102));
        BIOME2COLOR.put(TFBiomes.ENCHANTED_FOREST.method_29177(), new BiomeMapColor(0, 255, 255));
        BIOME2COLOR.put(TFBiomes.SPOOKY_FOREST.method_29177(), new BiomeMapColor(119, 0, 255));
        BIOME2COLOR.put(TFBiomes.MUSHROOM_FOREST.method_29177(), new BiomeMapColor(204, 0, 139));
        BIOME2COLOR.put(TFBiomes.DENSE_MUSHROOM_FOREST.method_29177(), new BiomeMapColor(184, 48, 184));
        BIOME2COLOR.put(TFBiomes.SWAMP.method_29177(), new BiomeMapColor(0, 204, 187));
        BIOME2COLOR.put(TFBiomes.FIRE_SWAMP.method_29177(), new BiomeMapColor(140, 0, 0));
        BIOME2COLOR.put(TFBiomes.DARK_FOREST.method_29177(), new BiomeMapColor(25, 61, 13));
        BIOME2COLOR.put(TFBiomes.DARK_FOREST_CENTER.method_29177(), new BiomeMapColor(157, 79, 0));
        BIOME2COLOR.put(TFBiomes.SNOWY_FOREST.method_29177(), new BiomeMapColor(255, 255, 255));
        BIOME2COLOR.put(TFBiomes.GLACIER.method_29177(), new BiomeMapColor(130, 191, 245));
        BIOME2COLOR.put(TFBiomes.HIGHLANDS.method_29177(), new BiomeMapColor(100, 65, 0));
        BIOME2COLOR.put(TFBiomes.THORNLANDS.method_29177(), new BiomeMapColor(128, 100, 90));
        BIOME2COLOR.put(TFBiomes.FINAL_PLATEAU.method_29177(), new BiomeMapColor(128, 128, 128));
    }

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"biomepng").requires(cs -> cs.method_9259(2))).executes(context -> MapBiomesCommand.createMap((class_2168)context.getSource(), 4096, 4096, true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"width", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> MapBiomesCommand.createMap((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> MapBiomesCommand.createMap((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"height"), true))).then(class_2170.method_9244((String)"showBiomePercents", (ArgumentType)BoolArgumentType.bool()).executes(context -> MapBiomesCommand.createMap((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"height"), BoolArgumentType.getBool((CommandContext)context, (String)"showBiomePercents"))))));
    }

    private static int createMap(class_2168 source, int width, int height, boolean showBiomePercents) throws CommandSyntaxException {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return -1;
        }
        if (!TFGenerationSettings.usesTwilightChunkGenerator(source.method_9225())) {
            throw TFCommand.NOT_IN_TF.create();
        }
        if (BIOME2COLOR.isEmpty()) {
            MapBiomesCommand.init();
        }
        HashMap<class_1959, Integer> biomeCount = new HashMap<class_1959, Integer>();
        class_1011 img = new class_1011(width, height, false);
        int progressUpdate = img.method_4323() / 8;
        for (int x = 0; x < img.method_4323(); ++x) {
            for (int z = 0; z < img.method_4307(); ++z) {
                class_3218 level = source.method_9225();
                class_1959 b = (class_1959)level.method_16359(x - img.method_4307() / 2, 0, z - img.method_4323() / 2).comp_349();
                class_2960 key = level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)b);
                BiomeMapColor color = BIOME2COLOR.get(key);
                if (color == null) {
                    int colorInt = MagicMapItem.getBiomeColor((class_1937)source.method_9225(), b);
                    if (colorInt == 0) {
                        colorInt = b.method_8711(0.0, 0.0);
                    }
                    color = new BiomeMapColor(colorInt | 0xFF000000);
                    BIOME2COLOR.put(key, color);
                }
                if (!biomeCount.containsKey(b)) {
                    biomeCount.put(b, 0);
                } else {
                    biomeCount.put(b, (Integer)biomeCount.get(b) + 1);
                }
                img.method_4305(x, z, ColorUtil.argbToABGR(color.getARGB()));
            }
            if (x % progressUpdate != 0) continue;
            int finalX = x;
            source.method_9226(() -> class_2561.method_43471((String)((double)finalX / (double)img.method_4323() * 100.0 + "% Done mapping")), false);
        }
        if (showBiomePercents) {
            source.method_9226(() -> class_2561.method_43470((String)("Approximate biome-block counts within a " + width + "x" + height + " region")), false);
            int totalCount = biomeCount.values().stream().mapToInt(i -> i).sum();
            biomeCount.forEach((biome, integer) -> source.method_9226(() -> class_2561.method_43470((String)source.method_9225().method_30349().method_30530(class_7924.field_41236).method_10221(biome).toString()).method_27693(": " + integer + class_124.field_1080 + " (" + numberFormat.format((double)integer.intValue() / (double)totalCount * 100.0) + "%)"), false));
        }
        int startX = class_3532.method_15357((double)source.method_9222().method_10216()) - img.method_4307() / 2;
        int startZ = class_3532.method_15357((double)source.method_9222().method_10215()) - img.method_4323() / 2;
        Path p = Paths.get("biome_map-" + source.method_9225().method_8412() + "-(" + startX + "." + startZ + ")-(" + (startX + width) + "." + (startZ + height) + ").png", new String[0]);
        try {
            img.method_4325(p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            TwilightForestMod.LOGGER.error((Object)e);
            source.method_9213((class_2561)class_2561.method_43470((String)"Could not save image! Please report this!"));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"Image saved!"), false);
        return 1;
    }

    public static class BiomeMapColor {
        private final int value;

        public BiomeMapColor(int r, int g, int b) {
            this(r, g, b, 255);
        }

        public BiomeMapColor(int r, int g, int b, int a) {
            this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }

        public BiomeMapColor(int rgb) {
            this.value = 0xFF000000 | rgb;
        }

        public int getARGB() {
            return this.value;
        }
    }
}

