/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fabricators_of_create.porting_lib.event.client.CameraSetupCallback;
import io.github.fabricators_of_create.porting_lib.event.client.FieldOfViewEvents;
import io.github.fabricators_of_create.porting_lib.event.client.LivingEntityRenderEvents;
import io.github.fabricators_of_create.porting_lib.event.client.MinecraftTailCallback;
import io.github.fabricators_of_create.porting_lib.event.client.RenderTickStartCallback;
import io.github.fabricators_of_create.porting_lib.models.geometry.RegisterGeometryLoadersCallback;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1091;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1843;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2806;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_3882;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5294;
import net.minecraft.class_5455;
import net.minecraft.class_5498;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.class_897;
import net.minecraft.class_922;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.entity.GrowingBeanstalkBlockEntity;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.EffectRenders;
import twilightforest.client.TFShaders;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.model.SeparateTransformsModel;
import twilightforest.client.model.TFItemLayerModel;
import twilightforest.client.model.block.doors.CastleDoorModelLoader;
import twilightforest.client.model.block.giantblock.NewGiantBlockModelLoader;
import twilightforest.client.model.block.patch.PatchModelLoader;
import twilightforest.client.renderer.TFSkyRenderer;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.client.renderer.entity.ShieldLayer;
import twilightforest.compat.trinkets.TrinketsCompat;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.events.HostileMountEvents;
import twilightforest.fabric.models.TFModelLoadingPlugin;
import twilightforest.init.TFItems;
import twilightforest.item.EnderBowItem;
import twilightforest.item.IceBowItem;
import twilightforest.item.SeekerBowItem;
import twilightforest.item.SkullCandleItem;
import twilightforest.item.TripleBowItem;
import twilightforest.item.TrophyItem;
import twilightforest.world.registration.TFGenerationSettings;

@Environment(value=EnvType.CLIENT)
public class TFClientEvents {
    public static int time = 0;
    private static int rotationTickerI = 0;
    private static int sineTickerI = 0;
    public static float rotationTicker = 0.0f;
    public static float sineTicker = 0.0f;
    public static final float PI = (float)Math.PI;
    private static final int SINE_TICKER_BOUND = 627;
    private static float intensity = 0.0f;
    private static int aurora = 0;
    private static int lastAurora = 0;
    private static final class_5250 WIP_TEXT_0 = class_2561.method_43471((String)"misc.twilightforest.wip0").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
    private static final class_5250 WIP_TEXT_1 = class_2561.method_43471((String)"misc.twilightforest.wip1").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
    private static final class_5250 NYI_TEXT = class_2561.method_43471((String)"misc.twilightforest.nyi").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
    private static final class_265 GIANT_BLOCK = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0);

    public static void init() {
        RegisterGeometryLoadersCallback.EVENT.register(loaders -> {
            loaders.put(TFItemLayerModel.Loader.ID, TFItemLayerModel.Loader.INSTANCE);
            loaders.put(SeparateTransformsModel.ID, SeparateTransformsModel.Loader.INSTANCE);
            loaders.put(CastleDoorModelLoader.ID, CastleDoorModelLoader.INSTANCE);
            loaders.put(PatchModelLoader.ID, PatchModelLoader.INSTANCE);
            loaders.put(NewGiantBlockModelLoader.ID, NewGiantBlockModelLoader.INSTANCE);
        });
        TFItems.addItemModelProperties();
        ModelLoadingPlugin.register((ModelLoadingPlugin)TFModelLoadingPlugin.INSTANCE);
        MinecraftTailCallback.EVENT.register(ModBusEvents::registerDimEffects);
        WorldRenderEvents.LAST.register(TFClientEvents::renderWorldLast);
        RenderTickStartCallback.EVENT.register(TFClientEvents::renderTick);
        ClientTickEvents.END_CLIENT_TICK.register(TFClientEvents::clientTick);
        ItemTooltipCallback.EVENT.register(TFClientEvents::tooltipEvent);
        FieldOfViewEvents.MODIFY.register(TFClientEvents::FOVUpdate);
        LivingEntityRenderEvents.PRE.register(TFClientEvents::unrenderHeadWithTrophies);
        ItemTooltipCallback.EVENT.register(TFClientEvents::translateBookAuthor);
        CameraSetupCallback.EVENT.register(TFClientEvents::camera);
    }

    public static void renderWorldLast(WorldRenderContext context) {
        class_897 renderer;
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        if (!((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue()) {
            return;
        }
        class_315 settings = class_310.method_1551().field_1690;
        if (settings.method_31044() != class_5498.field_26664 || settings.field_1842) {
            return;
        }
        class_1297 entity = class_310.method_1551().method_1560();
        if (entity instanceof class_1309 && (renderer = class_310.method_1551().method_1561().method_3953(entity)) instanceof class_922) {
            for (EffectRenders effect : EffectRenders.VALUES) {
                if (!effect.shouldRender((class_1309)entity, true)) continue;
                effect.render((class_1309)entity, (class_583<? extends class_1309>)((class_922)renderer).method_4038(), 0.0, 0.0, 0.0, context.tickDelta(), true);
            }
        }
    }

    public static void renderAurora(float partialTick, class_4184 camera) {
        class_243 pos = camera.method_19326();
        TFClientEvents.renderAurora(partialTick, pos.method_10216(), pos.method_10214(), pos.method_10215());
    }

    public static void renderAurora(float partialTick, double camX, double camY, double camZ) {
        if ((aurora > 0 || lastAurora > 0) && TFShaders.AURORA != null) {
            class_287 buffer = class_289.method_1348().method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            double scale = 2048.0f * (class_310.method_1551().field_1773.method_3193() / 32.0f);
            double y = 256.0 - camY;
            buffer.method_22912(-scale, y, scale).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
            buffer.method_22912(-scale, y, -scale).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
            buffer.method_22912(scale, y, -scale).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
            buffer.method_22912(scale, y, scale).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(class_3532.method_16439((float)partialTick, (float)lastAurora, (float)aurora) / 60.0f * 0.5f));
            TFShaders.AURORA_POSAWARE.invokeThenEndTesselator(class_310.method_1551().field_1687 == null ? 0 : class_3532.method_15382((int)((int)class_310.method_1551().field_1687.method_22385().field_20641)), (float)camX, (float)camY, (float)camZ);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
        }
    }

    public static void renderTick() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 != null && TFGenerationSettings.DIMENSION_KEY.equals((Object)minecraft.field_1687.method_27983())) {
            minecraft.field_1705.field_2013 = 0.0f;
        }
        if (minecraft.field_1724 != null && HostileMountEvents.isRidingUnfriendly((class_1309)minecraft.field_1724)) {
            minecraft.field_1705.method_1758((class_2561)class_2561.method_43473(), false);
        }
    }

    public static void clientTick(class_310 client) {
        if (class_310.method_1551().method_1493()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        float partial = mc.method_1488();
        if (!mc.method_1493()) {
            ++time;
            rotationTickerI = rotationTickerI >= 359 ? 0 : rotationTickerI + 1;
            sineTickerI = sineTickerI >= 627 ? 0 : sineTickerI + 1;
            rotationTicker = (float)rotationTickerI + partial;
            sineTicker += partial;
            lastAurora = aurora++;
            if (class_310.method_1551().field_1687 != null && class_310.method_1551().field_1719 != null && !TFConfig.getValidAuroraBiomes(class_310.method_1551().field_1687.method_30349()).isEmpty()) {
                class_5455 access = class_310.method_1551().field_1687.method_30349();
                class_6880 biome = class_310.method_1551().field_1687.method_23753(class_310.method_1551().field_1719.method_24515());
                if (!TFConfig.getValidAuroraBiomes(access).contains(access.method_30530(class_7924.field_41236).method_10221((Object)((class_1959)biome.comp_349())))) {
                    --aurora;
                }
                aurora = class_3532.method_15340((int)aurora, (int)0, (int)60);
            } else {
                aurora = 0;
            }
        }
        if (!mc.method_1493()) {
            BugModelAnimationHelper.animate();
            class_5294 info = DimensionRenderingRegistry.getDimensionEffects((class_2960)TwilightForestMod.prefix("renderer"));
            if (mc.field_1687 != null && info instanceof TwilightForestRenderInfo) {
                TFWeatherRenderer.tick();
            }
            if (((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue() && mc.field_1687 != null && mc.field_1724 != null) {
                HashSet<class_1923> chunksInRange = new HashSet<class_1923>();
                for (int x = -16; x <= 16; x += 16) {
                    for (int z = -16; z <= 16; z += 16) {
                        chunksInRange.add(new class_1923((int)(mc.field_1724.method_23317() + (double)x) >> 4, (int)(mc.field_1724.method_23321() + (double)z) >> 4));
                    }
                }
                for (class_1923 pos : chunksInRange) {
                    List<class_2586> beanstalksInChunk;
                    if (mc.field_1687.method_8402(pos.field_9181, pos.field_9180, class_2806.field_12803, false) == null || (beanstalksInChunk = mc.field_1687.method_8497(pos.field_9181, pos.field_9180).method_12214().values().stream().filter(blockEntity -> {
                        GrowingBeanstalkBlockEntity beanstalkBlock;
                        return blockEntity instanceof GrowingBeanstalkBlockEntity && (beanstalkBlock = (GrowingBeanstalkBlockEntity)((Object)blockEntity)).isBeanstalkRumbling();
                    }).toList()).isEmpty()) continue;
                    class_2586 beanstalk = beanstalksInChunk.get(0);
                    class_746 player = mc.field_1724;
                    intensity = (float)(1.0 - mc.field_1724.method_5707(class_243.method_24953((class_2382)beanstalk.method_11016())) / Math.pow(16.0, 2.0));
                    if (!(intensity > 0.0f)) continue;
                    player.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454() + (player.method_6051().method_43057() * 2.0f - 1.0f) * intensity, player.method_36455() + (player.method_6051().method_43057() * 2.0f - 1.0f) * intensity);
                    intensity = 0.0f;
                    break;
                }
            }
        }
    }

    public static boolean camera(CameraSetupCallback.CameraInfo info) {
        if (((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue() && !class_310.method_1551().method_1493() && intensity > 0.0f && class_310.method_1551().field_1724 != null) {
            info.yaw = (float)class_3532.method_16436((double)info.partialTicks, (double)info.yaw, (double)(info.yaw + (class_310.method_1551().field_1724.method_6051().method_43057() * 2.0f - 1.0f) * intensity));
            info.pitch = (float)class_3532.method_16436((double)info.partialTicks, (double)info.pitch, (double)(info.pitch + (class_310.method_1551().field_1724.method_6051().method_43057() * 2.0f - 1.0f) * intensity));
            info.roll = (float)class_3532.method_16436((double)info.partialTicks, (double)info.roll, (double)(info.roll + (class_310.method_1551().field_1724.method_6051().method_43057() * 2.0f - 1.0f) * intensity));
            intensity = 0.0f;
        }
        return false;
    }

    public static void tooltipEvent(class_1799 item, class_1836 context, List<class_2561> lines) {
        if (!item.method_31573(ItemTagGenerator.WIP) && !item.method_31573(ItemTagGenerator.NYI)) {
            return;
        }
        if (item.method_31573(ItemTagGenerator.WIP)) {
            lines.add((class_2561)WIP_TEXT_0);
            lines.add((class_2561)WIP_TEXT_1);
        } else {
            lines.add((class_2561)NYI_TEXT);
        }
    }

    public static float FOVUpdate(class_1657 player, float fov) {
        class_1792 useItem;
        if (player.method_6115() && ((useItem = player.method_6030().method_7909()) instanceof TripleBowItem || useItem instanceof EnderBowItem || useItem instanceof IceBowItem || useItem instanceof SeekerBowItem)) {
            float f = (float)player.method_6048() / 20.0f;
            f = f > 1.0f ? 1.0f : f * f;
            return (float)class_3532.method_16436((double)((Double)class_310.method_1551().field_1690.method_42454().method_41753()), (double)1.0, (double)(fov * (1.0f - f * 0.15f)));
        }
        return fov;
    }

    public static boolean unrenderHeadWithTrophies(class_1309 entity, class_922<?, ?> renderer, float partialRenderTick, class_4587 matrixStack, class_4597 buffers, int light) {
        class_583 class_5832;
        boolean visible;
        class_1799 stack = entity.method_6118(class_1304.field_6169);
        boolean bl = visible = !(stack.method_7909() instanceof TrophyItem) && !(stack.method_7909() instanceof SkullCandleItem) && !TFClientEvents.areCuriosEquipped(entity);
        if (!visible && (class_5832 = renderer.method_4038()) instanceof class_3882) {
            class_3882 headedModel = (class_3882)class_5832;
            headedModel.method_2838().field_3665 = false;
            class_583 class_5833 = renderer.method_4038();
            if (class_5833 instanceof class_572) {
                class_572 humanoidModel = (class_572)class_5833;
                humanoidModel.field_3394.field_3665 = false;
            }
        }
        return false;
    }

    private static boolean areCuriosEquipped(class_1309 entity) {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            return TrinketsCompat.isTrophyCurioEquipped(entity) || TrinketsCompat.isSkullCurioEquipped(entity);
        }
        return false;
    }

    public static void translateBookAuthor(class_1799 stack, class_1836 context, List<class_2561> lines) {
        class_2487 tag;
        if (stack.method_7909() instanceof class_1843 && stack.method_7985() && (tag = stack.method_7948()).method_10545("twilightforest:book")) {
            for (class_2561 component : lines) {
                if (!component.toString().contains("book.byAuthor")) continue;
                lines.set(lines.indexOf(component), (class_2561)class_2561.method_43469((String)"book.byAuthor", (Object[])new Object[]{class_2561.method_43471((String)"twilightforest.book.author")}).method_27696(component.method_10866()));
            }
        }
    }

    private static void renderGiantHitOutline(class_4587 poseStack, class_4588 consumer, class_243 cam, class_2338 pos) {
        class_4587.class_4665 last = poseStack.method_23760();
        float posX = (float)pos.method_10263() - (float)cam.method_10216();
        float posY = (float)pos.method_10264() - (float)cam.method_10214();
        float posZ = (float)pos.method_10260() - (float)cam.method_10215();
        GIANT_BLOCK.method_1104((x, y, z, x1, y1, z1) -> {
            float xSize = (float)(x1 - x);
            float ySize = (float)(y1 - y);
            float zSize = (float)(z1 - z);
            float sqrt = class_3532.method_15355((float)(xSize * xSize + ySize * ySize + zSize * zSize));
            consumer.method_22918(last.method_23761(), (float)(x + (double)posX), (float)(y + (double)posY), (float)(z + (double)posZ)).method_22915(0.0f, 0.0f, 0.0f, 0.45f).method_23763(last.method_23762(), xSize /= sqrt, ySize /= sqrt, zSize /= sqrt).method_1344();
            consumer.method_22918(last.method_23761(), (float)(x1 + (double)posX), (float)(y1 + (double)posY), (float)(z1 + (double)posZ)).method_22915(0.0f, 0.0f, 0.0f, 0.45f).method_23763(last.method_23762(), xSize, ySize, zSize).method_1344();
        });
    }

    public static class ModBusEvents {
        public static void registerModels(Consumer<class_2960> out) {
            out.accept((class_2960)ShieldLayer.LOC);
            out.accept((class_2960)new class_1091(TwilightForestMod.prefix("trophy"), "inventory"));
            out.accept((class_2960)new class_1091(TwilightForestMod.prefix("trophy_minor"), "inventory"));
            out.accept((class_2960)new class_1091(TwilightForestMod.prefix("trophy_quest"), "inventory"));
            out.accept(TwilightForestMod.prefix("block/casket_obsidian"));
            out.accept(TwilightForestMod.prefix("block/casket_stone"));
            out.accept(TwilightForestMod.prefix("block/casket_basalt"));
        }

        public static void registerDimEffects(class_310 client) {
            new TFSkyRenderer();
            new TFWeatherRenderer();
            class_2960 id = TwilightForestMod.prefix("renderer");
            TwilightForestRenderInfo info = new TwilightForestRenderInfo(128.0f, false, class_5294.class_5401.field_25639, false, false);
            DimensionRenderingRegistry.registerDimensionEffects((class_2960)id, (class_5294)info);
        }
    }
}

