/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities.shield;

import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateShieldPacket;

public class ShieldCapabilityHandler
implements IShieldCapability {
    private int temporaryShields;
    private int permanentShields;
    private final class_1309 host;
    private int timer;
    private int breakTimer;

    public ShieldCapabilityHandler(class_1309 entity) {
        this.host = entity;
    }

    @Override
    public void update() {
        class_1657 player;
        class_1309 class_13092;
        if (!(this.host.method_37908().method_8608() || this.temporaryShieldsLeft() <= 0 || this.timer-- > 0 || this.breakTimer > 0 || (class_13092 = this.host) instanceof class_1657 && (player = (class_1657)class_13092).method_7337())) {
            this.breakShield();
        }
        if (this.breakTimer > 0) {
            --this.breakTimer;
        }
    }

    @Override
    public int shieldsLeft() {
        return this.temporaryShields + this.permanentShields;
    }

    @Override
    public int temporaryShieldsLeft() {
        return this.temporaryShields;
    }

    @Override
    public int permanentShieldsLeft() {
        return this.permanentShields;
    }

    @Override
    public void breakShield() {
        if (this.breakTimer <= 0) {
            if (this.temporaryShields > 0) {
                --this.temporaryShields;
                this.resetTimer();
            } else if (this.permanentShields > 0) {
                --this.permanentShields;
            }
            class_1309 class_13092 = this.host;
            if (class_13092 instanceof class_3222) {
                class_3222 player = (class_3222)class_13092;
                player.method_7281((class_2960)TFStats.TF_SHIELDS_BROKEN.get());
            }
            this.sendUpdatePacket();
            this.host.method_37908().method_8396(null, this.host.method_24515(), (class_3414)TFSounds.SHIELD_BREAK.get(), class_3419.field_15248, 1.0f, ((this.host.method_6051().method_43057() - this.host.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
            this.breakTimer = 20;
        }
    }

    @Override
    public void replenishShields() {
        this.setShields(5, true);
        this.host.method_37908().method_8396(null, this.host.method_24515(), (class_3414)TFSounds.SHIELD_ADD.get(), class_3419.field_15248, 1.0f, (this.host.method_6051().method_43057() - this.host.method_6051().method_43057()) * 0.2f + 1.0f);
    }

    @Override
    public void setShields(int amount, boolean temp) {
        if (temp) {
            this.temporaryShields = Math.max(amount, 0);
            this.resetTimer();
        } else {
            this.permanentShields = Math.max(amount, 0);
        }
        this.sendUpdatePacket();
    }

    @Override
    public void addShields(int amount, boolean temp) {
        if (temp) {
            if (this.temporaryShields <= 0) {
                this.resetTimer();
            }
            this.temporaryShields = Math.max(this.temporaryShields + amount, 0);
        } else {
            this.permanentShields = Math.max(this.permanentShields + amount, 0);
        }
        this.sendUpdatePacket();
    }

    void initShields(int temporary, int permanent) {
        this.temporaryShields = Math.max(temporary, 0);
        this.permanentShields = Math.max(permanent, 0);
        this.resetTimer();
    }

    private void resetTimer() {
        this.timer = 240;
    }

    private void sendUpdatePacket() {
        if (this.host instanceof class_3222) {
            TFPacketHandler.CHANNEL.sendToClientsTrackingAndSelf((S2CPacket)new UpdateShieldPacket((class_1297)this.host, (IShieldCapability)this), (class_1297)this.host);
        }
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10569("tempshields", this.temporaryShieldsLeft());
        tag.method_10569("permshields", this.permanentShieldsLeft());
    }

    public void readFromNbt(class_2487 tag) {
        this.initShields(tag.method_10550("tempshields"), tag.method_10550("permshields"));
    }
}

