/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity.spawner;

import java.util.Objects;
import net.minecraft.class_1267;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import twilightforest.entity.EnforcedHomePoint;

public abstract class BossSpawnerBlockEntity<T extends class_1308>
extends class_2586 {
    protected static final int SHORT_RANGE = 9;
    protected static final int LONG_RANGE = 50;
    protected final class_1299<T> entityType;
    protected boolean spawnedBoss = false;

    protected BossSpawnerBlockEntity(class_2591<?> type, class_1299<T> entityType, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.entityType = entityType;
    }

    public boolean anyPlayerInRange() {
        return Objects.requireNonNull(this.method_10997()).method_18458((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, (double)this.getRange());
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, BossSpawnerBlockEntity<?> te) {
        if (te.spawnedBoss || !te.anyPlayerInRange()) {
            return;
        }
        if (level.method_8608()) {
            double rx = (float)pos.method_10263() + level.method_8409().method_43057();
            double ry = (float)pos.method_10264() + level.method_8409().method_43057();
            double rz = (float)pos.method_10260() + level.method_8409().method_43057();
            level.method_8406(te.getSpawnerParticle(), rx, ry, rz, 0.0, 0.0, 0.0);
        } else if (level.method_8407() != class_1267.field_5801 && te.spawnMyBoss((class_5425)((class_3218)level))) {
            level.method_22352(pos, false);
            te.spawnedBoss = true;
        }
    }

    protected boolean spawnMyBoss(class_5425 accessor) {
        T myCreature = this.makeMyCreature();
        class_2338 spawnPos = accessor.method_8320(this.method_11016().method_10074()).method_26220((class_1922)accessor, this.method_11016().method_10074()).method_1110() ? this.method_11016().method_10074() : this.method_11016();
        myCreature.method_5725(spawnPos, accessor.method_8410().method_8409().method_43057() * 360.0f, 0.0f);
        myCreature.method_5943(accessor, accessor.method_8404(spawnPos), class_3730.field_16469, null, null);
        this.initializeCreature(myCreature);
        return accessor.method_8649(myCreature);
    }

    public abstract class_2394 getSpawnerParticle();

    protected void initializeCreature(T myCreature) {
        ((EnforcedHomePoint)myCreature).setRestrictionPoint(class_4208.method_19443((class_5321)myCreature.method_37908().method_27983(), (class_2338)this.method_11016()));
    }

    protected int getRange() {
        return 9;
    }

    protected T makeMyCreature() {
        return (T)Objects.requireNonNull((class_1308)this.entityType.method_5883(Objects.requireNonNull(this.method_10997())));
    }
}

