/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.BuilderBlock;
import twilightforest.block.TranslucentBuiltBlock;
import twilightforest.enums.TowerDeviceVariant;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;

public class CarminiteBuilderBlockEntity
extends class_2586 {
    private static final int RANGE = 16;
    private int ticksRunning = 0;
    private int blockedCounter = 0;
    private int ticksStopped = 0;
    public boolean makingBlocks = false;
    private int blocksMade = 0;
    private class_2338 lastBlockCoords;
    private class_1657 trackedPlayer;
    private final class_2680 blockBuiltState = (class_2680)((class_2248)TFBlocks.BUILT_BLOCK.get()).method_9564().method_11657((class_2769)TranslucentBuiltBlock.ACTIVE, (Comparable)Boolean.valueOf(false));

    public CarminiteBuilderBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)TFBlockEntities.TOWER_BUILDER.get(), pos, state);
    }

    public void startBuilding() {
        this.makingBlocks = true;
        this.resetStats();
    }

    public void resetStats() {
        this.blocksMade = 0;
        this.lastBlockCoords = this.method_11016();
        this.ticksStopped = 0;
        this.blockedCounter = 0;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, CarminiteBuilderBlockEntity te) {
        if (!level.method_8608() && te.makingBlocks) {
            if (te.trackedPlayer == null) {
                te.trackedPlayer = te.findClosestValidPlayer();
            }
            class_2350 nextFacing = te.findNextFacing();
            ++te.ticksRunning;
            if (te.ticksRunning % 10 == 0 && te.lastBlockCoords != null && nextFacing != null) {
                class_2338 nextPos = te.lastBlockCoords.method_10093(nextFacing);
                if (te.blocksMade <= 16 && level.method_22347(nextPos)) {
                    level.method_8652(nextPos, te.blockBuiltState, 3);
                    level.method_8396(null, pos, (class_3414)TFSounds.BUILDER_CREATE.get(), class_3419.field_15245, 0.75f, 1.2f);
                    te.lastBlockCoords = nextPos;
                    te.blockedCounter = 0;
                    ++te.blocksMade;
                } else {
                    ++te.blockedCounter;
                }
            }
            if (te.blockedCounter > 0) {
                te.makingBlocks = false;
                te.trackedPlayer = null;
                te.ticksStopped = 0;
            }
        } else if (!level.method_8608() && !te.makingBlocks) {
            te.trackedPlayer = null;
            if (++te.ticksStopped == 60) {
                level.method_8501(pos, (class_2680)state.method_11657(BuilderBlock.STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_TIMEOUT)));
                level.method_39279(pos, state.method_26204(), 4);
            }
        }
    }

    @Nullable
    private class_2350 findNextFacing() {
        if (this.trackedPlayer != null) {
            int pitch = class_3532.method_15357((double)((double)(this.trackedPlayer.method_36455() * 4.0f / 360.0f) + 1.5)) & 3;
            if (pitch == 0) {
                return class_2350.field_11036;
            }
            if (pitch == 2) {
                return class_2350.field_11033;
            }
            return this.trackedPlayer.method_5735();
        }
        return null;
    }

    @Nullable
    private class_1657 findClosestValidPlayer() {
        return this.method_10997().method_18459((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, 16.0, false);
    }
}

