/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import io.github.fabricators_of_create.porting_lib.block.CustomDestroyEffectsBlock;
import io.github.fabricators_of_create.porting_lib.block.CustomHitEffectsBlock;
import io.github.fabricators_of_create.porting_lib.block.CustomLandingEffectsBlock;
import io.github.fabricators_of_create.porting_lib.block.CustomRunningEffectsBlock;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.TFConfig;
import twilightforest.init.TFParticleType;
import twilightforest.network.ParticlePacket;
import twilightforest.network.TFPacketHandler;

public class CloudBlock
extends class_2248
implements CustomLandingEffectsBlock,
CustomRunningEffectsBlock,
CustomHitEffectsBlock,
CustomDestroyEffectsBlock {
    @Nullable
    protected final class_1959.class_1963 precipitation;

    public CloudBlock(class_4970.class_2251 properties, @Nullable class_1959.class_1963 precipitation) {
        super(properties);
        this.precipitation = precipitation;
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        entity.method_5747(fallDistance, 0.1f, level.method_48963().method_48827());
    }

    public int method_9505(class_2680 state, class_1922 level, class_2338 pos) {
        return 1;
    }

    @Nullable
    public class_1959.class_1963 getPrecipitation() {
        return this.precipitation;
    }

    public Pair<class_1959.class_1963, Float> getCurrentPrecipitation(class_2338 pos, class_1937 level, float rainLevel) {
        if (this.getPrecipitation() == null) {
            if (rainLevel > 0.0f) {
                return Pair.of((Object)((class_1959)level.method_23753(pos).comp_349()).method_48162(pos), (Object)Float.valueOf(rainLevel));
            }
            return Pair.of((Object)class_1959.class_1963.field_9384, (Object)Float.valueOf(0.0f));
        }
        return Pair.of((Object)this.getPrecipitation(), (Object)Float.valueOf(1.0f));
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        class_1959.class_1963 precipitation;
        if (!level.isAreaLoaded(pos, 1) || (Integer)TFConfig.COMMON_CONFIG.cloudBlockPrecipitationDistanceCommon.get() == 0) {
            return;
        }
        Pair<class_1959.class_1963, Float> pair = this.getCurrentPrecipitation(pos, (class_1937)level, level.method_8430(1.0f));
        if (((Float)pair.getRight()).floatValue() > 0.0f && ((precipitation = (class_1959.class_1963)pair.getLeft()) == class_1959.class_1963.field_9382 || precipitation == class_1959.class_1963.field_9383)) {
            int highestRainyBlock = pos.method_10264() - 1;
            for (int y = pos.method_10264() - 1; y > pos.method_10264() - (Integer)TFConfig.COMMON_CONFIG.cloudBlockPrecipitationDistanceCommon.get() && !class_2902.class_2903.field_13197.method_16402().test(level.method_8320(pos.method_33096(y))); --y) {
                highestRainyBlock = y - 1;
            }
            if (highestRainyBlock > level.method_31607()) {
                if (precipitation == class_1959.class_1963.field_9383) {
                    int snowHeight = level.method_8450().method_8356(class_1928.field_40883);
                    class_2338 snowOnPos = pos.method_33096(highestRainyBlock + 1);
                    if (snowHeight > 0 && CloudBlock.shouldSnow((class_4538)level, snowOnPos)) {
                        class_2680 snowOnState = level.method_8320(snowOnPos);
                        if (snowOnState.method_27852(class_2246.field_10477)) {
                            int k = (Integer)snowOnState.method_11654((class_2769)class_2488.field_11518);
                            if (k < Math.min(snowHeight, 8)) {
                                class_2680 snowLayerState = (class_2680)snowOnState.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(k + 1));
                                class_2248.method_9582((class_2680)snowOnState, (class_2680)snowLayerState, (class_1936)level, (class_2338)snowOnPos);
                                level.method_8501(snowOnPos, snowLayerState);
                            }
                        } else {
                            level.method_8501(snowOnPos, class_2246.field_10477.method_9564());
                        }
                    }
                }
                class_2338 rainOnPos = pos.method_33096(highestRainyBlock);
                class_2680 rainOnState = level.method_8320(rainOnPos);
                rainOnState.method_26204().method_9504(rainOnState, (class_1937)level, rainOnPos, precipitation);
            }
        }
    }

    public static boolean shouldSnow(class_4538 level, class_2338 pos) {
        if (pos.method_10264() >= level.method_31607() && pos.method_10264() < level.method_31600() && level.method_8314(class_1944.field_9282, pos) < 10) {
            class_2680 blockstate = level.method_8320(pos);
            return (blockstate.method_26215() || blockstate.method_27852(class_2246.field_10477)) && class_2246.field_10477.method_9564().method_26184(level, pos);
        }
        return false;
    }

    public boolean addLandingEffects(class_2680 state1, class_3218 level, class_2338 pos, class_2680 state2, class_1309 living, int numberOfParticles) {
        ParticlePacket particlePacket = new ParticlePacket();
        int maxI = class_3532.method_15340((int)((int)living.field_6017 * 2), (int)8, (int)40);
        double bbWidth = living.method_17681();
        double y = living.method_23318() + 0.1;
        double ySpeed = 5.0E-4 * (double)maxI;
        for (int i = 0; i < maxI; ++i) {
            double xSpd = (living.method_6051().method_43058() - 0.5) * bbWidth * 2.5;
            double zSpd = (living.method_6051().method_43058() - 0.5) * bbWidth * 2.5;
            double x = living.method_23317() + xSpd;
            double z = living.method_23321() + zSpd;
            double xSpeed = xSpd * 0.0035 * (double)maxI;
            double zSpeed = zSpd * 0.0035 * (double)maxI;
            particlePacket.queueParticle((class_2394)TFParticleType.CLOUD_PUFF.get(), false, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        TFPacketHandler.CHANNEL.sendToClientsTracking((S2CPacket)particlePacket, level, pos);
        return true;
    }

    public boolean addRunningEffects(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (level.method_8608() && state.method_26217() != class_2464.field_11455) {
            CloudBlock.addEntityMovementParticles(level, pos, entity, false);
        }
        return true;
    }

    public static void addEntityMovementParticles(class_1937 level, class_2338 pos, class_1297 entity, boolean jumping) {
        if (level.field_9229.method_43056()) {
            return;
        }
        class_243 deltaMovement = entity.method_18798();
        class_2338 blockpos1 = entity.method_24515();
        double jumpMultiplier = jumping ? 2.0 : 1.0;
        double x = entity.method_23317() + (level.field_9229.method_43058() - 0.5) * (double)entity.field_18065.field_18067 * jumpMultiplier;
        double y = entity.method_23318() + 0.1;
        double z = entity.method_23321() + (level.field_9229.method_43058() - 0.5) * (double)entity.field_18065.field_18067 * jumpMultiplier;
        if (blockpos1.method_10263() != pos.method_10263()) {
            x = class_3532.method_15350((double)x, (double)pos.method_10263(), (double)((double)pos.method_10263() + 1.0));
        }
        if (blockpos1.method_10260() != pos.method_10260()) {
            z = class_3532.method_15350((double)z, (double)pos.method_10260(), (double)((double)pos.method_10260() + 1.0));
        }
        level.method_8406((class_2394)TFParticleType.CLOUD_PUFF.get(), x, y, z, deltaMovement.field_1352 * -0.5, 0.015 * jumpMultiplier, deltaMovement.field_1350 * -0.5);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean addHitEffects(class_2680 state, class_1937 level, class_239 target, class_702 manager) {
        class_3965 hitResult;
        class_2338 pos;
        class_2680 blockstate;
        if (level.field_9229.method_43056() && target instanceof class_3965 && (blockstate = level.method_8320(pos = (hitResult = (class_3965)target).method_17777())).method_26217() != class_2464.field_11455) {
            class_703 particle;
            class_2350 side = hitResult.method_17780();
            int posX = pos.method_10263();
            int posY = pos.method_10264();
            int posZ = pos.method_10260();
            class_238 aabb = blockstate.method_26218((class_1922)level, pos).method_1107();
            double x = (double)posX + level.field_9229.method_43058() * (aabb.field_1320 - aabb.field_1323 - (double)0.2f) + (double)0.1f + aabb.field_1323;
            double y = (double)posY + level.field_9229.method_43058() * (aabb.field_1325 - aabb.field_1322 - (double)0.2f) + (double)0.1f + aabb.field_1322;
            double z = (double)posZ + level.field_9229.method_43058() * (aabb.field_1324 - aabb.field_1321 - (double)0.2f) + (double)0.1f + aabb.field_1321;
            if (side == class_2350.field_11033) {
                y = (double)posY + aabb.field_1322 - (double)0.1f;
            }
            if (side == class_2350.field_11036) {
                y = (double)posY + aabb.field_1325 + (double)0.1f;
            }
            if (side == class_2350.field_11043) {
                z = (double)posZ + aabb.field_1321 - (double)0.1f;
            }
            if (side == class_2350.field_11035) {
                z = (double)posZ + aabb.field_1324 + (double)0.1f;
            }
            if (side == class_2350.field_11039) {
                x = (double)posX + aabb.field_1323 - (double)0.1f;
            }
            if (side == class_2350.field_11034) {
                x = (double)posX + aabb.field_1320 + (double)0.1f;
            }
            if ((particle = class_310.method_1551().field_1713.method_3056((class_2394)TFParticleType.CLOUD_PUFF.get(), x, y, z, (double)side.method_10148() * 0.01, (double)side.method_10164() * 0.01, (double)side.method_10165() * 0.01)) == null) {
                return true;
            }
            manager.method_3058(particle);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean addDestroyEffects(class_2680 state, class_638 level, class_2338 pos, class_702 manager) {
        state.method_26218((class_1922)level, pos).method_1089((boxX, boxY, boxZ, boxX1, boxY1, boxZ1) -> {
            double xSize = Math.min(1.0, boxX1 - boxX);
            double ySize = Math.min(1.0, boxY1 - boxY);
            double zSize = Math.min(1.0, boxZ1 - boxZ);
            int xMax = Math.max(2, class_3532.method_15384((double)(xSize / 0.25)));
            int yMax = Math.max(2, class_3532.method_15384((double)(ySize / 0.25)));
            int zMax = Math.max(2, class_3532.method_15384((double)(zSize / 0.25)));
            for (int xSlice = 0; xSlice < xMax; ++xSlice) {
                if (level.field_9229.method_43048(3) == 1) continue;
                for (int ySlice = 0; ySlice < yMax; ++ySlice) {
                    if (level.field_9229.method_43048(3) == 1) continue;
                    for (int zSlice = 0; zSlice < zMax; ++zSlice) {
                        if (level.field_9229.method_43048(3) == 1) continue;
                        double speedX = ((double)xSlice + 0.5) / (double)xMax;
                        double speedY = ((double)ySlice + 0.5) / (double)yMax;
                        double speedZ = ((double)zSlice + 0.5) / (double)zMax;
                        double x = speedX * xSize + boxX;
                        double y = speedY * ySize + boxY;
                        double z = speedZ * zSize + boxZ;
                        speedX = (speedX - 0.5) * 0.05;
                        speedY = (speedY - 0.5) * 0.05;
                        speedZ = (speedZ - 0.5) * 0.05;
                        class_703 particle = class_310.method_1551().field_1713.method_3056((class_2394)TFParticleType.CLOUD_PUFF.get(), (double)pos.method_10263() + x, (double)pos.method_10264() + y, (double)pos.method_10260() + z, speedX, speedY, speedZ);
                        if (particle == null) {
                            return;
                        }
                        manager.method_3058(particle);
                    }
                }
            }
        });
        return true;
    }
}

