/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2683;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFLandmark;
import twilightforest.network.MagicMapPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.LegacyLandmarkPlacements;

public class TFMagicMapData
extends class_22 {
    private static final Map<String, TFMagicMapData> CLIENT_DATA = new HashMap<String, TFMagicMapData>();
    public final Set<TFMapDecoration> tfDecorations = new HashSet<TFMapDecoration>();

    public TFMagicMapData(int x, int z, byte scale, boolean trackpos, boolean unlimited, boolean locked, class_5321<class_1937> dim) {
        super(x, z, scale, trackpos, unlimited, locked, dim);
    }

    public static TFMagicMapData load(class_2487 nbt) {
        class_22 data = class_22.method_32371((class_2487)nbt);
        boolean trackingPosition = !nbt.method_10573("trackingPosition", 1) || nbt.method_10577("trackingPosition");
        boolean unlimitedTracking = nbt.method_10577("unlimitedTracking");
        boolean locked = nbt.method_10577("locked");
        TFMagicMapData tfdata = new TFMagicMapData(data.field_116, data.field_115, data.field_119, trackingPosition, unlimitedTracking, locked, (class_5321<class_1937>)data.field_118);
        tfdata.field_122 = data.field_122;
        tfdata.field_123.putAll(data.field_123);
        tfdata.field_117.putAll(data.field_117);
        tfdata.field_121.putAll(data.field_121);
        tfdata.field_33992 = data.field_33992;
        byte[] featureStorage = nbt.method_10547("features");
        if (featureStorage.length > 0) {
            tfdata.deserializeFeatures(featureStorage);
        }
        return tfdata;
    }

    public class_2487 method_75(class_2487 cmp) {
        cmp = super.method_75(cmp);
        if (!this.tfDecorations.isEmpty()) {
            cmp.method_10570("features", this.serializeFeatures());
        }
        return cmp;
    }

    public void checkExistingFeatures(class_1937 world) {
        ArrayList<TFMapDecoration> toRemove = new ArrayList<TFMapDecoration>();
        ArrayList<TFMapDecoration> toAdd = new ArrayList<TFMapDecoration>();
        for (TFMapDecoration coord : this.tfDecorations) {
            int worldZ;
            int worldX = (coord.method_90() << this.field_119 - 1) + this.field_116;
            int trueId = TFMapDecoration.ICONS_FLIPPED.getInt((Object)LegacyLandmarkPlacements.pickLandmarkAtBlock(worldX, worldZ = (coord.method_91() << this.field_119 - 1) + this.field_115, (class_5281)((class_3218)world)));
            if (coord.featureId == trueId) continue;
            toRemove.add(coord);
            toAdd.add(new TFMapDecoration(trueId, coord.method_90(), coord.method_91(), coord.method_89()));
        }
        toRemove.forEach(this.tfDecorations::remove);
        this.tfDecorations.addAll(toAdd);
    }

    public void deserializeFeatures(byte[] arr) {
        this.tfDecorations.clear();
        for (int i = 0; i < arr.length / 3; ++i) {
            byte featureId = arr[i * 3];
            byte mapX = arr[i * 3 + 1];
            byte mapZ = arr[i * 3 + 2];
            byte mapRotation = 8;
            this.tfDecorations.add(new TFMapDecoration(featureId, mapX, mapZ, mapRotation));
        }
    }

    public byte[] serializeFeatures() {
        byte[] storage = new byte[this.tfDecorations.size() * 3];
        int i = 0;
        for (TFMapDecoration featureCoord : this.tfDecorations) {
            storage[i * 3] = (byte)featureCoord.featureId;
            storage[i * 3 + 1] = featureCoord.method_90();
            storage[i * 3 + 2] = featureCoord.method_91();
            ++i;
        }
        return storage;
    }

    @Nullable
    public static TFMagicMapData getMagicMapData(class_1937 world, String name) {
        if (world.field_9236) {
            return CLIENT_DATA.get(name);
        }
        return (TFMagicMapData)((class_3218)world).method_8503().method_30002().method_17983().method_20786(TFMagicMapData::load, name);
    }

    public static void registerMagicMapData(class_1937 world, TFMagicMapData data, String id) {
        if (world.field_9236) {
            CLIENT_DATA.put(id, data);
        } else {
            ((class_3218)world).method_8503().method_30002().method_17983().method_123(id, (class_18)data);
        }
    }

    @Nullable
    public class_2596<?> method_100(int mapId, class_1657 player) {
        class_2596 class_25962;
        class_2596 packet = super.method_100(mapId, player);
        if (packet instanceof class_2683) {
            class_2683 mapItemDataPacket = (class_2683)packet;
            class_25962 = TFPacketHandler.CHANNEL.createVanillaPacket((S2CPacket)new MagicMapPacket(this, mapItemDataPacket));
        } else {
            class_25962 = packet;
        }
        return class_25962;
    }

    public static class TFMapDecoration
    extends class_20 {
        private static final Int2ObjectArrayMap<TFLandmark> ICONS = new Int2ObjectArrayMap<TFLandmark>(){
            {
                this.defaultReturnValue(TFLandmark.NOTHING);
                this.put(0, TFLandmark.NOTHING);
                this.put(1, TFLandmark.SMALL_HILL);
                this.put(2, TFLandmark.MEDIUM_HILL);
                this.put(3, TFLandmark.LARGE_HILL);
                this.put(4, TFLandmark.HEDGE_MAZE);
                this.put(5, TFLandmark.NAGA_COURTYARD);
                this.put(6, TFLandmark.LICH_TOWER);
                this.put(7, TFLandmark.ICE_TOWER);
                this.put(9, TFLandmark.QUEST_GROVE);
                this.put(12, TFLandmark.HYDRA_LAIR);
                this.put(13, TFLandmark.LABYRINTH);
                this.put(14, TFLandmark.DARK_TOWER);
                this.put(15, TFLandmark.KNIGHT_STRONGHOLD);
                this.put(17, TFLandmark.YETI_CAVE);
                this.put(18, TFLandmark.TROLL_CAVE);
                this.put(19, TFLandmark.FINAL_CASTLE);
            }
        };
        private static final Object2IntArrayMap<TFLandmark> ICONS_FLIPPED = new Object2IntArrayMap<TFLandmark>(){
            {
                ICONS.forEach((k, v) -> this.put(v, (int)k));
            }
        };
        final int featureId;

        public TFMapDecoration(TFLandmark featureId, byte xIn, byte yIn, byte rotationIn) {
            this(ICONS_FLIPPED.getInt((Object)featureId), xIn, yIn, rotationIn);
        }

        public TFMapDecoration(int featureId, byte xIn, byte yIn, byte rotationIn) {
            super(class_20.class_21.field_84, xIn, yIn, rotationIn, (class_2561)class_2561.method_43471((String)"map.magic.text"));
            this.featureId = featureId;
        }

        @Environment(value=EnvType.CLIENT)
        public boolean render(int idx) {
            if (((TFLandmark)TFMapDecoration.ICONS.get((int)this.featureId)).isStructureEnabled) {
                RenderContext.stack.method_22903();
                RenderContext.stack.method_46416(0.0f + (float)this.method_90() / 2.0f + 64.0f, 0.0f + (float)this.method_91() / 2.0f + 64.0f, -0.02f);
                RenderContext.stack.method_22907(class_7833.field_40718.rotationDegrees((float)(this.method_89() * 360) / 16.0f));
                RenderContext.stack.method_22905(4.0f, 4.0f, 3.0f);
                RenderContext.stack.method_22904(-0.125, 0.125, 0.0);
                float f1 = (float)this.featureId % 8.0f / 8.0f;
                float f2 = (float)(this.featureId / 8) / 8.0f;
                float f3 = (float)(this.featureId % 8 + 1) / 8.0f;
                float f4 = (float)(this.featureId / 8 + 1) / 8.0f;
                Matrix4f matrix4f1 = RenderContext.stack.method_23760().method_23761();
                class_4588 ivertexbuilder1 = RenderContext.buffer.getBuffer(RenderContext.MAP_ICONS);
                ivertexbuilder1.method_22918(matrix4f1, -1.0f, 1.0f, (float)idx * -0.001f).method_1336(255, 255, 255, 255).method_22913(f1, f2).method_22916(RenderContext.light).method_1344();
                ivertexbuilder1.method_22918(matrix4f1, 1.0f, 1.0f, (float)idx * -0.001f).method_1336(255, 255, 255, 255).method_22913(f3, f2).method_22916(RenderContext.light).method_1344();
                ivertexbuilder1.method_22918(matrix4f1, 1.0f, -1.0f, (float)idx * -0.001f).method_1336(255, 255, 255, 255).method_22913(f3, f4).method_22916(RenderContext.light).method_1344();
                ivertexbuilder1.method_22918(matrix4f1, -1.0f, -1.0f, (float)idx * -0.001f).method_1336(255, 255, 255, 255).method_22913(f1, f4).method_22916(RenderContext.light).method_1344();
                RenderContext.stack.method_22909();
            }
            return true;
        }

        public boolean equals(Object o) {
            if (super.equals(o) && o instanceof TFMapDecoration) {
                TFMapDecoration tfMapDecoration = (TFMapDecoration)((Object)o);
                return this.featureId == tfMapDecoration.featureId;
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() * 31 + this.featureId;
        }

        @Environment(value=EnvType.CLIENT)
        public static class RenderContext {
            private static final class_1921 MAP_ICONS = class_1921.method_23028((class_2960)TwilightForestMod.prefix("textures/gui/mapicons.png"));
            public static class_4587 stack;
            public static class_4597 buffer;
            public static int light;
        }
    }
}

