/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen.dialog;

import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.dialog.Dialog;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ListDialog<T>
extends Dialog<List<T>> {
    protected final ListBaseEntry<T> entry;
    protected final VerticalScrollBar itemScrollBar = new VerticalScrollBar();
    protected final List<WidgetBuilder<T>> widgets = new ArrayList<WidgetBuilder<T>>();
    private int configPerPage;

    public ListDialog(class_437 parent, ListBaseEntry<T> entry) {
        super(parent, entry);
        this.entry = entry;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"<"), button -> this.method_25419()).method_46434(10, 5, 20, 15).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"+"), button -> {
            ((List)this.entry.getValue()).add(this.entry.newValue());
            this.method_41843();
        }).method_46434(this.field_22789 - 60, 5, 20, 20).method_46431());
        this.calculateMaxItems();
        this.widgets.clear();
        List values = (List)this.entry.getValue();
        for (int i = 0; i < values.size(); ++i) {
            WidgetBuilder<T> widget = WidgetBuilderManager.get(this.entry.newSingleInstance(values.get(i), i, () -> this.method_41843()));
            this.widgets.add(widget);
            widget.addDialogElements(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            }, i + ":", 40, 0, Math.max(10, this.field_22789 - 70), 20);
        }
        this.updateItemPos();
    }

    public void calculateMaxItems() {
        this.configPerPage = Math.max(0, (this.field_22790 - 25) / 25);
        this.itemScrollBar.setMaxValue(Math.max(0, ((List)this.entry.getValue()).size() - this.configPerPage));
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.calculateMaxItems();
        this.updateItemPos();
    }

    public void updateItemPos() {
        int i;
        int top = this.itemScrollBar.getValue();
        List entries = (List)this.entry.getValue();
        for (i = 0; i < top && i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < entries.size(); ++i) {
            this.widgets.get(i).update(true, 30 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (super.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        this.itemScrollBar.setValue(this.itemScrollBar.getValue() + (amount > 0.0 ? -1 : 1) * 2);
        this.updateItemPos();
        return true;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, partialTicks);
        this.itemScrollBar.render(mouseX, mouseY, partialTicks, this.field_22789 - 18, 25, 8, this.field_22790 - 50, (this.configPerPage + this.itemScrollBar.getMaxValue()) * 25);
        if (this.itemScrollBar.isDragging()) {
            this.updateItemPos();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.itemScrollBar.wasMouseOver()) {
            this.itemScrollBar.setIsDragging(true);
            this.updateItemPos();
            return true;
        }
        boolean b = super.method_25402(mouseX, mouseY, mouseButton);
        if (!b) {
            this.method_25395(null);
        }
        return b;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.itemScrollBar.setIsDragging(false);
        }
        return super.method_25406(mouseX, mouseY, mouseButton);
    }
}

