/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;

public class Config {
    private static final HashMap<String, Boolean> BOOLEAN = new LinkedHashMap<String, Boolean>();
    private static final HashMap<String, Float> FLOAT = new LinkedHashMap<String, Float>();
    private static final HashMap<String, Double> DOUBLE = new LinkedHashMap<String, Double>();
    private static final HashMap<String, Integer> INT = new LinkedHashMap<String, Integer>();

    public static File createFile(String path, String contents, boolean overwrite) {
        File file = new File(path);
        if (file.exists() && !overwrite) {
            return file;
        }
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file.setReadable(true);
        file.setWritable(true);
        file.setExecutable(true);
        if (contents == null || "".equals(contents)) {
            return file;
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(contents);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static String readFile(File file) {
        String output = "";
        try (Scanner scanner = new Scanner(file);){
            scanner.useDelimiter("\\Z");
            output = scanner.next();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static JsonObject getJsonObject(String json) {
        try {
            return new JsonParser().parse(json).getAsJsonObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean getBoolean(String key, String parent, boolean defaultValue) {
        Config.safeValueFetch("boolean", parent);
        if (!BOOLEAN.isEmpty() && BOOLEAN.containsKey(key)) {
            return BOOLEAN.get(key);
        }
        System.out.println("Failed to fetch config value for " + key + ". Loading default value.\nIt is recommended that you restart your game.");
        return defaultValue;
    }

    public static float getFloat(String key, String parent, float defaultValue) {
        Config.safeValueFetch("float", parent);
        if (!FLOAT.isEmpty() && FLOAT.containsKey(key)) {
            return FLOAT.get(key).floatValue();
        }
        System.out.println("Failed to fetch config value for " + key + ". Loading default value.\nIt is recommended that you restart your game.");
        return defaultValue;
    }

    public static double getDouble(String key, String parent, double defaultValue) {
        Config.safeValueFetch("double", parent);
        if (!DOUBLE.isEmpty() && DOUBLE.containsKey(key)) {
            return DOUBLE.get(key);
        }
        System.out.println("Failed to fetch config value for " + key + ". Loading default value.\nIt is recommended that you restart your game.");
        return defaultValue;
    }

    public static int getInt(String key, String parent, int defaultValue) {
        Config.safeValueFetch("int", parent);
        if (!INT.isEmpty() && INT.containsKey(key)) {
            return INT.get(key);
        }
        System.out.println("Failed to fetch config value for " + key + ". Loading default value.\nIt is recommended that you restart your game.");
        return defaultValue;
    }

    public static void safeValueFetch(String type, String parent) {
        Path path = Paths.get("config/simplyswords_main/", new String[0]);
        JsonObject json = null;
        if (Files.exists(path, new LinkOption[0])) {
            switch (parent) {
                case "GemEffects": {
                    JsonObject jsonObject = Config.getJsonObject(Config.readFile(new File("config/simplyswords_main/gem_effects.json5")));
                    break;
                }
                case "General": {
                    JsonObject jsonObject = Config.getJsonObject(Config.readFile(new File("config/simplyswords_main/general.json5")));
                    break;
                }
                case "Loot": {
                    JsonObject jsonObject = Config.getJsonObject(Config.readFile(new File("config/simplyswords_main/loot.json5")));
                    break;
                }
                case "RunicEffects": {
                    JsonObject jsonObject = Config.getJsonObject(Config.readFile(new File("config/simplyswords_main/runic_effects.json5")));
                    break;
                }
                case "StatusEffects": {
                    JsonObject jsonObject = Config.getJsonObject(Config.readFile(new File("config/simplyswords_main/status_effects.json5")));
                    break;
                }
                case "UniqueEffects": {
                    JsonObject jsonObject = Config.getJsonObject(Config.readFile(new File("config/simplyswords_main/unique_effects.json5")));
                    break;
                }
                case "WeaponAttributes": {
                    JsonObject jsonObject = Config.getJsonObject(Config.readFile(new File("config/simplyswords_main/weapon_attributes.json5")));
                    break;
                }
                default: {
                    JsonObject jsonObject = json = null;
                }
            }
        }
        if (json != null) {
            switch (type) {
                case "boolean": {
                    for (Map.Entry entry : json.entrySet()) {
                        try {
                            BOOLEAN.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                case "float": {
                    for (Map.Entry entry : json.entrySet()) {
                        try {
                            FLOAT.put((String)entry.getKey(), Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                case "double": {
                    for (Map.Entry entry : json.entrySet()) {
                        try {
                            DOUBLE.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsDouble());
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                case "int": {
                    for (Map.Entry entry : json.entrySet()) {
                        try {
                            INT.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
            }
        }
    }
}

