/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.relationship;

import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.entity.ai.relationship.RelationshipType;
import forge.net.mca.server.world.data.FamilyTree;
import forge.net.mca.server.world.data.FamilyTreeNode;
import forge.net.mca.server.world.data.PlayerSaveData;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityRelationship {
    default public Gender getGender() {
        return Gender.MALE;
    }

    default public FamilyTree getFamilyTree() {
        return FamilyTree.get(this.getWorld());
    }

    public ServerLevel getWorld();

    public UUID getUUID();

    @NotNull
    public FamilyTreeNode getFamilyEntry();

    default public Stream<Entity> getFamily(int parents, int children) {
        return this.getFamilyEntry().getRelatives(parents, children).map(arg_0 -> ((ServerLevel)this.getWorld()).m_8791_(arg_0)).filter(Objects::nonNull).filter(e -> !e.m_20148_().equals(this.getUUID()));
    }

    default public Stream<Entity> getParents() {
        return this.getFamilyEntry().streamParents().map(arg_0 -> ((ServerLevel)this.getWorld()).m_8791_(arg_0)).filter(Objects::nonNull);
    }

    default public Optional<Entity> getPartner() {
        return Optional.ofNullable(this.getWorld().m_8791_(this.getFamilyEntry().partner()));
    }

    default public Stream<EntityRelationship> getRelationshipStream(Stream<UUID> uuids) {
        return uuids.map(uuid -> PlayerSaveData.getIfPresent(this.getWorld(), uuid).map(p -> p).or(() -> EntityRelationship.of(this.getWorld().m_8791_(uuid)))).filter(Optional::isPresent).map(Optional::get);
    }

    default public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite, RelationshipType type, Entity victim) {
        if (type == RelationshipType.STRANGER) {
            return;
        }
        if (type == RelationshipType.SELF) {
            this.getRelationshipStream(this.getFamilyEntry().streamParents()).forEach(r -> r.onTragedy(cause, burialSite, RelationshipType.CHILD, victim));
            this.getRelationshipStream(this.getFamilyEntry().siblings().stream()).forEach(r -> r.onTragedy(cause, burialSite, RelationshipType.SIBLING, victim));
            this.getRelationshipStream(Stream.of(this.getFamilyEntry().partner())).forEach(r -> r.onTragedy(cause, burialSite, RelationshipType.SPOUSE, victim));
        }
        if (type == RelationshipType.SPOUSE || type == RelationshipType.SELF) {
            if (this.getRelationshipState().isMarried()) {
                this.endRelationShip(RelationshipState.WIDOW);
            } else {
                this.endRelationShip(RelationshipState.SINGLE);
            }
        }
    }

    default public void marry(Entity spouse) {
        RelationshipState state;
        RelationshipState relationshipState = state = spouse instanceof Player ? RelationshipState.MARRIED_TO_PLAYER : RelationshipState.MARRIED_TO_VILLAGER;
        if (spouse instanceof ServerPlayer) {
            ServerPlayer spouseEntity = (ServerPlayer)spouse;
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger(spouseEntity, "marriage");
        }
        this.getFamilyEntry().updatePartner(spouse, state);
    }

    default public void engage(Entity spouse) {
        if (spouse instanceof ServerPlayer) {
            ServerPlayer spouseEntity = (ServerPlayer)spouse;
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger(spouseEntity, "engage");
        }
        this.getFamilyEntry().updatePartner(spouse, RelationshipState.ENGAGED);
    }

    default public void promise(Entity spouse) {
        if (spouse instanceof ServerPlayer) {
            ServerPlayer spouseEntity = (ServerPlayer)spouse;
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger(spouseEntity, "promise");
        }
        this.getFamilyEntry().updatePartner(spouse, RelationshipState.PROMISED);
    }

    default public void endRelationShip(RelationshipState newState) {
        this.getFamilyEntry().updatePartner(null, newState);
    }

    default public RelationshipState getRelationshipState() {
        return this.getFamilyEntry().getRelationshipState();
    }

    default public Optional<UUID> getPartnerUUID() {
        UUID spouse = this.getFamilyEntry().partner();
        if (spouse.equals(Util.f_137441_)) {
            return Optional.empty();
        }
        return Optional.of(spouse);
    }

    default public Optional<Component> getPartnerName() {
        return this.getFamilyTree().getOrEmpty(this.getFamilyEntry().partner()).map(FamilyTreeNode::getName).map(Component::m_237113_);
    }

    default public boolean isMarried() {
        return this.getRelationshipState() == RelationshipState.MARRIED_TO_PLAYER || this.getRelationshipState() == RelationshipState.MARRIED_TO_VILLAGER;
    }

    default public boolean isEngaged() {
        return this.getRelationshipState() == RelationshipState.ENGAGED;
    }

    default public boolean isPromised() {
        return this.getRelationshipState() == RelationshipState.PROMISED;
    }

    default public boolean isPromisedTo(UUID uuid) {
        return this.getPartnerUUID().orElse(Util.f_137441_).equals(uuid) && this.isPromised();
    }

    default public boolean isMarriedTo(UUID uuid) {
        return this.getPartnerUUID().orElse(Util.f_137441_).equals(uuid) && this.isMarried();
    }

    default public boolean isEngagedWith(UUID uuid) {
        return this.getPartnerUUID().orElse(Util.f_137441_).equals(uuid) && this.isEngaged();
    }

    public static Optional<EntityRelationship> of(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return Optional.ofNullable(PlayerSaveData.get(player));
        }
        if (entity instanceof CompassionateEntity) {
            CompassionateEntity compassionateEntity = (CompassionateEntity)entity;
            return Optional.ofNullable(compassionateEntity.getRelationships());
        }
        return Optional.empty();
    }
}

