/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.client.sound.CustomEntityBoundSoundInstance;
import forge.net.mca.client.sound.SingleWeighedSoundEvents;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.SampledFloat;
import net.minecraft.world.entity.Entity;

public class OnlineSpeechManager {
    private static final MessageDigest MESSAGEDIGEST;
    public static final OnlineSpeechManager INSTANCE;
    private final Minecraft client;
    private boolean warningIssued = false;
    private final Random random = new Random();

    public OnlineSpeechManager() {
        this.client = Minecraft.m_91087_();
    }

    public static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format(Locale.ROOT, "%0" + (bytes.length << 1) + "X", bi);
    }

    public String getHash(String text) {
        MESSAGEDIGEST.update(text.getBytes());
        return OnlineSpeechManager.toHex(MESSAGEDIGEST.digest()).toLowerCase(Locale.ROOT);
    }

    public void play(String language, String voice, float pitch, String text, Entity entity) {
        String hash = this.getHash(text);
        CompletableFuture.runAsync(() -> {
            if (this.downloadAudio(language, voice, text, hash, false)) {
                this.play(language, voice, pitch, entity, hash);
            } else if (!this.warningIssued) {
                this.warningIssued = true;
                Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237115_((String)"command.tts_busy").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}), false);
            }
        });
    }

    public void play(String language, String voice, float pitch, Entity entity, String hash) {
        ResourceLocation soundLocation = MCA.locate("tts_cache/" + language + "-" + voice + "/" + hash);
        Sound sound = new Sound(soundLocation.m_135815_(), (SampledFloat)ConstantFloat.m_146458_((float)1.0f), (SampledFloat)ConstantFloat.m_146458_((float)1.0f), 1, Sound.Type.FILE, true, false, 16);
        SingleWeighedSoundEvents weightedSoundEvents = new SingleWeighedSoundEvents(sound, soundLocation, "");
        CustomEntityBoundSoundInstance instance = new CustomEntityBoundSoundInstance(weightedSoundEvents, SoundEvent.m_262824_((ResourceLocation)soundLocation), SoundSource.NEUTRAL, 1.0f, pitch, entity, this.random.nextLong());
        this.client.execute(() -> this.client.m_91106_().m_120367_((SoundInstance)instance));
    }

    public boolean downloadAudio(String language, String voice, String text, String hash, boolean dry) {
        boolean bl;
        File file = new File("tts_cache/" + language + "-" + voice + "/" + hash + ".ogg");
        if (file.exists()) {
            if (file.length() == 0L) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    MCA.LOGGER.warn("Failed to delete file " + file.getPath());
                }
            } else {
                return true;
            }
        }
        file.getParentFile().mkdirs();
        FileOutputStream stream = new FileOutputStream(file);
        try {
            Map<String, String> params = Map.of("text", this.cleanPhrase(text), "language", language, "speaker", voice, "file_format", "ogg", "cache", "true", "prepare_speakers", String.valueOf(10), "load_async", "true");
            String encodedURL = params.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)params.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", Config.getInstance().villagerTTSServer + "v1/tts/xtts-v2?", ""));
            bl = this.downloadFile(encodedURL, stream, dry);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                MCA.LOGGER.warn("Failed to open file " + file.getPath());
                return false;
            }
        }
        stream.close();
        return bl;
    }

    private boolean downloadFile(String url, OutputStream output, boolean dry) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            int totalBytesRead = 0;
            try (InputStream input = connection.getInputStream();){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = input.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                    totalBytesRead += bytesRead;
                    if (!dry) continue;
                    break;
                }
            }
            connection.disconnect();
            return totalBytesRead > 100;
        }
        catch (IOException e) {
            MCA.LOGGER.warn("Failed to download " + url + ": " + e.getMessage());
            return false;
        }
    }

    public String cleanPhrase(String p) {
        p = p.replaceAll("\\*.*\\*", "");
        p = p.replace("%supporter%", "someone");
        p = p.replace("%Supporter%", "someone");
        p = p.replace("some %2$s", "something");
        p = p.replace("at %2$s", "somewhere here");
        p = p.replace("At %2$s", "Somewhere here");
        p = p.replace(" to %2$s", " to here");
        p = p.replace(", %1$s.", ".");
        p = p.replace(", %1$s!", "!");
        p = p.replace(" %1$s!", "!");
        p = p.replace(", %1$s.", ".");
        p = p.replace("%1$s!", " ");
        p = p.replace("%1$s, ", " ");
        p = p.replace("%1$s", " ");
        p = p.replace("avoid %2$s", "avoid that location");
        p = p.replace(" Should be around %2$s.", "");
        p = p.replace("  ", " ");
        p = p.replace(" ,", ",");
        p = p.replace("Bahaha! ", "");
        p = p.replace("Run awaaaaaay! ", "Run!");
        p = p.replace("Aaaaaaaahhh! ", "");
        p = p.replace("Aaaaaaahhh! ", "");
        p = p.replace("Aaaaaaaaaaahhh! ", "");
        p = p.replace("AAAAAAAAAAAAAAAAAAAHHHHHH!!!!!! ", "");
        p = p.trim();
        return p;
    }

    static {
        INSTANCE = new OnlineSpeechManager();
        try {
            MESSAGEDIGEST = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

