/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.block.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.dungeonz.block.screen.DungeonPortalScreenHandler;
import net.dungeonz.dungeon.Dungeon;
import net.dungeonz.dungeon.DungeonPlacementHandler;
import net.dungeonz.init.BlockInit;
import net.dungeonz.init.ConfigInit;
import net.dungeonz.init.CriteriaInit;
import net.dungeonz.init.DimensionInit;
import net.dungeonz.init.SoundInit;
import net.dungeonz.network.DungeonServerPacket;
import net.dungeonz.util.DungeonHelper;
import net.dungeonz.util.InventoryHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2640;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_4051;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DungeonPortalEntity
extends class_2640
implements ExtendedScreenHandlerFactory {
    private class_2561 title = class_2561.method_43471((String)"container.dungeon_portal");
    private String dungeonType = "";
    private String difficulty = "";
    private boolean dungeonStructureGenerated = false;
    private List<UUID> dungeonPlayerUuids = new ArrayList<UUID>();
    private List<UUID> deadDungeonPlayerUuids = new ArrayList<UUID>();
    private int maxGroupSize = 0;
    private int minGroupSize = 0;
    private List<UUID> waitingUuids = new ArrayList<UUID>();
    private int cooldownTime = 0;
    private int autoKickTime = 0;
    private boolean disableEffects = false;
    private boolean privateGroup = false;
    private HashMap<Integer, ArrayList<class_2338>> blockBlockPosMap = new HashMap();
    private List<class_2338> chestPosList = new ArrayList<class_2338>();
    private List<class_2338> exitPosList = new ArrayList<class_2338>();
    private List<class_2338> gatePosList = new ArrayList<class_2338>();
    private class_2338 bossBlockPos = new class_2338(0, 0, 0);
    private class_2338 bossLootBlockPos = new class_2338(0, 0, 0);
    private HashMap<class_2338, Integer> spawnerPosEntityIdMap = new HashMap();
    private HashMap<class_2338, Integer> replacePosBlockIdMap = new HashMap();
    private List<Integer> dungeonEdgeList = new ArrayList<Integer>();
    private int dungeonTeleportCountdown = 0;

    public DungeonPortalEntity(class_2338 pos, class_2680 state) {
        super(BlockInit.DUNGEON_PORTAL_ENTITY, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        int i;
        super.method_11014(nbt);
        this.dungeonType = nbt.method_10558("DungeonType");
        this.difficulty = nbt.method_10558("Difficulty");
        this.dungeonStructureGenerated = nbt.method_10577("DungeonStructureGenerated");
        this.dungeonPlayerUuids.clear();
        for (i = 0; i < nbt.method_10550("DungeonPlayerCount"); ++i) {
            this.dungeonPlayerUuids.add(nbt.method_25926("PlayerUUID" + i));
        }
        this.deadDungeonPlayerUuids.clear();
        for (i = 0; i < nbt.method_10550("DeadDungeonPlayerCount"); ++i) {
            this.deadDungeonPlayerUuids.add(nbt.method_25926("DeadPlayerUUID" + i));
        }
        this.maxGroupSize = nbt.method_10550("MaxGroupSize");
        this.minGroupSize = nbt.method_10550("MinGroupSize");
        this.cooldownTime = nbt.method_10550("CooldownTime");
        this.autoKickTime = nbt.method_10550("AutoKickTime");
        this.disableEffects = nbt.method_10577("DisableEffects");
        this.privateGroup = nbt.method_10577("PrivateGroup");
        this.blockBlockPosMap.clear();
        if (nbt.method_10550("BlockMapSize") > 0) {
            for (i = 0; i < nbt.method_10550("BlockMapSize"); ++i) {
                ArrayList<class_2338> posList = new ArrayList<class_2338>();
                for (int u = 0; u < nbt.method_10550("BlockListSize" + i); ++u) {
                    posList.add(new class_2338(nbt.method_10550("BlockPosX" + i + u), nbt.method_10550("BlockPosY" + i + u), nbt.method_10550("BlockPosZ" + i + u)));
                }
                this.blockBlockPosMap.put(nbt.method_10550("BlockId" + i), posList);
            }
        }
        this.bossBlockPos = new class_2338(nbt.method_10550("BossPosX"), nbt.method_10550("BossPosY"), nbt.method_10550("BossPosZ"));
        this.bossLootBlockPos = new class_2338(nbt.method_10550("BossLootPosX"), nbt.method_10550("BossLootPosY"), nbt.method_10550("BossLootPosZ"));
        if (nbt.method_10550("ChestListSize") > 0) {
            this.chestPosList.clear();
            for (i = 0; i < nbt.method_10550("ChestListSize"); ++i) {
                this.chestPosList.add(new class_2338(nbt.method_10550("ChestPosX" + i), nbt.method_10550("ChestPosY" + i), nbt.method_10550("ChestPosZ" + i)));
            }
        }
        if (nbt.method_10550("ExitListSize") > 0) {
            this.exitPosList.clear();
            for (i = 0; i < nbt.method_10550("ExitListSize"); ++i) {
                this.exitPosList.add(new class_2338(nbt.method_10550("ExitPosX" + i), nbt.method_10550("ExitPosY" + i), nbt.method_10550("ExitPosZ" + i)));
            }
        }
        if (nbt.method_10550("SpawnerMapSize") > 0) {
            this.spawnerPosEntityIdMap.clear();
            for (i = 0; i < nbt.method_10550("SpawnerListSize"); ++i) {
                this.spawnerPosEntityIdMap.put(new class_2338(nbt.method_10550("SpawnerPosX" + i), nbt.method_10550("SpawnerPosY" + i), nbt.method_10550("SpawnerPosZ" + i)), nbt.method_10550("SpawnerEntityId" + i));
            }
        }
        if (nbt.method_10550("ReplacePosSize") > 0) {
            this.replacePosBlockIdMap.clear();
            for (i = 0; i < nbt.method_10550("ReplacePosSize"); ++i) {
                this.replacePosBlockIdMap.put(new class_2338(nbt.method_10550("ReplacePosX" + i), nbt.method_10550("ReplacePosY" + i), nbt.method_10550("ReplacePosZ" + i)), nbt.method_10550("ReplaceBlockId" + i));
            }
        }
        if (nbt.method_10550("DungeonEdgeSize") > 0) {
            this.dungeonEdgeList.clear();
            for (i = 0; i < nbt.method_10550("DungeonEdgeSize") / 3; ++i) {
                this.dungeonEdgeList.add(nbt.method_10550("DungeonEdgeX" + i));
                this.dungeonEdgeList.add(nbt.method_10550("DungeonEdgeY" + i));
                this.dungeonEdgeList.add(nbt.method_10550("DungeonEdgeZ" + i));
            }
        }
        if (nbt.method_10550("GateListSize") > 0) {
            this.gatePosList.clear();
            for (i = 0; i < nbt.method_10550("GateListSize"); ++i) {
                this.gatePosList.add(new class_2338(nbt.method_10550("GatePosX" + i), nbt.method_10550("GatePosY" + i), nbt.method_10550("GatePosZ" + i)));
            }
        }
    }

    public void method_11007(class_2487 nbt) {
        int i;
        super.method_11007(nbt);
        nbt.method_10582("DungeonType", this.dungeonType);
        nbt.method_10582("Difficulty", this.difficulty);
        nbt.method_10556("DungeonStructureGenerated", this.dungeonStructureGenerated);
        nbt.method_10569("DungeonPlayerCount", this.dungeonPlayerUuids.size());
        for (i = 0; i < this.dungeonPlayerUuids.size(); ++i) {
            nbt.method_25927("PlayerUUID" + i, this.dungeonPlayerUuids.get(i));
        }
        nbt.method_10569("DeadDungeonPlayerCount", this.deadDungeonPlayerUuids.size());
        for (i = 0; i < this.deadDungeonPlayerUuids.size(); ++i) {
            nbt.method_25927("DeadPlayerUUID" + i, this.deadDungeonPlayerUuids.get(i));
        }
        nbt.method_10569("MaxGroupSize", this.maxGroupSize);
        nbt.method_10569("MinGroupSize", this.minGroupSize);
        nbt.method_10569("CooldownTime", this.cooldownTime);
        nbt.method_10569("AutoKickTime", this.autoKickTime);
        nbt.method_10556("DisableEffects", this.disableEffects);
        nbt.method_10556("PrivateGroup", this.privateGroup);
        nbt.method_10569("BlockMapSize", this.blockBlockPosMap.size());
        if (this.blockBlockPosMap.size() > 0) {
            int blockCount = 0;
            for (Map.Entry<Integer, ArrayList<class_2338>> entry : this.blockBlockPosMap.entrySet()) {
                nbt.method_10569("BlockId" + blockCount, entry.getKey().intValue());
                nbt.method_10569("BlockListSize" + blockCount, entry.getValue().size());
                for (int i2 = 0; i2 < entry.getValue().size(); ++i2) {
                    nbt.method_10569("BlockPosX" + blockCount + i2, entry.getValue().get(i2).method_10263());
                    nbt.method_10569("BlockPosY" + blockCount + i2, entry.getValue().get(i2).method_10264());
                    nbt.method_10569("BlockPosZ" + blockCount + i2, entry.getValue().get(i2).method_10260());
                }
                ++blockCount;
            }
        }
        nbt.method_10569("BossPosX", this.bossBlockPos.method_10263());
        nbt.method_10569("BossPosY", this.bossBlockPos.method_10264());
        nbt.method_10569("BossPosZ", this.bossBlockPos.method_10260());
        nbt.method_10569("BossLootPosX", this.bossLootBlockPos.method_10263());
        nbt.method_10569("BossLootPosY", this.bossLootBlockPos.method_10264());
        nbt.method_10569("BossLootPosZ", this.bossLootBlockPos.method_10260());
        nbt.method_10569("ChestListSize", this.chestPosList.size());
        if (this.chestPosList.size() > 0) {
            for (i = 0; i < this.chestPosList.size(); ++i) {
                nbt.method_10569("ChestPosX" + i, this.chestPosList.get(i).method_10263());
                nbt.method_10569("ChestPosY" + i, this.chestPosList.get(i).method_10264());
                nbt.method_10569("ChestPosZ" + i, this.chestPosList.get(i).method_10260());
            }
        }
        nbt.method_10569("ExitListSize", this.exitPosList.size());
        if (this.exitPosList.size() > 0) {
            for (i = 0; i < this.exitPosList.size(); ++i) {
                nbt.method_10569("ExitPosX" + i, this.exitPosList.get(i).method_10263());
                nbt.method_10569("ExitPosY" + i, this.exitPosList.get(i).method_10264());
                nbt.method_10569("ExitPosZ" + i, this.exitPosList.get(i).method_10260());
            }
        }
        nbt.method_10569("SpawnerMapSize", this.spawnerPosEntityIdMap.size());
        if (this.spawnerPosEntityIdMap.size() > 0) {
            Iterator<Map.Entry<class_2338, Integer>> iterator = this.spawnerPosEntityIdMap.entrySet().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Map.Entry<class_2338, Integer> entry = iterator.next();
                nbt.method_10569("SpawnerPosX" + count, entry.getKey().method_10263());
                nbt.method_10569("SpawnerPosY" + count, entry.getKey().method_10264());
                nbt.method_10569("SpawnerPosZ" + count, entry.getKey().method_10260());
                nbt.method_10569("SpawnerEntityId" + count, entry.getValue().intValue());
                ++count;
            }
        }
        nbt.method_10569("ReplacePosSize", this.replacePosBlockIdMap.size());
        if (this.replacePosBlockIdMap.size() > 0) {
            Iterator<Map.Entry<class_2338, Integer>> iterator = this.replacePosBlockIdMap.entrySet().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Map.Entry<class_2338, Integer> entry = iterator.next();
                nbt.method_10569("ReplacePosX" + count, entry.getKey().method_10263());
                nbt.method_10569("ReplacePosY" + count, entry.getKey().method_10264());
                nbt.method_10569("ReplacePosZ" + count, entry.getKey().method_10260());
                nbt.method_10569("ReplaceBlockId" + count, entry.getValue().intValue());
                ++count;
            }
        }
        nbt.method_10569("DungeonEdgeSize", this.dungeonEdgeList.size());
        if (this.dungeonEdgeList.size() > 0) {
            for (int i3 = 0; i3 < this.dungeonEdgeList.size() / 3; ++i3) {
                nbt.method_10569("DungeonEdgeX" + i3, this.dungeonEdgeList.get(3 * i3).intValue());
                nbt.method_10569("DungeonEdgeY" + i3, this.dungeonEdgeList.get(1 + 3 * i3).intValue());
                nbt.method_10569("DungeonEdgeZ" + i3, this.dungeonEdgeList.get(2 + 3 * i3).intValue());
            }
        }
        nbt.method_10569("GateListSize", this.gatePosList.size());
        if (this.gatePosList.size() > 0) {
            for (int i4 = 0; i4 < this.gatePosList.size(); ++i4) {
                nbt.method_10569("GatePosX" + i4, this.gatePosList.get(i4).method_10263());
                nbt.method_10569("GatePosY" + i4, this.gatePosList.get(i4).method_10264());
                nbt.method_10569("GatePosZ" + i4, this.gatePosList.get(i4).method_10260());
            }
        }
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, DungeonPortalEntity blockEntity) {
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, DungeonPortalEntity blockEntity) {
        int i;
        if (blockEntity.getDungeonPlayerCount() > 0) {
            if (blockEntity.autoKickTime == 0) {
                blockEntity.autoKickTime = (int)world.method_8510() + 432000;
            } else if (blockEntity.autoKickTime < (int)world.method_8510()) {
                if (blockEntity.getDungeon() != null) {
                    blockEntity.setCooldownTime(blockEntity.getDungeon().getCooldown() + (int)blockEntity.method_10997().method_8510());
                    for (i = 0; i < blockEntity.getDungeonPlayerUuids().size(); ++i) {
                        class_3222 player = (class_3222)world.method_18470(blockEntity.getDungeonPlayerUuids().get(i));
                        if (DungeonHelper.getCurrentDungeon(player) == null) continue;
                        DungeonHelper.teleportOutOfDungeon(player);
                        player.method_43496((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_autokick"));
                    }
                }
                blockEntity.getDungeonPlayerUuids().clear();
                blockEntity.getDeadDungeonPlayerUUIDs().clear();
                blockEntity.autoKickTime = 0;
            }
        } else if (blockEntity.autoKickTime != 0) {
            blockEntity.autoKickTime = 0;
        }
        if (blockEntity.dungeonTeleportCountdown >= 1) {
            class_3222 serverPlayerEntity;
            class_1297 class_12972;
            if (blockEntity.dungeonTeleportCountdown % 20 == 0) {
                for (i = 0; i < blockEntity.getWaitingUuids().size(); ++i) {
                    if (((class_3218)blockEntity.method_10997()).method_14190(blockEntity.getWaitingUuids().get(i)) == null || !((class_12972 = ((class_3218)blockEntity.method_10997()).method_14190(blockEntity.getWaitingUuids().get(i))) instanceof class_3222)) continue;
                    serverPlayerEntity = (class_3222)class_12972;
                    DungeonServerPacket.writeS2CDungeonTeleportCountdown(serverPlayerEntity, blockEntity.dungeonTeleportCountdown);
                }
            }
            --blockEntity.dungeonTeleportCountdown;
            if (blockEntity.dungeonTeleportCountdown == ConfigInit.CONFIG.defaultDungeonTeleportCountdown / 2) {
                DungeonPlacementHandler.refreshDungeon(((class_3218)blockEntity.method_10997()).method_8503(), blockEntity.method_10997().method_8503().method_3847(DimensionInit.DUNGEON_WORLD), blockEntity, blockEntity.getDungeon(), blockEntity.getDifficulty(), blockEntity.getDisableEffects());
            }
            if (blockEntity.dungeonTeleportCountdown == 0) {
                for (i = 0; i < blockEntity.getWaitingUuids().size(); ++i) {
                    if (((class_3218)blockEntity.method_10997()).method_14190(blockEntity.getWaitingUuids().get(i)) == null || !((class_12972 = ((class_3218)blockEntity.method_10997()).method_14190(blockEntity.getWaitingUuids().get(i))) instanceof class_3222)) continue;
                    serverPlayerEntity = (class_3222)class_12972;
                    DungeonHelper.teleportPlayer(serverPlayerEntity, blockEntity.method_10997().method_8503().method_3847(DimensionInit.DUNGEON_WORLD), blockEntity, blockEntity.method_11016());
                }
                blockEntity.getWaitingUuids().clear();
            }
        }
    }

    public class_2561 method_5476() {
        if (this.getDungeon() != null) {
            return class_2561.method_43471((String)("dungeon." + this.getDungeonType()));
        }
        return this.title;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity) {
        return new DungeonPortalScreenHandler(syncId, playerInventory, this, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.field_11867));
    }

    public boolean method_11400(class_2350 direction) {
        return true;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        int i;
        buf.method_10807(this.field_11867);
        buf.method_10807(this.field_11867);
        buf.method_10807(this.field_11867);
        buf.writeInt(this.getDungeonPlayerCount());
        for (i = 0; i < this.getDungeonPlayerCount(); ++i) {
            buf.method_10797(this.getDungeonPlayerUuids().get(i));
        }
        buf.writeInt(this.getDeadDungeonPlayerUUIDs().size());
        for (i = 0; i < this.getDeadDungeonPlayerUUIDs().size(); ++i) {
            buf.method_10797(this.getDeadDungeonPlayerUUIDs().get(i));
        }
        if (this.getDungeon() != null) {
            buf.writeInt(this.getDungeon().getDifficultyList().size());
            for (i = 0; i < this.getDungeon().getDifficultyList().size(); ++i) {
                buf.method_10814(this.getDungeon().getDifficultyList().get(i));
            }
            Map<String, List<class_1799>> possibleLoot = DungeonHelper.getPossibleLootItemStackMap(this.getDungeon(), player.method_5682());
            buf.writeInt(possibleLoot.size());
            for (Map.Entry<String, List<class_1799>> entry : possibleLoot.entrySet()) {
                buf.method_10814(entry.getKey());
                buf.writeInt(entry.getValue().size());
                for (int i2 = 0; i2 < entry.getValue().size(); ++i2) {
                    buf.method_10793(entry.getValue().get(i2));
                }
            }
            buf.writeInt(DungeonHelper.getRequiredItemStackList(this.getDungeon()).size());
            for (int i3 = 0; i3 < DungeonHelper.getRequiredItemStackList(this.getDungeon()).size(); ++i3) {
                buf.method_10793(DungeonHelper.getRequiredItemStackList(this.getDungeon()).get(i3));
            }
        } else {
            buf.writeInt(0);
            buf.writeInt(0);
            buf.writeInt(0);
        }
        buf.writeInt(this.getMaxGroupSize());
        buf.writeInt(this.getMinGroupSize());
        buf.writeInt(this.getWaitingUuids().size());
        buf.writeInt(this.getCooldownTime());
        buf.method_10814(this.getDifficulty());
        buf.writeBoolean(this.getDisableEffects());
        buf.writeBoolean(this.getPrivateGroup());
    }

    public void finishDungeon(class_3218 world, class_2338 pos) {
        int i;
        List players = world.method_18464(class_4051.method_36625().method_18418(64.0), null, new class_238(pos).method_1009(64.0, 64.0, 64.0));
        for (i = 0; i < players.size(); ++i) {
            CriteriaInit.DUNGEON_COMPLETION.trigger((class_3222)players.get(i), this.getDungeonType(), this.getDifficulty());
        }
        world.method_8396(null, pos, SoundInit.DUNGEON_COMPLETION_EVENT, class_3419.field_15245, 1.0f, 0.9f + world.method_8409().method_43057() * 0.2f);
        for (i = 0; i < this.getExitPosList().size(); ++i) {
            world.method_8652(this.getExitPosList().get(i), BlockInit.DUNGEON_PORTAL.method_9564(), 3);
        }
        world.method_8652(this.getBossLootBlockPos(), class_2246.field_10034.method_9564(), 3);
        InventoryHelper.fillInventoryWithLoot(world.method_8503(), world, this.getBossLootBlockPos(), this.getDungeon().getDifficultyBossLootTableMap().get(this.getDifficulty()), this.getDisableEffects());
        this.setCooldownTime(this.getDungeon().getCooldown() + (int)this.method_10997().method_8510());
        this.method_5431();
    }

    @Nullable
    public Dungeon getDungeon() {
        return Dungeon.getDungeon(this.dungeonType);
    }

    public void setDungeonType(String dungeonType) {
        this.dungeonType = dungeonType;
    }

    public String getDungeonType() {
        return this.dungeonType;
    }

    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public void setDungeonStructureGenerated() {
        this.dungeonStructureGenerated = true;
    }

    public boolean isDungeonStructureGenerated() {
        return this.dungeonStructureGenerated;
    }

    public void joinDungeon(UUID playerUuid) {
        if (!this.dungeonPlayerUuids.contains(playerUuid)) {
            this.dungeonPlayerUuids.add(playerUuid);
        }
    }

    public void leaveDungeon(UUID playerUuid) {
        this.dungeonPlayerUuids.remove(playerUuid);
    }

    public int getDungeonPlayerCount() {
        return this.dungeonPlayerUuids.size();
    }

    public void setDungeonPlayerUuids(List<UUID> dungeonPlayerUuids) {
        this.dungeonPlayerUuids = dungeonPlayerUuids;
    }

    public List<UUID> getDungeonPlayerUuids() {
        return this.dungeonPlayerUuids;
    }

    public void addDeadDungeonPlayerUuids(UUID deadDungeonPlayerUuids) {
        this.deadDungeonPlayerUuids.add(deadDungeonPlayerUuids);
    }

    public void setDeadDungeonPlayerUuids(List<UUID> deadDungeonPlayerUuids) {
        this.deadDungeonPlayerUuids = deadDungeonPlayerUuids;
    }

    public List<UUID> getDeadDungeonPlayerUUIDs() {
        return this.deadDungeonPlayerUuids;
    }

    public void setBlockMap(HashMap<Integer, ArrayList<class_2338>> map) {
        this.blockBlockPosMap = map;
    }

    public HashMap<Integer, ArrayList<class_2338>> getBlockMap() {
        return this.blockBlockPosMap;
    }

    public void setCooldownTime(int cooldownTime) {
        this.cooldownTime = cooldownTime;
    }

    public int getCooldownTime() {
        return this.cooldownTime;
    }

    public boolean isOnCooldown(int currentTime) {
        return this.cooldownTime > currentTime;
    }

    public void setMaxGroupSize(int maxGroupSize) {
        this.maxGroupSize = maxGroupSize;
    }

    public void setMinGroupSize(int minGroupSize) {
        this.minGroupSize = minGroupSize;
    }

    public List<UUID> getWaitingUuids() {
        return this.waitingUuids;
    }

    public void addWaitingUuid(UUID uuid) {
        if (!this.waitingUuids.contains(uuid)) {
            this.waitingUuids.add(uuid);
        }
    }

    public int getMaxGroupSize() {
        return this.maxGroupSize;
    }

    public int getMinGroupSize() {
        return this.minGroupSize;
    }

    public void setDisableEffects(boolean disableEffects) {
        this.disableEffects = disableEffects;
    }

    public boolean getDisableEffects() {
        return this.disableEffects;
    }

    public void setPrivateGroup(boolean privateGroup) {
        this.privateGroup = privateGroup;
    }

    public boolean getPrivateGroup() {
        return this.privateGroup;
    }

    public void setBossBlockPos(class_2338 pos) {
        this.bossBlockPos = pos;
    }

    public class_2338 getBossBlockPos() {
        return this.bossBlockPos;
    }

    public void setBossLootBlockPos(class_2338 pos) {
        this.bossLootBlockPos = pos;
    }

    public class_2338 getBossLootBlockPos() {
        return this.bossLootBlockPos;
    }

    public void setChestPosList(List<class_2338> chestPosList) {
        this.chestPosList = chestPosList;
    }

    public List<class_2338> getChestPosList() {
        return this.chestPosList;
    }

    public void setGatePosList(List<class_2338> gatePosList) {
        this.gatePosList = gatePosList;
    }

    public List<class_2338> getGatePosList() {
        return this.gatePosList;
    }

    public void setExitPosList(List<class_2338> exitPosList) {
        this.exitPosList = exitPosList;
    }

    public List<class_2338> getExitPosList() {
        return this.exitPosList;
    }

    public void addDungeonEdge(int edgeX, int edgeY, int edgeZ) {
        this.dungeonEdgeList.add(edgeX);
        this.dungeonEdgeList.add(edgeY);
        this.dungeonEdgeList.add(edgeZ);
    }

    public List<Integer> getDungeonEdgeList() {
        return this.dungeonEdgeList;
    }

    public void setSpawnerPosEntityIdMap(HashMap<class_2338, Integer> spawnerPosEntityIdMap) {
        this.spawnerPosEntityIdMap = spawnerPosEntityIdMap;
    }

    public HashMap<class_2338, Integer> getSpawnerPosEntityIdMap() {
        return this.spawnerPosEntityIdMap;
    }

    public void setReplaceBlockIdMap(HashMap<class_2338, Integer> replacePosBlockIdMap) {
        this.replacePosBlockIdMap = replacePosBlockIdMap;
    }

    public void addReplaceBlockId(class_2338 pos, class_2248 block) {
        this.replacePosBlockIdMap.put(pos, class_7923.field_41175.method_10206((Object)block));
    }

    public HashMap<class_2338, Integer> getReplaceBlockIdMap() {
        return this.replacePosBlockIdMap;
    }

    public void startDungeonTeleportCountdown(class_3218 dungeonWorld) {
        this.dungeonTeleportCountdown = ConfigInit.CONFIG.defaultDungeonTeleportCountdown;
        boolean isDungeonStructureGenerated = this.isDungeonStructureGenerated();
        if (!isDungeonStructureGenerated) {
            this.setDungeonStructureGenerated();
            DungeonPlacementHandler.generateDungeonStructure(dungeonWorld, new class_2338(0, 0, 0).method_10069(this.method_11016().method_10263() * 16, 100, this.method_11016().method_10260() * 16), this);
        } else {
            DungeonPlacementHandler.prepareDungeon(dungeonWorld, this);
        }
        this.method_5431();
    }

    public int getdungeonTeleportCountdown() {
        return this.dungeonTeleportCountdown;
    }
}

