/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.core.util.PeripheralHelpers;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.ComponentAccess;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;

public final class WiredModemLocalPeripheral {
    private static final String NBT_PERIPHERAL_TYPE = "PeripheralType";
    private static final String NBT_PERIPHERAL_ID = "PeripheralId";
    private int id = -1;
    @Nullable
    private String type;
    @Nullable
    private IPeripheral peripheral;
    private final ComponentAccess<IPeripheral> peripherals;

    public WiredModemLocalPeripheral(ComponentAccess<IPeripheral> peripherals) {
        this.peripherals = peripherals;
    }

    public boolean attach(class_1937 world, class_2338 origin, class_2350 direction) {
        IPeripheral oldPeripheral = this.peripheral;
        this.peripheral = this.getPeripheralFrom(world, origin, direction);
        IPeripheral peripheral = this.peripheral;
        if (peripheral == null) {
            return oldPeripheral != null;
        }
        String type = peripheral.getType();
        int id = this.id;
        if (id > 0 && this.type == null) {
            this.type = type;
        } else if (id < 0 || !type.equals(this.type)) {
            this.type = type;
            this.id = ServerContext.get(Nullability.assertNonNull(world.method_8503())).getNextId("peripheral." + type);
        }
        return !PeripheralHelpers.equals(oldPeripheral, peripheral);
    }

    public boolean detach() {
        if (this.peripheral == null) {
            return false;
        }
        this.peripheral = null;
        return true;
    }

    @Nullable
    public String getConnectedName() {
        return this.peripheral != null ? this.type + "_" + this.id : null;
    }

    public boolean hasPeripheral() {
        return this.peripheral != null;
    }

    public void extendMap(Map<String, IPeripheral> peripherals) {
        if (this.peripheral != null) {
            peripherals.put(this.type + "_" + this.id, this.peripheral);
        }
    }

    public Map<String, IPeripheral> toMap() {
        return this.peripheral == null ? Map.of() : Map.of(this.type + "_" + this.id, this.peripheral);
    }

    public void write(class_2487 tag, String suffix) {
        if (this.id >= 0) {
            tag.method_10569(NBT_PERIPHERAL_ID + suffix, this.id);
        }
        if (this.type != null) {
            tag.method_10582(NBT_PERIPHERAL_TYPE + suffix, this.type);
        }
    }

    public void read(class_2487 tag, String suffix) {
        this.id = tag.method_10573(NBT_PERIPHERAL_ID + suffix, 99) ? tag.method_10550(NBT_PERIPHERAL_ID + suffix) : -1;
        this.type = tag.method_10573(NBT_PERIPHERAL_TYPE + suffix, 8) ? tag.method_10558(NBT_PERIPHERAL_TYPE + suffix) : null;
    }

    @Nullable
    private IPeripheral getPeripheralFrom(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2338 offset = pos.method_10093(direction);
        if (world.method_8320(offset).method_26164(ComputerCraftTags.Blocks.PERIPHERAL_HUB_IGNORE)) {
            return null;
        }
        IPeripheral peripheral = this.peripherals.get(direction);
        return peripheral instanceof WiredModemPeripheral ? null : peripheral;
    }
}

