/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.core.methods.NamedMethod;
import dan200.computercraft.core.methods.PeripheralMethod;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.peripheral.generic.SaturatedMethod;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GenericPeripheralBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GenericPeripheralBuilder.class);
    @Nullable
    private String name;
    private final Set<String> additionalTypes = new HashSet<String>(0);
    private final ArrayList<SaturatedMethod> methods = new ArrayList();

    GenericPeripheralBuilder() {
    }

    @Nullable
    IPeripheral toPeripheral(class_2586 blockEntity, class_2350 side) {
        String type;
        if (this.methods.isEmpty()) {
            return null;
        }
        if (this.name == null) {
            class_2960 typeId = class_2591.method_11033((class_2591)blockEntity.method_11017());
            if (typeId == null) {
                LOG.error("Block entity {} for {} was not registered. Skipping creating a generic peripheral for it.", (Object)blockEntity, (Object)blockEntity.method_11010().method_26204());
                return null;
            }
            type = typeId.toString();
        } else {
            type = this.name;
        }
        this.methods.trimToSize();
        return new GenericPeripheral(blockEntity, side, type, this.additionalTypes, this.methods);
    }

    void addMethod(Object target, String name, PeripheralMethod method, @Nullable NamedMethod<PeripheralMethod> info) {
        PeripheralType type;
        this.methods.add(new SaturatedMethod(target, name, method));
        PeripheralType peripheralType = type = info == null ? null : info.genericType();
        if (type != null && type.getPrimaryType() != null) {
            String primaryType = type.getPrimaryType();
            if (this.name == null || this.name.compareTo(primaryType) > 0) {
                this.name = primaryType;
            }
        }
        if (type != null) {
            this.additionalTypes.addAll(type.getAdditionalTypes());
        }
    }
}

