/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.item.relic.RelicItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class DiceOfFateItem
extends RelicItem {
    public static final Supplier<List<class_1799>> RELIC_STACKS = Suppliers.memoize(() -> List.of(new class_1799((class_1935)BotaniaItems.infiniteFruit), new class_1799((class_1935)BotaniaItems.kingKey), new class_1799((class_1935)BotaniaItems.flugelEye), new class_1799((class_1935)BotaniaItems.thorRing), new class_1799((class_1935)BotaniaItems.odinRing), new class_1799((class_1935)BotaniaItems.lokiRing)));

    public DiceOfFateItem(class_1792.class_1793 props) {
        super(props);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic != null && relic.isRightPlayer(player)) {
            if (world.field_9236) {
                return class_1271.method_22427((Object)stack);
            }
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.diceOfFate, class_3419.field_15248, 1.0f, 0.4f / (world.field_9229.method_43057() * 0.4f + 0.8f));
            ArrayList<Integer> possible = new ArrayList<Integer>();
            for (int i = 0; i < 6; ++i) {
                if (this.hasRelicAlready(player, i)) continue;
                possible.add(i);
            }
            if (!possible.isEmpty()) {
                int relicIdx = (Integer)possible.get(world.field_9229.method_43048(possible.size()));
                player.method_43496((class_2561)class_2561.method_43469((String)"botaniamisc.diceRoll", (Object[])new Object[]{relicIdx + 1}).method_27692(class_124.field_1077));
                class_1799 toGive = RELIC_STACKS.get().get(relicIdx).method_7972();
                return class_1271.method_22428((Object)toGive);
            }
            int roll = world.field_9229.method_43048(6) + 1;
            class_2960 tableId = ResourceLocationHelper.prefix("dice/roll_" + roll);
            class_52 table = world.method_8503().method_3857().getLootTable(tableId);
            class_8567 context = new class_8567.class_8568((class_3218)world).method_51874(class_181.field_1226, (Object)player).method_51874(class_181.field_24424, (Object)player.method_19538()).method_51871(player.method_7292()).method_51875(class_173.field_16235);
            ObjectArrayList generated = table.method_51878(context);
            for (class_1799 drop : generated) {
                player.method_31548().method_7398(drop);
            }
            String langKey = generated.isEmpty() ? "botaniamisc.dudDiceRoll" : "botaniamisc.diceRoll";
            player.method_43496((class_2561)class_2561.method_43469((String)langKey, (Object[])new Object[]{roll}).method_27692(class_124.field_1077));
            stack.method_7934(1);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        super.method_7851(stack, world, tooltip, flags);
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        TooltipHandler.addOnShift(tooltip, () -> {
            String name = stack.method_7922() + ".poem";
            for (int i = 0; i < 4; ++i) {
                tooltip.add((class_2561)class_2561.method_43471((String)(name + i)).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            }
        });
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, null){

            @Override
            public boolean shouldDamageWrongPlayer() {
                return false;
            }
        };
    }

    private boolean hasRelicAlready(class_1657 player, int relicId) {
        if (relicId < 0 || relicId > 6 || !(player instanceof class_3222)) {
            return true;
        }
        class_3222 mpPlayer = (class_3222)player;
        class_1799 stack = RELIC_STACKS.get().get(relicId);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic != null && relic.getAdvancement() != null) {
            return PlayerHelper.hasAdvancement(mpPlayer, relic.getAdvancement());
        }
        return false;
    }
}

