/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class ForcePushHelper
implements AutoCloseable {
    private static final ThreadLocal<Deque<class_2338>> forcePushOriginStack = ThreadLocal.withInitial(ArrayDeque::new);
    private static final ThreadLocal<Deque<Map.Entry<Boolean, class_2350>>> movementTypeContextStack = ThreadLocal.withInitial(ArrayDeque::new);

    public static boolean isForcePush() {
        return !forcePushOriginStack.get().isEmpty();
    }

    public static class_2338 getForcePushOrigin() {
        if (!ForcePushHelper.isForcePush()) {
            throw new IllegalStateException("Not currently performing a Force Relay or Force Lens push");
        }
        return forcePushOriginStack.get().peek();
    }

    public static void pushMovementTypeContext(boolean extending, class_2350 pushDir) {
        movementTypeContextStack.get().push(Map.entry(extending, pushDir));
    }

    public static void popMovementTypeContext() {
        movementTypeContextStack.get().pop();
    }

    public static boolean isExtendingMovementContext() {
        Map.Entry<Boolean, class_2350> entry = movementTypeContextStack.get().peek();
        return entry == null || entry.getKey() != false;
    }

    public static class_2350 getMovementContextDirection() {
        Map.Entry<Boolean, class_2350> entry = movementTypeContextStack.get().peek();
        return entry != null ? entry.getValue() : null;
    }

    public ForcePushHelper(class_2338 pushLocation) {
        forcePushOriginStack.get().push(pushLocation.method_10062());
    }

    @Override
    public void close() {
        forcePushOriginStack.get().pop();
    }
}

