/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.SparkBaseEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.SparkAugmentItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaSparkEntity
extends SparkBaseEntity
implements ManaSpark {
    private static final int TRANSFER_RATE = 1000;
    private static final String TAG_UPGRADE = "upgrade";
    private static final class_2940<Integer> UPGRADE = class_2945.method_12791(ManaSparkEntity.class, (class_2941)class_2943.field_13327);
    private final Set<ManaSpark> outgoingTransfers = Collections.newSetFromMap(new WeakHashMap());
    private final ArrayList<ManaSpark> transfersTowardsSelfToRegister = new ArrayList();
    private boolean shouldFilterTransfers = true;
    private boolean receiverWasFull = true;
    private boolean firstTick = true;

    public ManaSparkEntity(class_1299<ManaSparkEntity> type, class_1937 world) {
        super(type, world);
    }

    public ManaSparkEntity(class_1937 world) {
        this(BotaniaEntities.SPARK, world);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(UPGRADE, (Object)0);
    }

    @NotNull
    public class_1799 method_31480() {
        return new class_1799((class_1935)this.getSparkItem());
    }

    public void method_5773() {
        SparkAttachable tile;
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.firstTick) {
            this.updateTransfers();
        }
        if ((tile = this.getAttachedTile()) == null) {
            this.dropAndKill();
            return;
        }
        ManaReceiver receiver = this.getAttachedManaReceiver();
        SparkUpgradeType upgrade = this.getUpgrade();
        Collection<ManaSpark> transfers = this.getOutgoingTransfers();
        switch (upgrade) {
            case DISPERSIVE: {
                class_1657 player2;
                class_238 aabb = VecHelper.boxForRange(this.method_19538().method_38499(class_2350.class_2351.field_11052, this.method_23318() + (double)this.method_17682() / 2.0), 12.0);
                List players = this.method_37908().method_8390(class_1657.class, aabb, class_1301.field_6154);
                HashMap receivingPlayers = new HashMap();
                class_1799 input = new class_1799((class_1935)this.getSparkItem());
                for (class_1657 player2 : players) {
                    ArrayList<class_1799> stacks = new ArrayList<class_1799>();
                    stacks.addAll((Collection<class_1799>)player2.method_31548().field_7547);
                    stacks.addAll((Collection<class_1799>)player2.method_31548().field_7548);
                    class_1263 inv = BotaniaAPI.instance().getAccessoriesInventory(player2);
                    for (int i = 0; i < inv.method_5439(); ++i) {
                        stacks.add(inv.method_5438(i));
                    }
                    for (class_1799 stack : stacks) {
                        int recv;
                        HashMap<ManaItem, Integer> receivingStacks;
                        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
                        if (stack.method_7960() || manaItem == null || !manaItem.canReceiveManaFromItem(input)) continue;
                        boolean add = false;
                        if (!receivingPlayers.containsKey(player2)) {
                            add = true;
                            receivingStacks = new HashMap<ManaItem, Integer>();
                        } else {
                            receivingStacks = (HashMap<ManaItem, Integer>)receivingPlayers.get(player2);
                        }
                        if ((recv = Math.min(receiver.getCurrentMana(), Math.min(1000, manaItem.getMaxMana() - manaItem.getMana()))) <= 0) continue;
                        receivingStacks.put(manaItem, recv);
                        if (!add) continue;
                        receivingPlayers.put(player2, receivingStacks);
                    }
                }
                if (receivingPlayers.isEmpty()) break;
                ArrayList keys = new ArrayList(receivingPlayers.keySet());
                Collections.shuffle(keys);
                player2 = (class_1657)keys.iterator().next();
                Map items = (Map)receivingPlayers.get(player2);
                Map.Entry e = items.entrySet().iterator().next();
                ManaItem manaItem = (ManaItem)e.getKey();
                int cost = (Integer)e.getValue();
                int manaToPut = Math.min(receiver.getCurrentMana(), cost);
                manaItem.addMana(manaToPut);
                receiver.receiveMana(-manaToPut);
                this.particlesTowards((class_1297)player2);
                break;
            }
            case DOMINANT: {
                if (this.receiverWasFull && !receiver.isFull()) {
                    this.updateTransfers();
                }
                if (this.transfersTowardsSelfToRegister.isEmpty()) break;
                this.transfersTowardsSelfToRegister.remove(this.transfersTowardsSelfToRegister.size() - 1).registerTransfer(this);
                break;
            }
            default: {
                if (!this.receiverWasFull || receiver.isFull()) break;
                this.notifyOthers(this.getNetwork());
            }
        }
        this.receiverWasFull = receiver != null ? receiver.isFull() : true;
        if (!transfers.isEmpty()) {
            int manaTotal = Math.min(1000 * transfers.size(), receiver.getCurrentMana());
            int count = transfers.size();
            int manaSpent = 0;
            if (manaTotal > 0) {
                if (this.shouldFilterTransfers) {
                    this.filterTransfers();
                    this.shouldFilterTransfers = false;
                }
                for (ManaSpark spark : transfers) {
                    --count;
                    SparkAttachable attached = spark.getAttachedTile();
                    ManaReceiver attachedReceiver = spark.getAttachedManaReceiver();
                    if (attached == null || attachedReceiver == null || attachedReceiver.isFull() || spark.areIncomingTransfersDone()) {
                        this.shouldFilterTransfers = true;
                        continue;
                    }
                    int spend = Math.min(attached.getAvailableSpaceForMana(), (manaTotal - manaSpent) / (count + 1));
                    attachedReceiver.receiveMana(spend);
                    manaSpent += spend;
                    this.particlesTowards(spark.entity());
                }
                receiver.receiveMana(-manaSpent);
            }
        }
        this.firstTick = false;
    }

    @Override
    public void updateTransfers() {
        this.transfersTowardsSelfToRegister.clear();
        switch (this.getUpgrade()) {
            case RECESSIVE: {
                List<ManaSpark> otherSparks = SparkHelper.getSparksAround(this.method_37908(), this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), this.getNetwork());
                Collections.shuffle(otherSparks);
                for (ManaSpark otherSpark : otherSparks) {
                    SparkUpgradeType otherUpgrade = otherSpark.getUpgrade();
                    if (otherSpark == this || otherUpgrade == SparkUpgradeType.DOMINANT || otherUpgrade == SparkUpgradeType.RECESSIVE || otherUpgrade == SparkUpgradeType.ISOLATED) continue;
                    this.outgoingTransfers.add(otherSpark);
                }
                break;
            }
            case DOMINANT: {
                List<ManaSpark> validSparks = SparkHelper.getSparksAround(this.method_37908(), this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), this.getNetwork());
                for (ManaSpark spark : validSparks) {
                    SparkUpgradeType otherUpgrade = spark.getUpgrade();
                    if (spark == this || otherUpgrade != SparkUpgradeType.NONE || !(spark.getAttachedManaReceiver() instanceof ManaPool)) continue;
                    this.transfersTowardsSelfToRegister.add(spark);
                }
                Collections.shuffle(this.transfersTowardsSelfToRegister);
            }
        }
        this.filterTransfers();
    }

    private void particlesTowards(class_1297 e) {
        XplatAbstractions.INSTANCE.sendToTracking(this, new BotaniaEffectPacket(EffectType.SPARK_MANA_FLOW, this.method_23317(), this.method_23318(), this.method_23321(), this.method_5628(), e.method_5628(), ColorHelper.getColorValue(this.getNetwork())));
    }

    public static void particleBeam(class_1657 player, class_1297 e1, class_1297 e2) {
        if (e1 != null && e2 != null && !e1.method_37908().field_9236) {
            XplatAbstractions.INSTANCE.sendToPlayer(player, new BotaniaEffectPacket(EffectType.SPARK_NET_INDICATOR, e1.method_23317(), e1.method_23318(), e1.method_23321(), e1.method_5628(), e2.method_5628()));
        }
    }

    protected class_1792 getSparkItem() {
        return BotaniaItems.spark;
    }

    private void dropAndKill() {
        SparkUpgradeType upgrade = this.getUpgrade();
        this.method_5699(new class_1799((class_1935)this.getSparkItem()), 0.0f);
        if (upgrade != SparkUpgradeType.NONE) {
            this.method_5699(SparkAugmentItem.getByType(upgrade), 0.0f);
        }
        this.method_31472();
    }

    public void method_5650(class_1297.class_5529 removalReason) {
        super.method_5650(removalReason);
        this.notifyOthers(this.getNetwork());
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.method_5805() && !stack.method_7960()) {
            class_1769 dye;
            class_1767 color;
            SparkUpgradeType upgrade = this.getUpgrade();
            if (stack.method_7909() instanceof WandOfTheForestItem) {
                if (!this.method_37908().field_9236) {
                    if (player.method_5715()) {
                        if (upgrade != SparkUpgradeType.NONE) {
                            this.method_5699(SparkAugmentItem.getByType(upgrade), 0.0f);
                            this.setUpgrade(SparkUpgradeType.NONE);
                            this.outgoingTransfers.clear();
                            this.notifyOthers(this.getNetwork());
                        } else {
                            this.dropAndKill();
                        }
                    } else {
                        SparkHelper.getSparksAround(this.method_37908(), this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), this.getNetwork()).forEach(s -> ManaSparkEntity.particleBeam(player, this, s.entity()));
                    }
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof SparkAugmentItem) {
                SparkAugmentItem newUpgrade = (SparkAugmentItem)class_17922;
                if (upgrade == SparkUpgradeType.NONE) {
                    if (!this.method_37908().field_9236) {
                        this.setUpgrade(newUpgrade.type);
                        stack.method_7934(1);
                    }
                    return class_1269.method_29236((boolean)this.method_37908().field_9236);
                }
            }
            if (stack.method_31574(BotaniaItems.phantomInk)) {
                if (!this.method_37908().field_9236) {
                    this.method_5648(true);
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1769 && (color = (dye = (class_1769)class_17922).method_7802()) != this.getNetwork()) {
                if (!this.method_37908().field_9236) {
                    this.setNetwork(color);
                    stack.method_7934(1);
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
        }
        return class_1269.field_5811;
    }

    @Override
    protected void method_5749(@NotNull class_2487 cmp) {
        super.method_5749(cmp);
        this.setUpgrade(SparkUpgradeType.values()[cmp.method_10550(TAG_UPGRADE)]);
    }

    @Override
    protected void method_5652(@NotNull class_2487 cmp) {
        super.method_5652(cmp);
        cmp.method_10569(TAG_UPGRADE, this.getUpgrade().ordinal());
    }

    @Override
    public SparkAttachable getAttachedTile() {
        return XplatAbstractions.INSTANCE.findSparkAttachable(this.method_37908(), this.getAttachPos(), this.method_37908().method_8320(this.getAttachPos()), this.method_37908().method_8321(this.getAttachPos()), class_2350.field_11036);
    }

    @Override
    @Nullable
    public ManaReceiver getAttachedManaReceiver() {
        return XplatAbstractions.INSTANCE.findManaReceiver(this.method_37908(), this.getAttachPos(), class_2350.field_11036);
    }

    private void filterTransfers() {
        Iterator<ManaSpark> iter = this.outgoingTransfers.iterator();
        while (iter.hasNext()) {
            ManaSpark spark = iter.next();
            SparkUpgradeType upgr = this.getUpgrade();
            SparkUpgradeType supgr = spark.getUpgrade();
            ManaReceiver arecv = spark.getAttachedManaReceiver();
            if (spark != this && ((class_1297)spark).method_5805() && !spark.areIncomingTransfersDone() && this.getNetwork() == spark.getNetwork() && arecv != null && !arecv.isFull() && (upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT || upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE) || !(arecv instanceof ManaPool))) continue;
            iter.remove();
        }
    }

    @Override
    public Collection<ManaSpark> getOutgoingTransfers() {
        return this.outgoingTransfers;
    }

    private boolean hasTransfer(ManaSpark entity) {
        return this.outgoingTransfers.contains(entity);
    }

    @Override
    public void registerTransfer(ManaSpark entity) {
        if (this.hasTransfer(entity)) {
            return;
        }
        this.outgoingTransfers.add(entity);
        this.filterTransfers();
    }

    private void notifyOthers(class_1767 network) {
        for (ManaSpark spark : SparkHelper.getSparksAround(this.method_37908(), this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), network)) {
            spark.updateTransfers();
        }
    }

    @Override
    public SparkUpgradeType getUpgrade() {
        return SparkUpgradeType.values()[(Integer)this.field_6011.method_12789(UPGRADE)];
    }

    @Override
    public void setUpgrade(SparkUpgradeType upgrade) {
        this.field_6011.method_12778(UPGRADE, (Object)upgrade.ordinal());
        this.updateTransfers();
        this.notifyOthers(this.getNetwork());
    }

    @Override
    public void setNetwork(class_1767 color) {
        class_1767 previousNetwork = this.getNetwork();
        super.setNetwork(color);
        this.updateTransfers();
        this.notifyOthers(color);
        this.notifyOthers(previousNetwork);
    }

    @Override
    public boolean areIncomingTransfersDone() {
        if (this.getAttachedManaReceiver() instanceof ManaPool) {
            return false;
        }
        SparkAttachable attachable = this.getAttachedTile();
        return attachable != null && attachable.areIncomingTranfersDone();
    }

    public record WandHud(ManaSparkEntity entity) implements WandHUD
    {
        @Override
        public void renderHUD(class_332 gui, class_310 mc) {
            class_1799 sparkStack = new class_1799((class_1935)this.entity.getSparkItem());
            class_1799 augmentStack = SparkAugmentItem.getByType(this.entity.getUpgrade());
            class_1767 networkColor = this.entity.getNetwork();
            class_5250 networkColorName = class_2561.method_43471((String)("color.minecraft." + networkColor.method_7792())).method_27692(class_124.field_1056);
            int textColor = ColorHelper.getColorLegibleOnGrayBackground(networkColor);
            int width = 4 + Collections.max(Arrays.asList(mc.field_1772.method_27525((class_5348)networkColorName), RenderHelper.itemWithNameWidth(mc, sparkStack), RenderHelper.itemWithNameWidth(mc, augmentStack)));
            int height = augmentStack.method_7960() ? 30 : 50;
            int networkColorTextStart = mc.field_1772.method_27525((class_5348)networkColorName) / 2;
            int centerX = mc.method_22683().method_4486() / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            RenderHelper.renderHUDBox(gui, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 8 + height);
            RenderHelper.renderItemWithNameCentered(gui, mc, sparkStack, centerY + 10, textColor);
            RenderHelper.renderItemWithNameCentered(gui, mc, augmentStack, centerY + 28, textColor);
            gui.method_27535(mc.field_1772, (class_2561)networkColorName, centerX - networkColorTextStart, centerY + (augmentStack.method_7960() ? 28 : 46), textColor);
        }
    }
}

