/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class BergamuteBlockEntity
extends SpecialFlowerBlockEntity {
    private static final int RANGE = 4;
    private static final Set<BergamuteBlockEntity> clientFlowers = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<BergamuteBlockEntity> serverFlowers = Collections.newSetFromMap(new WeakHashMap());
    private boolean disabled = false;

    public BergamuteBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaFlowerBlocks.BERGAMUTE, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        this.disabled = this.method_10997().method_49803(this.method_11016());
        if (this.method_10997().field_9236) {
            clientFlowers.add(this);
        } else {
            serverFlowers.add(this);
        }
    }

    public void method_11012() {
        super.method_11012();
        if (this.method_10997().field_9236) {
            clientFlowers.remove(this);
        } else {
            serverFlowers.remove(this);
        }
    }

    public static Pair<Integer, BergamuteBlockEntity> getBergamutesNearby(class_1937 level, double x, double y, double z, int maxCount) {
        int count = 0;
        BergamuteBlockEntity tile = null;
        for (BergamuteBlockEntity f : level.field_9236 ? clientFlowers : serverFlowers) {
            if (f.disabled || level != f.field_11863 || !(f.getEffectivePos().method_10268(x, y, z) <= 16.0)) continue;
            if (++count == 1) {
                tile = f;
            }
            if (count < maxCount) continue;
            break;
        }
        return Pair.of((Object)count, tile);
    }

    public static boolean isBergamuteNearby(class_1937 level, double x, double y, double z) {
        return (Integer)BergamuteBlockEntity.getBergamutesNearby(level, x, y, z, 1).getFirst() > 0;
    }

    public static boolean isBergamuteOccludingVibration(class_1937 level, class_243 sourcePos, class_243 destPos) {
        class_2338 sourceBlockPos = class_2338.method_49638((class_2374)sourcePos);
        class_2338 destBlockPos = class_2338.method_49638((class_2374)destPos);
        class_243 sourceCenterPos = sourceBlockPos.method_46558();
        if (sourceBlockPos.equals((Object)destBlockPos)) {
            return BergamuteBlockEntity.isBergamuteNearby(level, sourceCenterPos.field_1352, sourceCenterPos.field_1351, sourceCenterPos.field_1350);
        }
        class_243 destCenterPos = destBlockPos.method_46558();
        class_243 vibrationTravelVector = sourceCenterPos.method_1035(destCenterPos);
        double vibrationTravelDist = vibrationTravelVector.method_1033();
        class_243 vibrationTravelDir = vibrationTravelVector.method_1029();
        for (BergamuteBlockEntity f : level.field_9236 ? clientFlowers : serverFlowers) {
            class_243 vecSourceToFlower;
            double travelPosition;
            class_243 closestPos;
            class_243 flowerPos;
            if (f.disabled || f.field_11863 != level || !((flowerPos = f.getEffectivePos().method_46558()).method_1025(closestPos = sourceCenterPos.method_1019(vibrationTravelDir.method_1021(travelPosition = class_3532.method_15350((double)vibrationTravelDir.method_1026(vecSourceToFlower = sourceCenterPos.method_1035(flowerPos)), (double)0.0, (double)vibrationTravelDist)))) <= 16.0)) continue;
            return true;
        }
        return false;
    }

    public static void particle(BergamuteBlockEntity berg) {
        int color = 50943;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 5);
        berg.emitParticle(data, 0.3 + Math.random() * 0.5, 0.5 + Math.random() * 0.5, 0.3 + Math.random() * 0.5, 0.0, 0.0, 0.0);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 4.0);
    }
}

